/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import javax.swing.border.AbstractBorder;

public class CenterTitleBorder
extends AbstractBorder {
    protected String title;
    protected int top = 16;
    protected int left = 0;
    protected int bottom = 0;
    protected int right = 0;

    public CenterTitleBorder(String title) {
        this.title = title;
    }

    public Insets getBorderInsets(Component c) {
        if (this.title == null || this.title.equals("")) {
            return new Insets(0, 0, 0, 0);
        }
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    public Insets getBorderInsets(Component c, Insets i) {
        if (this.title == null || this.title.equals("")) {
            i.top = 0;
            i.left = 0;
            i.right = 0;
            i.bottom = 0;
            return new Insets(0, 0, 0, 0);
        }
        i.top = this.top;
        i.left = this.left;
        i.right = this.right;
        i.bottom = this.bottom;
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D copy = (Graphics2D)g.create();
        if (copy != null) {
            try {
                AffineTransform insetMove = AffineTransform.getTranslateInstance(x, y);
                copy.transform(insetMove);
                FontMetrics fm = copy.getFontMetrics();
                copy.drawString(this.title, this.left + (width - this.left - this.right - fm.stringWidth(this.title)) / 2, (this.top + fm.getAscent()) / 2);
            }
            finally {
                copy.dispose();
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String v) {
        this.title = v;
    }
}

