/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.network;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.network.SiteImpl;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.JDBCLocation;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.JDBCTime;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.network.JDBCStation;
import edu.sc.seis.fissuresUtil.database.network.NetworkTable;
import edu.sc.seis.fissuresUtil.database.util.TableSetup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class JDBCSite
extends NetworkTable {
    private PreparedStatement getIfCommentExists;
    private PreparedStatement getByDBId;
    private PreparedStatement getSiteIdByDBId;
    private PreparedStatement getDBId;
    private PreparedStatement updateSite;
    private PreparedStatement putAll;
    private PreparedStatement getDBIdsForStaAndCode;
    private PreparedStatement putChanIdBits;
    private PreparedStatement getByChanIdBits;
    private PreparedStatement deleteSite;
    private PreparedStatement count;
    private PreparedStatement getAllForStationDbId;
    private JDBCLocation locTable;
    private JDBCSequence seq;
    private JDBCStation stationTable;
    private JDBCTime time;

    public JDBCSite() throws SQLException {
        this(ConnMgr.createConnection());
    }

    public JDBCSite(Connection conn) throws SQLException {
        this(conn, new JDBCLocation(conn), new JDBCStation(conn), new JDBCTime(conn));
    }

    public JDBCSite(Connection conn, JDBCLocation locTable, JDBCStation stationTable, JDBCTime time) throws SQLException {
        super("site", conn);
        this.locTable = locTable;
        this.stationTable = stationTable;
        this.time = time;
        this.seq = new JDBCSequence(conn, "SiteSeq");
        TableSetup.setup(this, "edu/sc/seis/fissuresUtil/database/props/network/default.props");
    }

    public Site get(int dbid) throws SQLException, NotFound {
        this.getByDBId.setInt(1, dbid);
        ResultSet rs = this.getByDBId.executeQuery();
        if (rs.next()) {
            return JDBCSite.extract(rs, this.locTable, this.stationTable, this.time);
        }
        throw new NotFound("No Site found for database id = " + dbid);
    }

    public int getDBId(SiteId id, Station staId) throws SQLException, NotFound {
        JDBCSite.insertId(id, staId, this.getDBId, 1, this.stationTable, this.time);
        ResultSet rs = this.getDBId.executeQuery();
        if (rs.next()) {
            return rs.getInt("site_id");
        }
        throw new NotFound("No such Site id in the db");
    }

    public int[] getDBIds(int[] possibleStaDbIds, String site_code) throws SQLException, NotFound {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < possibleStaDbIds.length; ++i) {
            this.getDBIdsForStaAndCode.setInt(1, possibleStaDbIds[i]);
            this.getDBIdsForStaAndCode.setString(2, site_code);
            ResultSet rs = this.getDBIdsForStaAndCode.executeQuery();
            while (rs.next()) {
                ids.add(new Integer(rs.getInt("site_id")));
            }
        }
        if (ids.size() > 0) {
            int[] intIds = new int[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                intIds[i] = (Integer)ids.get(i);
            }
            return intIds;
        }
        throw new NotFound("No sites in the database of code '" + site_code + "' for given station ids");
    }

    public SiteId getSiteId(int dbid) throws SQLException, NotFound {
        this.getSiteIdByDBId.setInt(1, dbid);
        ResultSet rs = this.getSiteIdByDBId.executeQuery();
        if (rs.next()) {
            return JDBCSite.extractId(rs, this.stationTable, this.time);
        }
        throw new NotFound("No SiteId found for database id = " + dbid);
    }

    public JDBCStation getStationTable() {
        return this.stationTable;
    }

    public int put(ChannelId id) throws SQLException {
        int sta_id = this.stationTable.put(id);
        this.getByChanIdBits.setInt(1, sta_id);
        this.getByChanIdBits.setString(2, id.site_code);
        ResultSet rs = this.getByChanIdBits.executeQuery();
        if (rs.next()) {
            return rs.getInt(1);
        }
        int dbid = this.seq.next();
        this.putChanIdBits.setInt(1, dbid);
        this.putChanIdBits.setInt(2, sta_id);
        this.putChanIdBits.setString(3, id.site_code);
        this.putChanIdBits.executeUpdate();
        return dbid;
    }

    public int put(Site site) throws SQLException {
        int dbid;
        try {
            dbid = this.getDBId(site.get_id(), site.my_station);
            this.getIfCommentExists.setInt(1, dbid);
            ResultSet rs = this.getIfCommentExists.executeQuery();
            if (!rs.next()) {
                int index = JDBCSite.insertOnlySite(site, this.updateSite, 1, this.locTable, this.time);
                this.updateSite.setInt(index, dbid);
                this.updateSite.executeUpdate();
            }
        }
        catch (NotFound notFound) {
            dbid = this.seq.next();
            this.putAll.setInt(1, dbid);
            JDBCSite.insertAll(site, this.putAll, 2, this.stationTable, this.locTable, this.time);
            this.putAll.executeUpdate();
        }
        return dbid;
    }

    public static Site extract(ResultSet rs, JDBCLocation locTable, JDBCStation stationTable, JDBCTime time) throws SQLException, NotFound {
        SiteId id = JDBCSite.extractId(rs, stationTable, time);
        return new SiteImpl(id, locTable.get(rs.getInt("loc_id")), new TimeRange(id.begin_time, time.get(rs.getInt("site_end_id"))), stationTable.get(rs.getInt("sta_id")), rs.getString("site_comment"));
    }

    public static SiteId extractId(ResultSet rs, JDBCStation staTable, JDBCTime time) throws SQLException {
        try {
            StationId staId = staTable.getStationId(rs.getInt("sta_id"));
            return new SiteId(staId.network_id, staId.station_code, rs.getString("site_code"), time.get(rs.getInt("site_begin_id")));
        }
        catch (NotFound e) {
            throw new RuntimeException("There is a foreign key constraint requiring that a sta_id be in the station table, but it just returned a not found for one such key.  This probably indicates a db problem!", e);
        }
    }

    public static int insertAll(Site site, PreparedStatement stmt, int index, JDBCStation stationTable, JDBCLocation locTable, JDBCTime time) throws SQLException {
        index = JDBCSite.insertId(site.get_id(), site.my_station, stmt, index, stationTable, time);
        index = JDBCSite.insertOnlySite(site, stmt, index, locTable, time);
        return index;
    }

    public static int insertId(SiteId id, Station sta, PreparedStatement stmt, int index, JDBCStation stationTable, JDBCTime time) throws SQLException {
        int sta_id = stationTable.put(sta);
        stmt.setInt(index++, sta_id);
        stmt.setString(index++, id.site_code);
        stmt.setInt(index++, time.put(id.begin_time));
        return index;
    }

    public static int insertOnlySite(Site site, PreparedStatement stmt, int index, JDBCLocation locTable, JDBCTime time) throws SQLException {
        stmt.setInt(index++, time.put(site.effective_time.end_time));
        stmt.setString(index++, site.comment);
        stmt.setInt(index++, locTable.put(site.my_location));
        return index;
    }

    public void cleanupVestigesOfLonelyChannelId(int currentSiteId) throws SQLException {
        this.getByDBId.setInt(1, currentSiteId);
        ResultSet rs = this.getByDBId.executeQuery();
        rs.next();
        int sta_id = rs.getInt("sta_id");
        this.deleteSite.setInt(1, currentSiteId);
        this.deleteSite.executeUpdate();
        SiteId[] sameStaIdSites = this.getAllSiteIdsForStationDbId(rs.getInt("sta_id"));
        if (sameStaIdSites.length == 0) {
            this.stationTable.cleanupVestigesOfLonelyChannelId(sta_id);
        }
    }

    public SiteId[] getAllSiteIdsForStationDbId(int sta_dbid) throws SQLException {
        this.getAllForStationDbId.setInt(1, sta_dbid);
        ResultSet rs = this.getAllForStationDbId.executeQuery();
        ArrayList<SiteId> out = new ArrayList<SiteId>();
        while (rs.next()) {
            out.add(JDBCSite.extractId(rs, this.getStationTable(), this.time));
        }
        return out.toArray(new SiteId[0]);
    }

    public int size() throws SQLException {
        ResultSet rs = this.count.executeQuery();
        rs.next();
        return rs.getInt(1);
    }
}

