/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.sc.seis.fissuresUtil.database.AbstractDb;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SeisInfoDb
extends AbstractDb {
    private PreparedStatement insertStmt;
    private PreparedStatement getStmt;
    private static SeisInfoDb seisInfoDb;

    private SeisInfoDb(String directoryName, String databaseName) {
        super(directoryName, databaseName);
        this.create();
    }

    public static SeisInfoDb getSeisInfoDb(String directoryName, String databaseName) {
        if (seisInfoDb == null) {
            seisInfoDb = new SeisInfoDb(directoryName, databaseName);
        }
        return seisInfoDb;
    }

    public void create() {
        try {
            this.connection = this.getConnection();
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate(" CREATE TABLE seisInfoDb (  seisName VARCHAR_IGNORECASE ,  fileids VARCHAR_IGNORECASE ) ");
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            this.insertStmt = this.connection.prepareStatement(" INSERT INTO seisInfoDb  VALUES (?, ?) ");
            this.getStmt = this.connection.prepareStatement(" SELECT fileids FROM seisInfoDb  WHERE seisName = ? ");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void insert(String seisName, String fileids) {
        try {
            this.insertStmt.setString(1, seisName);
            this.insertStmt.setString(2, fileids);
            this.insertStmt.executeUpdate();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    public String getFileIds(String seisName) {
        try {
            this.getStmt.setString(1, seisName);
            ResultSet rs = this.getStmt.executeQuery();
            if (rs.next()) {
                return rs.getString("fileids");
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return null;
    }
}

