/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Category;

public class ClockUtil {
    private static boolean warnBadBadClock = false;
    private static TimeInterval serverOffset = null;
    private static final TimeInterval ZERO_OFFSET = new TimeInterval(0.0, UnitImpl.SECOND);
    private static URL SEIS_SC_EDU_URL;
    private static Category logger;
    private static MicroSecondDate OLD_DATE;
    private static TimeInterval ONE_DAY;
    private static URL timeURL;

    public static TimeInterval getTimeOffset() {
        if (serverOffset == null) {
            try {
                serverOffset = ClockUtil.getServerTimeOffset();
            }
            catch (IOException e) {
                MicroSecondDate localNow = new MicroSecondDate();
                if (!warnBadBadClock && OLD_DATE.after((Date)localNow)) {
                    warnBadBadClock = true;
                    GlobalExceptionHandler.handle("Unable to check the time from the server and the computer's clock is obviously wrong. Please reset the clock on your computer to be closer to real time. \nComputer Time=" + localNow + "\nTime checking url=" + ClockUtil.getTimeURL(), e);
                }
                return ZERO_OFFSET;
            }
        }
        return serverOffset;
    }

    public static MicroSecondDate now() {
        return new MicroSecondDate().add(ClockUtil.getTimeOffset());
    }

    public static MicroSecondDate future() {
        return ClockUtil.now().add(ONE_DAY);
    }

    public static void setTimeURL(URL newTimeURL) {
        timeURL = newTimeURL;
        serverOffset = null;
    }

    public static URL getTimeURL() {
        return timeURL;
    }

    public static TimeInterval getServerTimeOffset() throws IOException {
        String str;
        if (timeURL == null) {
            ClockUtil.setTimeURL(SEIS_SC_EDU_URL);
        }
        URL url = timeURL;
        InputStream is = url.openStream();
        InputStreamReader isReader = new InputStreamReader(is);
        BufferedReader bufferedReader = new BufferedReader(isReader);
        String timeStr = null;
        while ((str = bufferedReader.readLine()) != null) {
            timeStr = str;
        }
        MicroSecondDate localTime = new MicroSecondDate();
        Time serverTime = new Time();
        if (timeStr != null) {
            serverTime = new Time(timeStr, -1);
        }
        MicroSecondDate serverDate = new MicroSecondDate(serverTime);
        TimeInterval offset = new TimeInterval(localTime, serverDate);
        return offset;
    }

    public static MicroSecondTimeRange today() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime((Date)ClockUtil.now());
        MicroSecondDate start = new MicroSecondDate(new Date(cal.get(1) - 1900, cal.get(2), cal.get(5), 0, 0, 0));
        MicroSecondDate end = new MicroSecondDate(new Date(cal.get(1) - 1900, cal.get(2), cal.get(5), 23, 59, 59));
        MicroSecondTimeRange range = new MicroSecondTimeRange(start, end);
        return range;
    }

    public static Calendar getGMTCalendar() {
        return new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    }

    static {
        logger = Category.getInstance((String)ClockUtil.class.getName());
        try {
            SEIS_SC_EDU_URL = new URL("http://www.seis.sc.edu/cgi-bin/date_time.pl");
        }
        catch (MalformedURLException e) {
            GlobalExceptionHandler.handle("Caught MalformedURL with seis data_time.pl URL. This should never happen.", e);
        }
        OLD_DATE = new ISOTime("2004-04-01T00:00:00.000Z").getDate();
        ONE_DAY = new TimeInterval(1.0, UnitImpl.DAY);
        timeURL = null;
    }
}

