/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.DataCenter;
import edu.iris.Fissures.IfSeismogramDC.DataCenterCallBack;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.sc.seis.fissuresUtil.cache.BulletproofVestFactory;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import org.apache.log4j.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class RetrySeismogramDC
implements ProxySeismogramDC {
    DataCenterOperations dc;
    int retry;
    private static final Logger logger = Logger.getLogger((Class)RetrySeismogramDC.class);

    public RetrySeismogramDC(DataCenterOperations dc, int retry) {
        this.dc = dc;
        this.retry = retry;
    }

    public void reset() {
    }

    public DataCenterOperations getWrappedDC() {
        return this.dc;
    }

    public DataCenterOperations getWrappedDC(Class wrappedClass) {
        if (this.getWrappedDC().getClass().equals(wrappedClass)) {
            return this.getWrappedDC();
        }
        if (this.getWrappedDC().getClass().equals(ProxySeismogramDC.class)) {
            ((ProxySeismogramDC)this.getWrappedDC()).getWrappedDC(wrappedClass);
        }
        throw new IllegalArgumentException("This RetryDataCenter doesn't contain a DC of class " + wrappedClass);
    }

    public Object getCorbaObject() {
        if (this.dc instanceof ProxySeismogramDC) {
            return ((ProxySeismogramDC)this.dc).getCorbaObject();
        }
        return (DataCenter)this.dc;
    }

    public void cancel_request(String a_request) throws FissuresException {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                this.dc.cancel_request(a_request);
                continue;
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((java.lang.Object)("Caught exception, retrying " + count), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public String request_seismograms(RequestFilter[] a_filterseq, DataCenterCallBack a_client, boolean long_lived, Time expiration_time) throws FissuresException {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.dc.request_seismograms(a_filterseq, a_client, long_lived, expiration_time);
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((java.lang.Object)("Caught exception, retrying " + count), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public LocalSeismogram[] retrieve_seismograms(RequestFilter[] a_filterseq) throws FissuresException {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.dc.retrieve_seismograms(a_filterseq);
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((java.lang.Object)("Caught exception, retrying " + count), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public LocalSeismogram[] retrieve_queue(String a_request) throws FissuresException {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.dc.retrieve_queue(a_request);
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((java.lang.Object)("Caught exception, retrying " + count), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public RequestFilter[] available_data(RequestFilter[] a_filterseq) {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.dc.available_data(a_filterseq);
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((java.lang.Object)("Caught exception, retrying " + count), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public String request_status(String a_request) throws FissuresException {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.dc.request_status(a_request);
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((java.lang.Object)("Caught exception, retrying " + count), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public String queue_seismograms(RequestFilter[] a_filterseq) throws FissuresException {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.dc.queue_seismograms(a_filterseq);
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((java.lang.Object)("Caught exception, retrying " + count), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public String toString() {
        return "Retry " + this.dc.toString();
    }
}

