/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.SamplingRange;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import java.util.ArrayList;

public class SamplingUtil {
    public static Channel[] inSampling(SamplingRange sampling, Channel[] chans) {
        double minSPS = SamplingUtil.getSamplesPerSecond(sampling.min);
        double maxSPS = SamplingUtil.getSamplesPerSecond(sampling.max);
        ArrayList<Channel> results = new ArrayList<Channel>();
        for (int i = 0; i < chans.length; ++i) {
            Channel chan = chans[i];
            double chanSPS = SamplingUtil.getSamplesPerSecond(chan.sampling_info);
            if (!(minSPS <= chanSPS) || !(chanSPS <= maxSPS)) continue;
            results.add(chan);
        }
        return results.toArray(new Channel[results.size()]);
    }

    private static double getSamplesPerSecond(Sampling sampling) {
        double numSeconds = new TimeInterval((Quantity)sampling.interval).convertTo((UnitImpl)UnitImpl.SECOND).value;
        return (double)sampling.numPoints / numSeconds;
    }
}

