/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.IfTimeSeries.EncodedData;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.Cut;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class EncodedCut
extends Cut {
    private static final Logger logger = Logger.getLogger((Class)EncodedCut.class);

    public EncodedCut(MicroSecondDate begin, MicroSecondDate end) {
        super(begin, end);
    }

    public EncodedCut(RequestFilter rf) {
        super(rf);
    }

    public LocalSeismogramImpl apply(LocalSeismogramImpl seis) throws FissuresException {
        if (!this.overlaps(seis)) {
            return null;
        }
        if (!seis.is_encoded()) {
            return super.apply(seis);
        }
        int beginIndex = this.getBeginIndex(seis);
        int endIndex = this.getEndIndex(seis);
        ArrayList<EncodedData> outData = new ArrayList<EncodedData>();
        EncodedData[] ed = seis.get_as_encoded();
        int currentPoint = 0;
        int firstUsedPoint = -1;
        int pointsInNewSeis = 0;
        for (int i = 0; i < ed.length && currentPoint < endIndex; currentPoint += ed[i].num_points, ++i) {
            if (currentPoint + ed[i].num_points <= beginIndex) continue;
            outData.add(ed[i]);
            pointsInNewSeis += ed[i].num_points;
            if (firstUsedPoint != -1) continue;
            firstUsedPoint = currentPoint;
        }
        TimeSeriesDataSel ds = new TimeSeriesDataSel();
        ds.encoded_values(outData.toArray(new EncodedData[outData.size()]));
        logger.debug((Object)(outData.size() + " encoded segments matched cut"));
        LocalSeismogramImpl outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, ds);
        outSeis.begin_time = seis.getBeginTime().add((TimeInterval)seis.getSampling().getPeriod().multiplyBy((double)firstUsedPoint)).getFissuresTime();
        outSeis.num_points = pointsInNewSeis;
        return outSeis;
    }
}

