/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.wave;

import gov.usgs.swarm.Images;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.SwarmUtil;
import gov.usgs.swarm.Throbber;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.swarm.wave.WaveClipboardFrame;
import gov.usgs.swarm.wave.WaveViewPanel;
import gov.usgs.swarm.wave.WaveViewSettings;
import gov.usgs.swarm.wave.WaveViewSettingsToolbar;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.wave.Wave;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class WaveViewerFrame
extends JInternalFrame
implements Runnable {
    public static final long serialVersionUID = -1L;
    private long interval = 2000L;
    private static final int[] SPANS = new int[]{15, 30, 60, 120, 180, 240, 300};
    private int spanIndex;
    private SeismicDataSource dataSource;
    private String channel;
    private Thread updateThread;
    private boolean kill;
    private JToolBar toolBar;
    private WaveViewSettings settings;
    private WaveViewPanel waveViewPanel;
    private JPanel mainPanel;
    private JPanel wavePanel;
    private Throbber throbber;

    public WaveViewerFrame(SeismicDataSource sds, String ch) {
        super(String.valueOf(ch) + ", [" + sds + "]", true, true, false, true);
        this.dataSource = sds;
        this.channel = ch;
        this.settings = new WaveViewSettings();
        this.spanIndex = 3;
        this.kill = false;
        this.updateThread = new Thread((Runnable)this, "WaveViewerFrame-" + sds + "-" + ch);
        this.createUI();
    }

    public void createUI() {
        this.setFrameIcon(Images.getIcon("wave"));
        this.mainPanel = new JPanel(new BorderLayout());
        this.waveViewPanel = new WaveViewPanel(this.settings);
        this.wavePanel = new JPanel(new BorderLayout());
        this.wavePanel.add((Component)this.waveViewPanel, "Center");
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 3, 3), LineBorder.createGrayLineBorder());
        this.wavePanel.setBorder(border);
        this.mainPanel.add((Component)this.wavePanel, "Center");
        this.toolBar = SwarmUtil.createToolBar();
        JButton compXButton = SwarmUtil.createToolBarButton(Images.getIcon("xminus"), "Shrink time axis (Alt-left arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WaveViewerFrame.this.spanIndex != 0) {
                    WaveViewerFrame waveViewerFrame = WaveViewerFrame.this;
                    waveViewerFrame.spanIndex = waveViewerFrame.spanIndex - 1;
                }
            }
        });
        Util.mapKeyStrokeToButton(this, "alt LEFT", "compx", compXButton);
        this.toolBar.add(compXButton);
        JButton expXButton = SwarmUtil.createToolBarButton(Images.getIcon("xplus"), "Expand time axis (Alt-right arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WaveViewerFrame.this.spanIndex < SPANS.length - 1) {
                    WaveViewerFrame waveViewerFrame = WaveViewerFrame.this;
                    waveViewerFrame.spanIndex = waveViewerFrame.spanIndex + 1;
                }
            }
        });
        Util.mapKeyStrokeToButton(this, "alt RIGHT", "expx", expXButton);
        this.toolBar.add(expXButton);
        this.toolBar.addSeparator();
        new WaveViewSettingsToolbar(this.settings, this.toolBar, this);
        JButton clipboard = SwarmUtil.createToolBarButton(Images.getIcon("clipboard"), "Copy wave to clipboard (C or Ctrl-C)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WaveViewerFrame.this.waveViewPanel != null) {
                    WaveClipboardFrame cb = Swarm.getApplication().getWaveClipboard();
                    cb.setVisible(true);
                    cb.addWave(new WaveViewPanel(WaveViewerFrame.this.waveViewPanel));
                }
            }
        });
        Util.mapKeyStrokeToButton(this, "C", "clipboard1", clipboard);
        Util.mapKeyStrokeToButton(this, "control C", "clipboard2", clipboard);
        this.toolBar.add(clipboard);
        this.toolBar.addSeparator();
        this.toolBar.add(Box.createHorizontalGlue());
        this.throbber = new Throbber();
        this.toolBar.add(this.throbber);
        this.mainPanel.add((Component)this.toolBar, "North");
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                if (WaveViewerFrame.this.channel != null) {
                    Swarm.getApplication().getDataChooser().setNearest(WaveViewerFrame.this.channel);
                }
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                WaveViewerFrame.this.throbber.close();
                WaveViewerFrame.this.kill();
                Swarm.getApplication().removeInternalFrame(WaveViewerFrame.this);
                WaveViewerFrame.this.dataSource.close();
            }
        });
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.mainPanel);
        this.setSize(750, 280);
        this.setVisible(true);
        this.updateThread.start();
    }

    public void getWave() {
        this.throbber.increment();
        double now = CurrentTime.getInstance().nowJ2K();
        Wave sw = this.dataSource.getWave(this.channel, now - (double)SPANS[this.spanIndex], now);
        this.waveViewPanel.setWorking(true);
        this.waveViewPanel.setWave(sw, now - (double)SPANS[this.spanIndex], now);
        this.waveViewPanel.setChannel(this.channel);
        this.waveViewPanel.setDataSource(this.dataSource);
        this.waveViewPanel.setWorking(false);
        this.waveViewPanel.repaint();
        this.throbber.decrement();
    }

    public void kill() {
        this.kill = true;
        this.updateThread.interrupt();
    }

    @Override
    public void run() {
        while (!this.kill) {
            try {
                this.getWave();
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.dataSource.close();
    }
}

