/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.wave;

import gov.usgs.swarm.Images;
import gov.usgs.swarm.Metadata;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.SwarmFrame;
import gov.usgs.swarm.SwarmUtil;
import gov.usgs.swarm.SwingWorker;
import gov.usgs.swarm.Throbber;
import gov.usgs.swarm.TimeListener;
import gov.usgs.swarm.data.CachedDataSource;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.swarm.heli.HelicorderViewPanelListener;
import gov.usgs.swarm.wave.WaveViewPanel;
import gov.usgs.swarm.wave.WaveViewPanelAdapter;
import gov.usgs.swarm.wave.WaveViewPanelListener;
import gov.usgs.swarm.wave.WaveViewSettingsToolbar;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.util.png.PngEncoderB;
import gov.usgs.util.ui.ExtensionFileFilter;
import gov.usgs.vdx.data.wave.SAC;
import gov.usgs.vdx.data.wave.Wave;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class WaveClipboardFrame
extends SwarmFrame {
    public static final long serialVersionUID = -1L;
    private static final Color SELECT_COLOR = new Color(200, 220, 241);
    private static final Color BACKGROUND_COLOR = new Color(247, 247, 247);
    private JScrollPane scrollPane;
    private Box waveBox;
    private List<WaveViewPanel> waves;
    private Set<WaveViewPanel> selectedSet;
    private JToolBar toolbar;
    private JPanel mainPanel;
    private JLabel statusLabel;
    private JToggleButton linkButton;
    private JButton sizeButton;
    private JButton syncButton;
    private JButton sortButton;
    private JButton removeAllButton;
    private JButton saveButton;
    private JButton saveAllButton;
    private JButton openButton;
    private JButton captureButton;
    private JButton histButton;
    private DateFormat saveAllDateFormat;
    private WaveViewPanelListener selectListener;
    private WaveViewSettingsToolbar waveToolbar;
    private JButton upButton;
    private JButton downButton;
    private JButton removeButton;
    private JButton compXButton;
    private JButton expXButton;
    private JButton copyButton;
    private JButton forwardButton;
    private JButton backButton;
    private JButton gotoButton;
    private JPopupMenu popup;
    private Map<WaveViewPanel, Stack<double[]>> histories;
    private HelicorderViewPanelListener linkListener;
    private boolean heliLinked = true;
    private Throbber throbber;
    private int waveHeight = -1;
    private int lastClickedIndex = -1;

    public WaveClipboardFrame() {
        super("Wave Clipboard", true, true, true, false);
        this.setFocusable(true);
        this.selectedSet = new HashSet<WaveViewPanel>();
        this.saveAllDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        this.saveAllDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.waves = new ArrayList<WaveViewPanel>();
        this.histories = new HashMap<WaveViewPanel, Stack<double[]>>();
        this.createUI();
        this.linkListener = new HelicorderViewPanelListener(){

            @Override
            public void insetCreated(double st, double et) {
                if (WaveClipboardFrame.this.heliLinked) {
                    WaveClipboardFrame.this.repositionWaves(st, et);
                }
            }
        };
    }

    public HelicorderViewPanelListener getLinkListener() {
        return this.linkListener;
    }

    private void createUI() {
        this.setFrameIcon(Images.getIcon("clipboard"));
        this.setSize(Swarm.config.clipboardWidth, Swarm.config.clipboardHeight);
        this.setLocation(Swarm.config.clipboardX, Swarm.config.clipboardY);
        this.setDefaultCloseOperation(0);
        this.toolbar = SwarmUtil.createToolBar();
        this.mainPanel = new JPanel(new BorderLayout());
        this.createMainButtons();
        this.createWaveButtons();
        this.mainPanel.add((Component)this.toolbar, "North");
        this.waveBox = new Box(1);
        this.scrollPane = new JScrollPane(this.waveBox);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(40);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 1));
        this.mainPanel.add((Component)this.statusLabel, "South");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 1, 2));
        this.setContentPane(this.mainPanel);
        this.createListeners();
        this.doButtonEnables();
    }

    private void createMainButtons() {
        this.openButton = SwarmUtil.createToolBarButton(Images.getIcon("open"), "Open a saved wave", new OpenActionListener());
        this.toolbar.add(this.openButton);
        this.saveButton = SwarmUtil.createToolBarButton(Images.getIcon("save"), "Save selected wave", new SaveActionListener());
        this.saveButton.setEnabled(false);
        this.toolbar.add(this.saveButton);
        this.saveAllButton = SwarmUtil.createToolBarButton(Images.getIcon("saveall"), "Save all waves", new SaveAllActionListener());
        this.saveAllButton.setEnabled(false);
        this.toolbar.add(this.saveAllButton);
        this.toolbar.addSeparator();
        this.linkButton = SwarmUtil.createToolBarToggleButton(Images.getIcon("helilink"), "Synchronize times with helicorder wave", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame.this.heliLinked = WaveClipboardFrame.this.linkButton.isSelected();
            }
        });
        this.linkButton.setSelected(this.heliLinked);
        this.toolbar.add(this.linkButton);
        this.syncButton = SwarmUtil.createToolBarButton(Images.getIcon("clock"), "Synchronize times with selected wave", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame.this.syncChannels();
            }
        });
        this.syncButton.setEnabled(false);
        this.toolbar.add(this.syncButton);
        this.sortButton = SwarmUtil.createToolBarButton(Images.getIcon("geosort"), "Sort waves by nearest to selected wave", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame.this.sortChannelsByNearest();
            }
        });
        this.sortButton.setEnabled(false);
        this.toolbar.add(this.sortButton);
        this.toolbar.addSeparator();
        this.sizeButton = SwarmUtil.createToolBarButton(Images.getIcon("resize"), "Set clipboard wave size", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame.this.doSizePopup(WaveClipboardFrame.this.sizeButton.getX(), WaveClipboardFrame.this.sizeButton.getY() + 2 * WaveClipboardFrame.this.sizeButton.getHeight());
            }
        });
        this.toolbar.add(this.sizeButton);
        this.removeAllButton = SwarmUtil.createToolBarButton(Images.getIcon("deleteall"), "Remove all waves from clipboard", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame.this.removeWaves();
            }
        });
        this.removeAllButton.setEnabled(false);
        this.toolbar.add(this.removeAllButton);
        this.toolbar.addSeparator();
        this.captureButton = SwarmUtil.createToolBarButton(Images.getIcon("camera"), "Save clipboard image (P)", new CaptureActionListener());
        Util.mapKeyStrokeToButton(this, "P", "capture", this.captureButton);
        this.toolbar.add(this.captureButton);
    }

    private void createWaveButtons() {
        this.toolbar.addSeparator();
        this.backButton = SwarmUtil.createToolBarButton(Images.getIcon("left"), "Scroll back time 20% (Left arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame.this.shiftTime(-0.2);
            }
        });
        Util.mapKeyStrokeToButton(this, "LEFT", "backward1", this.backButton);
        this.toolbar.add(this.backButton);
        this.forwardButton = SwarmUtil.createToolBarButton(Images.getIcon("right"), "Scroll forward time 20% (Right arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame.this.shiftTime(0.2);
            }
        });
        this.toolbar.add(this.forwardButton);
        Util.mapKeyStrokeToButton(this, "RIGHT", "forward1", this.forwardButton);
        this.gotoButton = SwarmUtil.createToolBarButton(Images.getIcon("gototime"), "Go to time (Ctrl-G)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String t = JOptionPane.showInputDialog(Swarm.getApplication(), "Input time in 'YYYYMMDDhhmm[ss]' format:", "Go to Time", -1);
                if (t != null) {
                    WaveClipboardFrame.this.gotoTime(t);
                }
            }
        });
        this.toolbar.add(this.gotoButton);
        Util.mapKeyStrokeToButton(this, "ctrl G", "goto", this.gotoButton);
        this.compXButton = SwarmUtil.createToolBarButton(Images.getIcon("xminus"), "Shrink sample time 20% (Alt-left arrow, +)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame.this.scaleTime(0.2);
            }
        });
        this.toolbar.add(this.compXButton);
        Util.mapKeyStrokeToButton(this, "alt LEFT", "compx", this.compXButton);
        Util.mapKeyStrokeToButton(this, "EQUALS", "compx2", this.compXButton);
        Util.mapKeyStrokeToButton(this, "shift EQUALS", "compx2", this.compXButton);
        this.expXButton = SwarmUtil.createToolBarButton(Images.getIcon("xplus"), "Expand sample time 20% (Alt-right arrow, -)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame.this.scaleTime(-0.2);
            }
        });
        this.toolbar.add(this.expXButton);
        Util.mapKeyStrokeToButton(this, "alt RIGHT", "expx", this.expXButton);
        Util.mapKeyStrokeToButton(this, "MINUS", "expx", this.expXButton);
        this.histButton = SwarmUtil.createToolBarButton(Images.getIcon("timeback"), "Last time settings (Backspace)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame.this.back();
            }
        });
        Util.mapKeyStrokeToButton(this, "BACK_SPACE", "back", this.histButton);
        this.toolbar.add(this.histButton);
        this.toolbar.addSeparator();
        this.waveToolbar = new WaveViewSettingsToolbar(null, this.toolbar, this);
        this.copyButton = SwarmUtil.createToolBarButton(Images.getIcon("clipboard"), "Place another copy of wave on clipboard (C or Ctrl-C)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        Util.mapKeyStrokeToButton(this, "C", "clipboard1", this.copyButton);
        Util.mapKeyStrokeToButton(this, "control C", "clipboard2", this.copyButton);
        this.toolbar.add(this.copyButton);
        this.toolbar.addSeparator();
        this.upButton = SwarmUtil.createToolBarButton(Images.getIcon("up"), "Move wave up in clipboard (Up arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame.this.moveUp();
            }
        });
        Util.mapKeyStrokeToButton(this, "UP", "up", this.upButton);
        this.toolbar.add(this.upButton);
        this.downButton = SwarmUtil.createToolBarButton(Images.getIcon("down"), "Move wave down in clipboard (Down arrow)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame.this.moveDown();
            }
        });
        Util.mapKeyStrokeToButton(this, "DOWN", "down", this.downButton);
        this.toolbar.add(this.downButton);
        this.removeButton = SwarmUtil.createToolBarButton(Images.getIcon("delete"), "Remove wave from clipboard (Delete)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame.this.remove();
            }
        });
        Util.mapKeyStrokeToButton(this, "DELETE", "remove", this.removeButton);
        this.toolbar.add(this.removeButton);
        this.toolbar.add(Box.createHorizontalGlue());
        this.throbber = new Throbber();
        this.toolbar.add(this.throbber);
        Util.mapKeyStrokeToAction(this, "control A", "selectAll", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                for (WaveViewPanel wave : WaveClipboardFrame.this.waves) {
                    WaveClipboardFrame.this.select(wave);
                }
            }
        });
    }

    private void createListeners() {
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent e) {
                WaveClipboardFrame.this.resizeWaves();
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                WaveClipboardFrame.this.setVisible(false);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WaveClipboardFrame.this.resizeWaves();
            }
        });
        Swarm.getApplication().addTimeListener(new TimeListener(){

            @Override
            public void timeChanged(double j2k) {
                for (WaveViewPanel panel : WaveClipboardFrame.this.waves) {
                    if (panel == null) continue;
                    panel.setCursorMark(j2k);
                }
            }
        });
        this.selectListener = new WaveViewPanelAdapter(){

            @Override
            public void mousePressed(WaveViewPanel src, MouseEvent e, boolean dragging) {
                WaveClipboardFrame.this.requestFocusInWindow();
                int thisIndex = WaveClipboardFrame.this.getWaveIndex(src);
                if (!(e.isControlDown() || e.isShiftDown() || e.isAltDown())) {
                    WaveClipboardFrame.this.deselectAll();
                    WaveClipboardFrame.this.select(src);
                } else if (e.isControlDown()) {
                    if (WaveClipboardFrame.this.selectedSet.contains(src)) {
                        WaveClipboardFrame.this.deselect(src);
                    } else {
                        WaveClipboardFrame.this.select(src);
                    }
                } else if (e.isShiftDown()) {
                    if (WaveClipboardFrame.this.lastClickedIndex == -1) {
                        WaveClipboardFrame.this.select(src);
                    } else {
                        WaveClipboardFrame.this.deselectAll();
                        int min = Math.min(WaveClipboardFrame.this.lastClickedIndex, thisIndex);
                        int max = Math.max(WaveClipboardFrame.this.lastClickedIndex, thisIndex);
                        int i = min;
                        while (i <= max) {
                            WaveViewPanel ps = (WaveViewPanel)WaveClipboardFrame.this.waveBox.getComponent(i);
                            WaveClipboardFrame.this.select(ps);
                            ++i;
                        }
                    }
                }
                WaveClipboardFrame.this.lastClickedIndex = thisIndex;
            }

            @Override
            public void waveZoomed(WaveViewPanel src, double st, double et, double nst, double net) {
                double[] t = new double[]{st, et};
                WaveClipboardFrame.this.addHistory(src, t);
                for (WaveViewPanel wvp : WaveClipboardFrame.this.selectedSet) {
                    if (wvp == src) continue;
                    WaveClipboardFrame.this.addHistory(wvp, t);
                    wvp.zoom(nst, net);
                }
            }

            @Override
            public void waveClosed(WaveViewPanel src) {
                WaveClipboardFrame.this.remove(src);
            }
        };
    }

    private int calculateWaveHeight() {
        if (this.waveHeight > 0) {
            return this.waveHeight;
        }
        int w = this.scrollPane.getViewport().getSize().width;
        int h = (int)Math.round((double)w * 60.0 / 300.0);
        h = Math.min(200, h);
        h = Math.max(h, 80);
        return h;
    }

    private void setWaveHeight(int s) {
        this.waveHeight = s;
        this.resizeWaves();
    }

    private void doSizePopup(int x, int y) {
        if (this.popup == null) {
            String[] stringArray = new String[6];
            stringArray[0] = "Auto";
            stringArray[2] = "Tiny";
            stringArray[3] = "Small";
            stringArray[4] = "Medium";
            stringArray[5] = "Large";
            String[] labels = stringArray;
            int[] sizes = new int[]{-1, -1, 50, 100, 160, 230};
            this.popup = new JPopupMenu();
            ButtonGroup group = new ButtonGroup();
            int i = 0;
            while (i < labels.length) {
                if (labels[i] != null) {
                    final int size = sizes[i];
                    JRadioButtonMenuItem mi = new JRadioButtonMenuItem(labels[i]);
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            WaveClipboardFrame.this.setWaveHeight(size);
                        }
                    });
                    if (this.waveHeight == size) {
                        mi.setSelected(true);
                    }
                    group.add(mi);
                    this.popup.add(mi);
                } else {
                    this.popup.addSeparator();
                }
                ++i;
            }
        }
        this.popup.show(this, x, y);
    }

    private SAC readSAC(File f) {
        SAC sac = new SAC();
        try {
            sac.read(f.getPath());
        }
        catch (Exception ex) {
            sac = null;
        }
        return sac;
    }

    public void openFile(File f) {
        SAC sac = null;
        Wave sw = null;
        String channel = f.getName();
        FileType ft = FileType.fromFile(f);
        switch (ft) {
            case SAC: {
                sac = this.readSAC(f);
                break;
            }
            case TEXT: {
                sw = Wave.importFromText(f.getPath());
                break;
            }
            case UNKNOWN: {
                sac = this.readSAC(f);
                if (sac != null) break;
                sw = Wave.importFromText(f.getPath());
            }
        }
        if (sac != null) {
            sw = sac.toWave();
            channel = sac.getWinstonChannel().replace('$', ' ');
        }
        if (sw != null) {
            WaveViewPanel wvp = new WaveViewPanel();
            wvp.setChannel(channel);
            Swarm.getCache().putWave(channel, sw);
            wvp.setDataSource(Swarm.getCache());
            wvp.setWave(sw, sw.getStartTime(), sw.getEndTime());
            this.addWave(new WaveViewPanel(wvp));
        } else {
            JOptionPane.showMessageDialog(Swarm.getApplication(), "There was an error opening the file, '" + f.getName() + "'.", "Error", 0);
        }
    }

    private void doButtonEnables() {
        boolean enable = this.waves == null || this.waves.size() == 0;
        this.saveButton.setEnabled(!enable);
        this.sortButton.setEnabled(!enable);
        this.saveAllButton.setEnabled(!enable);
        this.syncButton.setEnabled(!enable);
        this.removeAllButton.setEnabled(!enable);
        this.saveAllButton.setEnabled(!enable);
        boolean allowSingle = this.selectedSet.size() == 1;
        this.upButton.setEnabled(allowSingle);
        this.downButton.setEnabled(allowSingle);
        this.sortButton.setEnabled(allowSingle);
        this.syncButton.setEnabled(allowSingle);
        this.saveButton.setEnabled(allowSingle);
        boolean allowMulti = this.selectedSet.size() > 0;
        this.backButton.setEnabled(allowMulti);
        this.expXButton.setEnabled(allowMulti);
        this.compXButton.setEnabled(allowMulti);
        this.backButton.setEnabled(allowMulti);
        this.forwardButton.setEnabled(allowMulti);
        this.histButton.setEnabled(allowMulti);
        this.removeButton.setEnabled(allowMulti);
        this.gotoButton.setEnabled(allowMulti);
    }

    public synchronized void sortChannelsByNearest() {
        WaveViewPanel p = this.getSingleSelected();
        if (p == null) {
            return;
        }
        ArrayList<WaveViewPanel> sorted = new ArrayList<WaveViewPanel>(this.waves.size());
        for (WaveViewPanel wave : this.waves) {
            sorted.add(wave);
        }
        final Metadata smd = Swarm.config.getMetadata(p.getChannel());
        if (smd == null || Double.isNaN(smd.getLongitude()) || Double.isNaN(smd.getLatitude())) {
            return;
        }
        Collections.sort(sorted, new Comparator<WaveViewPanel>(){

            @Override
            public int compare(WaveViewPanel wvp1, WaveViewPanel wvp2) {
                Metadata md = Swarm.config.getMetadata(wvp1.getChannel());
                double d1 = smd.distanceTo(md);
                md = Swarm.config.getMetadata(wvp2.getChannel());
                double d2 = smd.distanceTo(md);
                return Double.compare(d1, d2);
            }
        });
        this.removeWaves();
        for (WaveViewPanel wave : sorted) {
            this.addWave(wave);
        }
        this.select(p);
    }

    public synchronized WaveViewPanel getSingleSelected() {
        if (this.selectedSet.size() != 1) {
            return null;
        }
        WaveViewPanel p = null;
        Iterator<WaveViewPanel> iterator = this.selectedSet.iterator();
        while (iterator.hasNext()) {
            WaveViewPanel panel;
            p = panel = iterator.next();
        }
        return p;
    }

    public synchronized void syncChannels() {
        final WaveViewPanel p = this.getSingleSelected();
        if (p == null) {
            return;
        }
        final double st = p.getStartTime();
        final double et = p.getEndTime();
        SwingWorker worker = new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object construct() {
                ArrayList copy = null;
                WaveClipboardFrame waveClipboardFrame = WaveClipboardFrame.this;
                synchronized (waveClipboardFrame) {
                    copy = new ArrayList(WaveClipboardFrame.this.waves);
                }
                for (WaveViewPanel wvp : copy) {
                    if (wvp == p || wvp.getDataSource() == null) continue;
                    WaveClipboardFrame.this.addHistory(wvp, new double[]{wvp.getStartTime(), wvp.getEndTime()});
                    Wave sw = wvp.getDataSource().getWave(wvp.getChannel(), st, et);
                    wvp.setWave(sw, st, et);
                }
                return null;
            }

            @Override
            public void finished() {
                WaveClipboardFrame.this.repaint();
            }
        };
        worker.start();
    }

    public void setStatusText(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WaveClipboardFrame.this.statusLabel.setText(s);
            }
        });
    }

    public WaveViewPanel getSelected() {
        return null;
    }

    public synchronized void addWave(WaveViewPanel p) {
        p.addListener(this.selectListener);
        p.setOffsets(54, 8, 21, 19);
        p.setAllowClose(true);
        p.setStatusLabel(this.statusLabel);
        p.setAllowDragging(true);
        p.setDisplayTitle(true);
        int w = this.scrollPane.getViewport().getSize().width;
        p.setSize(w, this.calculateWaveHeight());
        p.setBottomBorderColor(Color.GRAY);
        p.createImage();
        this.waveBox.add(p);
        this.waves.add(p);
        this.doButtonEnables();
        this.waveBox.validate();
    }

    private synchronized void deselect(WaveViewPanel p) {
        this.selectedSet.remove(p);
        this.waveToolbar.removeSettings(p.getSettings());
        p.setBackgroundColor(BACKGROUND_COLOR);
        p.createImage();
        this.doButtonEnables();
    }

    private synchronized void deselectAll() {
        WaveViewPanel[] panels;
        WaveViewPanel[] waveViewPanelArray = panels = this.selectedSet.toArray(new WaveViewPanel[0]);
        int n = panels.length;
        int n2 = 0;
        while (n2 < n) {
            WaveViewPanel p = waveViewPanelArray[n2];
            this.deselect(p);
            ++n2;
        }
    }

    private synchronized void select(WaveViewPanel p) {
        if (p == null || this.selectedSet.contains(p)) {
            return;
        }
        this.selectedSet.add(p);
        this.doButtonEnables();
        p.setBackgroundColor(SELECT_COLOR);
        Swarm.getApplication().getDataChooser().setNearest(p.getChannel());
        p.createImage();
        this.waveToolbar.addSettings(p.getSettings());
    }

    private synchronized void remove(WaveViewPanel p) {
        int i = 0;
        i = 0;
        while (i < this.waveBox.getComponentCount()) {
            if (p == this.waveBox.getComponent(i)) break;
            ++i;
        }
        p.removeListener(this.selectListener);
        p.getDataSource().close();
        this.setStatusText(" ");
        this.waveBox.remove(i);
        this.waves.remove(p);
        this.histories.remove(p);
        this.doButtonEnables();
        this.waveBox.validate();
        this.selectedSet.remove(p);
        this.lastClickedIndex = Math.min(this.lastClickedIndex, this.waveBox.getComponentCount() - 1);
        this.waveToolbar.removeSettings(p.getSettings());
        this.repaint();
    }

    protected int getWaveIndex(WaveViewPanel p) {
        int i = 0;
        i = 0;
        while (i < this.waveBox.getComponentCount()) {
            if (p == this.waveBox.getComponent(i)) break;
            ++i;
        }
        return i;
    }

    public synchronized void remove() {
        WaveViewPanel[] panels;
        WaveViewPanel[] waveViewPanelArray = panels = this.selectedSet.toArray(new WaveViewPanel[0]);
        int n = panels.length;
        int n2 = 0;
        while (n2 < n) {
            WaveViewPanel p = waveViewPanelArray[n2];
            this.remove(p);
            ++n2;
        }
    }

    public synchronized void moveDown() {
        WaveViewPanel p = this.getSingleSelected();
        if (p == null) {
            return;
        }
        int i = this.waves.indexOf(p);
        if (i == this.waves.size() - 1) {
            return;
        }
        this.waves.remove(i);
        this.waves.add(i + 1, p);
        this.waveBox.remove(p);
        this.waveBox.add((Component)p, i + 1);
        this.waveBox.validate();
        this.repaint();
    }

    public synchronized void moveUp() {
        WaveViewPanel p = this.getSingleSelected();
        if (p == null) {
            return;
        }
        int i = this.waves.indexOf(p);
        if (i == 0) {
            return;
        }
        this.waves.remove(i);
        this.waves.add(i - 1, p);
        this.waveBox.remove(p);
        this.waveBox.add((Component)p, i - 1);
        this.waveBox.validate();
        this.repaint();
    }

    public void resizeWaves() {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                int w = ((WaveClipboardFrame)WaveClipboardFrame.this).scrollPane.getViewport().getSize().width;
                for (WaveViewPanel wave : WaveClipboardFrame.this.waves) {
                    wave.setSize(w, WaveClipboardFrame.this.calculateWaveHeight());
                    wave.createImage();
                }
                return null;
            }

            @Override
            public void finished() {
                WaveClipboardFrame.this.waveBox.validate();
                WaveClipboardFrame.this.validate();
                WaveClipboardFrame.this.repaint();
            }
        };
        worker.start();
    }

    public void removeWaves() {
        while (this.waves.size() > 0) {
            this.remove(this.waves.get(0));
        }
        this.waveBox.validate();
        this.scrollPane.validate();
        this.doButtonEnables();
        this.repaint();
    }

    private void addHistory(WaveViewPanel wvp, double[] t) {
        Stack<Object> history = this.histories.get(wvp);
        if (history == null) {
            history = new Stack();
            this.histories.put(wvp, history);
        }
        history.push(t);
    }

    public void gotoTime(WaveViewPanel wvp, String t) {
        double j2k = Double.NaN;
        try {
            if (t.length() == 12) {
                t = String.valueOf(t) + "30";
            }
            j2k = Time.parse("yyyyMMddHHmmss", t);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Swarm.getApplication(), "Illegal time value.", "Error", 0);
        }
        if (!Double.isNaN(j2k)) {
            double dt = 60.0;
            if (wvp.getWave() != null) {
                double st = wvp.getStartTime();
                double et = wvp.getEndTime();
                double[] ts = new double[]{st, et};
                this.addHistory(wvp, ts);
                dt = et - st;
            }
            double tzo = Time.getTimeZoneOffset(Swarm.config.getTimeZone(wvp.getChannel()));
            double nst = j2k - tzo - dt / 2.0;
            double net = nst + dt;
            this.fetchNewWave(wvp, nst, net);
        }
    }

    public void gotoTime(String t) {
        for (WaveViewPanel p : this.selectedSet) {
            this.gotoTime(p, t);
        }
    }

    public void scaleTime(WaveViewPanel wvp, double pct) {
        double st = wvp.getStartTime();
        double et = wvp.getEndTime();
        double[] t = new double[]{st, et};
        this.addHistory(wvp, t);
        double dt = (et - st) * (1.0 - pct);
        double mt = (et - st) / 2.0 + st;
        double nst = mt - dt / 2.0;
        double net = mt + dt / 2.0;
        this.fetchNewWave(wvp, nst, net);
    }

    public void scaleTime(double pct) {
        for (WaveViewPanel p : this.selectedSet) {
            this.scaleTime(p, pct);
        }
    }

    public void back(WaveViewPanel wvp) {
        Stack<double[]> history = this.histories.get(wvp);
        if (history == null || history.empty()) {
            return;
        }
        double[] t = history.pop();
        this.fetchNewWave(wvp, t[0], t[1]);
    }

    public void back() {
        for (WaveViewPanel p : this.selectedSet) {
            this.back(p);
        }
    }

    private void shiftTime(WaveViewPanel wvp, double pct) {
        double st = wvp.getStartTime();
        double et = wvp.getEndTime();
        double[] t = new double[]{st, et};
        this.addHistory(wvp, t);
        double dt = (et - st) * pct;
        double nst = st + dt;
        double net = et + dt;
        this.fetchNewWave(wvp, nst, net);
    }

    public void shiftTime(double pct) {
        for (WaveViewPanel p : this.selectedSet) {
            this.shiftTime(p, pct);
        }
    }

    public void repositionWaves(double st, double et) {
        for (WaveViewPanel wave : this.waves) {
            this.fetchNewWave(wave, st, et);
        }
    }

    public Throbber getThrobber() {
        return this.throbber;
    }

    private void fetchNewWave(final WaveViewPanel wvp, final double nst, final double net) {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                WaveClipboardFrame.this.throbber.increment();
                SeismicDataSource sds = wvp.getDataSource();
                Wave sw = null;
                sw = sds instanceof CachedDataSource ? ((CachedDataSource)sds).getBestWave(wvp.getChannel(), nst, net) : sds.getWave(wvp.getChannel(), nst, net);
                wvp.setWave(sw, nst, net);
                wvp.repaint();
                return null;
            }

            @Override
            public void finished() {
                WaveClipboardFrame.this.throbber.decrement();
                WaveClipboardFrame.this.repaint();
            }
        };
        worker.start();
    }

    @Override
    public void setMaximum(boolean max) throws PropertyVetoException {
        if (max) {
            Swarm.config.clipboardX = this.getX();
            Swarm.config.clipboardY = this.getY();
        }
        super.setMaximum(max);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.waves.size() == 0) {
            Dimension dim = this.getSize();
            g.setColor(Color.black);
            g.drawString("Clipboard empty.", dim.width / 2 - 40, dim.height / 2);
        }
    }

    class CaptureActionListener
    implements ActionListener {
        CaptureActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WaveClipboardFrame.this.waves == null || WaveClipboardFrame.this.waves.size() == 0) {
                return;
            }
            JFileChooser chooser = Swarm.getApplication().getFileChooser();
            File lastPath = new File(Swarm.config.lastPath);
            chooser.setCurrentDirectory(lastPath);
            chooser.setSelectedFile(new File("clipboard.png"));
            chooser.setDialogTitle("Save Clipboard Screen Capture");
            int result = chooser.showSaveDialog(Swarm.getApplication());
            File f = null;
            if (result == 0) {
                int choice;
                f = chooser.getSelectedFile();
                if (f.exists() && (choice = JOptionPane.showConfirmDialog(Swarm.getApplication(), "File exists, overwrite?", "Confirm", 0)) != 0) {
                    return;
                }
                Swarm.config.lastPath = f.getParent();
            }
            if (f == null) {
                return;
            }
            int height = 0;
            int width = ((WaveViewPanel)WaveClipboardFrame.this.waves.get(0)).getWidth();
            for (WaveViewPanel panel : WaveClipboardFrame.this.waves) {
                height += panel.getHeight();
            }
            BufferedImage image = new BufferedImage(width, height, 6);
            Graphics g = image.getGraphics();
            for (WaveViewPanel panel : WaveClipboardFrame.this.waves) {
                panel.paint(g);
                g.translate(0, panel.getHeight());
            }
            try {
                PngEncoderB png = new PngEncoderB(image, false, 0, 7);
                FileOutputStream out = new FileOutputStream(f);
                byte[] bytes = png.pngEncode();
                out.write(bytes);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static enum FileType {
        TEXT,
        SAC,
        UNKNOWN;


        public static FileType fromFile(File f) {
            if (f.getPath().endsWith(".sac")) {
                return SAC;
            }
            if (f.getPath().endsWith(".txt")) {
                return TEXT;
            }
            return UNKNOWN;
        }
    }

    private class OpenActionListener
    implements ActionListener {
        private OpenActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = Swarm.getApplication().getFileChooser();
            chooser.resetChoosableFileFilters();
            ExtensionFileFilter txtExt = new ExtensionFileFilter(".txt", "Matlab-readable text files");
            ExtensionFileFilter sacExt = new ExtensionFileFilter(".sac", "SAC files");
            chooser.addChoosableFileFilter(txtExt);
            chooser.addChoosableFileFilter(sacExt);
            chooser.setDialogTitle("Open Wave");
            chooser.setFileFilter(chooser.getAcceptAllFileFilter());
            File lastPath = new File(Swarm.config.lastPath);
            chooser.setCurrentDirectory(lastPath);
            chooser.setFileSelectionMode(2);
            chooser.setMultiSelectionEnabled(true);
            int result = chooser.showOpenDialog(Swarm.getApplication());
            if (result == 0) {
                File[] fs = chooser.getSelectedFiles();
                int i = 0;
                while (i < fs.length) {
                    if (fs[i].isDirectory()) {
                        File[] dfs = fs[i].listFiles();
                        int j = 0;
                        while (j < dfs.length) {
                            WaveClipboardFrame.this.openFile(dfs[j]);
                            ++j;
                        }
                        Swarm.config.lastPath = fs[i].getParent();
                    } else {
                        WaveClipboardFrame.this.openFile(fs[i]);
                        Swarm.config.lastPath = fs[i].getParent();
                    }
                    ++i;
                }
            }
        }
    }

    private class SaveActionListener
    implements ActionListener {
        private SaveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WaveViewPanel selected = WaveClipboardFrame.this.getSingleSelected();
            if (selected == null) {
                return;
            }
            JFileChooser chooser = Swarm.getApplication().getFileChooser();
            chooser.resetChoosableFileFilters();
            chooser.setFileSelectionMode(2);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle("Save Wave");
            ExtensionFileFilter txtExt = new ExtensionFileFilter(".txt", "Matlab-readable text files");
            ExtensionFileFilter sacExt = new ExtensionFileFilter(".sac", "SAC files");
            chooser.addChoosableFileFilter(txtExt);
            chooser.addChoosableFileFilter(sacExt);
            chooser.setFileFilter(chooser.getAcceptAllFileFilter());
            File lastPath = new File(Swarm.config.lastPath);
            chooser.setCurrentDirectory(lastPath);
            chooser.setSelectedFile(new File(String.valueOf(selected.getChannel()) + ".txt"));
            int result = chooser.showSaveDialog(Swarm.getApplication());
            if (result == 0) {
                File f = chooser.getSelectedFile();
                String path = f.getPath();
                if (!path.endsWith(".txt") && !path.endsWith(".sac")) {
                    f = chooser.getFileFilter() == sacExt ? new File(String.valueOf(path) + ".sac") : new File(String.valueOf(path) + ".txt");
                }
                boolean confirm = true;
                if (f.exists()) {
                    if (f.isDirectory()) {
                        JOptionPane.showMessageDialog(Swarm.getApplication(), "You can not select an existing directory.", "Error", 0);
                        return;
                    }
                    confirm = false;
                    int choice = JOptionPane.showConfirmDialog(Swarm.getApplication(), "File exists, overwrite?", "Confirm", 0);
                    if (choice == 0) {
                        confirm = true;
                    }
                }
                if (confirm) {
                    try {
                        Swarm.config.lastPath = f.getParent();
                        String fn = f.getPath().toLowerCase();
                        if (fn.endsWith(".sac")) {
                            SAC sac = selected.getWave().toSAC();
                            String[] scn = selected.getChannel().split(" ");
                            sac.kstnm = scn[0];
                            sac.kcmpnm = scn[1];
                            sac.knetwk = scn[2];
                            sac.write(f);
                        } else {
                            selected.getWave().exportToText(f.getPath());
                        }
                    }
                    catch (FileNotFoundException ex) {
                        JOptionPane.showMessageDialog(Swarm.getApplication(), "Directory does not exist.", "Error", 0);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(Swarm.getApplication(), "Error writing file.", "Error", 0);
                    }
                }
            }
        }
    }

    private class SaveAllActionListener
    implements ActionListener {
        private SaveAllActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WaveClipboardFrame.this.waves.size() <= 0) {
                return;
            }
            JFileChooser chooser = Swarm.getApplication().getFileChooser();
            chooser.resetChoosableFileFilters();
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(1);
            chooser.setDialogTitle("Save SAC File Directory");
            File lastPath = new File(Swarm.config.lastPath);
            chooser.setCurrentDirectory(lastPath);
            int result = chooser.showSaveDialog(Swarm.getApplication());
            if (result == 1) {
                return;
            }
            File f = chooser.getSelectedFile();
            if (f == null) {
                JOptionPane.showMessageDialog(Swarm.getApplication(), "You must select a directory.", "Error", 0);
                return;
            }
            if (result == 0) {
                try {
                    if (f.exists() && !f.isDirectory()) {
                        return;
                    }
                    if (!f.exists()) {
                        f.mkdir();
                    }
                    for (WaveViewPanel wvp : WaveClipboardFrame.this.waves) {
                        Wave sw = wvp.getWave();
                        if (sw == null) continue;
                        sw = sw.subset(wvp.getStartTime(), wvp.getEndTime());
                        String date = WaveClipboardFrame.this.saveAllDateFormat.format(Util.j2KToDate(sw.getStartTime()));
                        File dir = new File(String.valueOf(f.getPath()) + File.separatorChar + date);
                        if (!dir.exists()) {
                            dir.mkdir();
                        }
                        SAC sac = sw.toSAC();
                        String[] scn = wvp.getChannel().split(" ");
                        sac.kstnm = scn[0];
                        sac.kcmpnm = scn[1];
                        sac.knetwk = scn[2];
                        sac.write(new File(String.valueOf(dir.getPath()) + File.separatorChar + wvp.getChannel().replace(' ', '.')));
                    }
                    Swarm.config.lastPath = f.getPath();
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(Swarm.getApplication(), "Directory does not exist.", "Error", 0);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(Swarm.getApplication(), "Error writing file.", "Error", 0);
                }
            }
        }
    }
}

