/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.heli;

import gov.usgs.swarm.Images;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.SwarmDialog;
import gov.usgs.swarm.SwingWorker;
import gov.usgs.swarm.heli.HelicorderViewerFrame;
import gov.usgs.swarm.heli.HelicorderViewerSettings;
import gov.usgs.swarm.wave.WaveViewSettings;
import gov.usgs.swarm.wave.WaveViewSettingsDialog;
import gov.usgs.util.GridBagHelper;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class HelicorderViewerSettingsDialog
extends SwarmDialog {
    public static final long serialVersionUID = -1L;
    private HelicorderViewerSettings settings;
    private WaveViewSettings waveSettings;
    private JPanel dialogPanel;
    private JComboBox chunkList;
    private JComboBox spanList;
    private JTextField bottomTime;
    private JComboBox zoomList;
    private JTextField refreshInterval;
    private JTextField scrollSize;
    private DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
    private JCheckBox removeDrift;
    private JCheckBox showClip;
    private JCheckBox alertClip;
    private JTextField alertClipTimeout;
    private JLabel alertClipTimeoutLabel;
    private JTextField clipValue;
    private JCheckBox autoScale;
    private JTextField barRange;
    private static HelicorderViewerSettingsDialog dialog;

    private HelicorderViewerSettingsDialog() {
        super(Swarm.getApplication(), "Helicorder View Settings", true);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.createUI();
        this.setSizeAndLocation();
    }

    public static HelicorderViewerSettingsDialog getInstance(HelicorderViewerSettings s, WaveViewSettings s2) {
        if (dialog == null) {
            dialog = new HelicorderViewerSettingsDialog();
        }
        dialog.setSettings(s, s2);
        return dialog;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.getRootPane().setDefaultButton(this.okButton);
        }
        super.setVisible(b);
    }

    public void setSettings(HelicorderViewerSettings s, WaveViewSettings s2) {
        this.settings = s;
        this.waveSettings = s2;
        this.setToCurrent();
    }

    private void createComponents() {
        int[] values = HelicorderViewerFrame.chunkValues;
        String[] chunks = new String[values.length];
        int i = 0;
        while (i < chunks.length) {
            chunks[i] = Integer.toString(values[i] / 60);
            ++i;
        }
        this.chunkList = new JComboBox<String>(chunks);
        values = HelicorderViewerFrame.spanValues;
        String[] spans = new String[values.length];
        int i2 = 0;
        while (i2 < spans.length) {
            spans[i2] = Integer.toString(values[i2] / 60);
            ++i2;
        }
        this.spanList = new JComboBox<String>(spans);
        this.spanList.setEditable(true);
    }

    @Override
    protected void createUI() {
        super.createUI();
        this.createComponents();
        int[] values = HelicorderViewerFrame.chunkValues;
        String[] chunks = new String[values.length];
        int i = 0;
        while (i < chunks.length) {
            chunks[i] = Integer.toString(values[i] / 60);
            ++i;
        }
        this.chunkList = new JComboBox<String>(chunks);
        values = HelicorderViewerFrame.spanValues;
        String[] spans = new String[values.length];
        int i2 = 0;
        while (i2 < spans.length) {
            spans[i2] = Integer.toString(values[i2] / 60);
            ++i2;
        }
        this.spanList = new JComboBox<String>(spans);
        this.spanList.setEditable(true);
        JLabel chunkLabel = new JLabel("X, minutes:");
        chunkLabel.setLabelFor(this.chunkList);
        JLabel spanLabel = new JLabel("Y, hours:");
        spanLabel.setLabelFor(this.spanList);
        this.bottomTime = new JTextField();
        this.bottomTime.setToolTipText("Format: YYYYMMDDhhmm");
        JLabel bottomLabel = new JLabel("View time:");
        bottomLabel.setLabelFor(this.bottomTime);
        bottomLabel.setToolTipText("Format: YYYYMMDDhhmm");
        this.bottomTime.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HelicorderViewerSettingsDialog.this.bottomTime.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        JPanel axisPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        axisPanel.setBorder(new TitledBorder(new EtchedBorder(), "Axes"));
        axisPanel.add((Component)chunkLabel, GridBagHelper.set(c, "x=0;y=0;w=2;h=1;wx=1;ix=12;iy=2;a=w;f=n;i=0,4,0,4"));
        axisPanel.add((Component)this.chunkList, GridBagHelper.set(c, "x=2;y=0;w=1;h=1;f=h;wx=0;a=e"));
        axisPanel.add((Component)spanLabel, GridBagHelper.set(c, "x=0;y=1;w=2;h=1;wx=1;a=w;f=n"));
        axisPanel.add((Component)this.spanList, GridBagHelper.set(c, "x=2;y=1;w=1;h=1;f=h;wx=0;a=e"));
        axisPanel.add((Component)bottomLabel, GridBagHelper.set(c, "x=0;y=2;w=1;h=1;wx=0;a=w;f=n"));
        axisPanel.add((Component)this.bottomTime, GridBagHelper.set(c, "x=1;y=2;w=2;h=1;f=h;wx=1;a=e"));
        values = HelicorderViewerFrame.zoomValues;
        String[] zooms = new String[values.length];
        int i3 = 0;
        while (i3 < zooms.length) {
            zooms[i3] = Integer.toString(values[i3]);
            ++i3;
        }
        this.zoomList = new JComboBox<String>(zooms);
        JLabel zoomLabel = new JLabel("Zoom, seconds:");
        zoomLabel.setLabelFor(this.zoomList);
        JButton waveSettingsButton = new JButton("Wave Settings", new ImageIcon(this.getClass().getClassLoader().getResource(Images.get("wavesettings"))));
        waveSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveViewSettingsDialog wvsd = WaveViewSettingsDialog.getInstance(HelicorderViewerSettingsDialog.this.waveSettings);
                wvsd.setVisible(true);
            }
        });
        JPanel zoomPanel = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        zoomPanel.setBorder(new TitledBorder(new EtchedBorder(), "Zoom"));
        zoomPanel.add((Component)zoomLabel, GridBagHelper.set(c, "x=0;y=0;w=2;h=1;wx=1;ix=12;iy=2;a=w;f=n;i=0,4,0,4"));
        zoomPanel.add((Component)this.zoomList, GridBagHelper.set(c, "x=2;y=0;w=1;h=1;f=h;wx=0;a=e"));
        zoomPanel.add((Component)new JSeparator(), GridBagHelper.set(c, "x=0;y=1;w=3;h=1;f=h;i=5,0,5,0"));
        zoomPanel.add((Component)waveSettingsButton, GridBagHelper.set(c, "x=0;y=2;w=3;h=1;a=e;f=n;i=0,4,0,4"));
        this.showClip = new JCheckBox("Show clip");
        this.showClip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerSettingsDialog.this.setShowClipEnabled(HelicorderViewerSettingsDialog.this.showClip.isSelected());
            }
        });
        this.alertClip = new JCheckBox("Audible clipping");
        this.alertClip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerSettingsDialog.this.setAlertClipEnabled(HelicorderViewerSettingsDialog.this.alertClip.isSelected());
            }
        });
        this.alertClipTimeoutLabel = new JLabel("Alert frequency, minutes: ");
        this.alertClipTimeout = new JTextField(4);
        this.alertClipTimeoutLabel.setLabelFor(this.alertClipTimeout);
        JPanel clippingPanel = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        clippingPanel.setBorder(new TitledBorder(new EtchedBorder(), "Clipping"));
        clippingPanel.add((Component)this.showClip, GridBagHelper.set(c, "x=0;y=0;w=2;h=1;wx=1;ix=12;iy=2;a=w;f=n;i=0,4,0,4"));
        clippingPanel.add((Component)this.alertClip, GridBagHelper.set(c, "x=0;y=1;w=2;h=1;wx=1;ix=12;iy=2;a=w;f=n;i=0,4,0,4"));
        clippingPanel.add((Component)this.alertClipTimeoutLabel, GridBagHelper.set(c, "x=0;y=2;w=1;h=1;f=h;wx=0;a=w"));
        clippingPanel.add((Component)this.alertClipTimeout, GridBagHelper.set(c, "x=1;y=2;w=1;h=1;f=h;wx=1;a=e"));
        JLabel cvLabel = new JLabel("Clip threshold:");
        this.clipValue = new JTextField();
        cvLabel.setLabelFor(this.clipValue);
        this.refreshInterval = new JTextField(4);
        JLabel refreshLabel = new JLabel("Refresh, seconds: ");
        refreshLabel.setLabelFor(this.refreshInterval);
        JLabel scrollLabel = new JLabel("Scroll size, rows: ");
        this.scrollSize = new JTextField(4);
        scrollLabel.setLabelFor(this.scrollSize);
        this.autoScale = new JCheckBox("Auto-scale");
        this.autoScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelicorderViewerSettingsDialog.this.setAutoScaleEnabled(HelicorderViewerSettingsDialog.this.autoScale.isSelected());
            }
        });
        JLabel obrLabel = new JLabel("One bar range:");
        this.barRange = new JTextField();
        obrLabel.setLabelFor(this.barRange);
        JPanel otherPanel = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        otherPanel.setBorder(new TitledBorder(new EtchedBorder(), "Other"));
        otherPanel.add((Component)refreshLabel, GridBagHelper.set(c, "x=0;y=0;w=2;h=1;wx=1;ix=12;iy=2;a=w;f=n;i=0,4,0,4"));
        otherPanel.add((Component)this.refreshInterval, GridBagHelper.set(c, "x=2;y=0;w=1;h=1;f=h;wx=0;a=e"));
        otherPanel.add((Component)scrollLabel, GridBagHelper.set(c, "x=0;y=1;w=2;h=1;wx=1;a=w;f=n"));
        otherPanel.add((Component)this.scrollSize, GridBagHelper.set(c, "x=2;y=1;w=1;h=1;f=h;wx=0;a=e"));
        this.removeDrift = new JCheckBox("Force center");
        otherPanel.add((Component)this.removeDrift, GridBagHelper.set(c, "x=0;y=2;w=3;h=1;f=h;wx=0;a=w"));
        otherPanel.add((Component)this.autoScale, GridBagHelper.set(c, "x=0;y=6;w=3;h=1;f=h;wx=0;a=w"));
        otherPanel.add((Component)obrLabel, GridBagHelper.set(c, "x=0;y=7;w=2;h=1;wx=1;a=w;f=n"));
        otherPanel.add((Component)this.barRange, GridBagHelper.set(c, "x=2;y=7;w=1;h=1;f=h;wx=0;a=e"));
        otherPanel.add((Component)cvLabel, GridBagHelper.set(c, "x=0;y=8;w=2;h=1;wx=1;a=w;f=n"));
        otherPanel.add((Component)this.clipValue, GridBagHelper.set(c, "x=2;y=8;w=1;h=1;f=h;wx=0;a=e"));
        JPanel centerPanel = new JPanel();
        BoxLayout bl = new BoxLayout(centerPanel, 1);
        centerPanel.setLayout(bl);
        centerPanel.add(axisPanel);
        centerPanel.add(zoomPanel);
        centerPanel.add(clippingPanel);
        centerPanel.add(otherPanel);
        this.dialogPanel = new JPanel(new BorderLayout());
        this.dialogPanel.add((Component)centerPanel, "Center");
        this.mainPanel.add((Component)this.dialogPanel, "Center");
    }

    private void setShowClipEnabled(final boolean b) {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                HelicorderViewerSettingsDialog.this.alertClip.setEnabled(b);
                HelicorderViewerSettingsDialog.this.setAlertClipEnabled(b);
                return null;
            }

            @Override
            public void finished() {
            }
        };
        worker.start();
    }

    private void setAlertClipEnabled(boolean b) {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                boolean state = HelicorderViewerSettingsDialog.this.showClip.isSelected() && HelicorderViewerSettingsDialog.this.alertClip.isSelected();
                HelicorderViewerSettingsDialog.this.alertClipTimeout.setEnabled(state);
                HelicorderViewerSettingsDialog.this.alertClipTimeoutLabel.setEnabled(state);
                return null;
            }

            @Override
            public void finished() {
            }
        };
        worker.start();
    }

    private void setAutoScaleEnabled(final boolean b) {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                HelicorderViewerSettingsDialog.this.clipValue.setEnabled(!b);
                HelicorderViewerSettingsDialog.this.barRange.setEnabled(!b);
                return null;
            }

            @Override
            public void finished() {
            }
        };
        worker.start();
    }

    public void setToCurrent() {
        if (this.settings == null || this.waveSettings == null) {
            return;
        }
        String tc = Integer.toString((int)((double)this.settings.timeChunk / 60.0));
        this.chunkList.setSelectedItem(tc);
        String span = Integer.toString((int)((double)this.settings.span / 60.0));
        this.spanList.setSelectedItem(span);
        String wzo = Integer.toString(this.settings.waveZoomOffset);
        this.zoomList.setSelectedItem(wzo);
        double bt = this.settings.getBottomTime();
        if (Double.isNaN(bt)) {
            this.bottomTime.setText("Now");
        } else {
            double tzo = Time.getTimeZoneOffset(Swarm.config.getTimeZone(this.settings.channel));
            this.bottomTime.setText(this.dateFormat.format(Util.j2KToDate(bt + tzo)));
        }
        this.refreshInterval.setText(Integer.toString(this.settings.refreshInterval));
        this.scrollSize.setText(Integer.toString(this.settings.scrollSize));
        this.removeDrift.setSelected(this.settings.forceCenter);
        this.clipValue.setText(Integer.toString(this.settings.clipValue));
        this.barRange.setText(Integer.toString(this.settings.barRange));
        this.autoScale.setSelected(this.settings.autoScale);
        this.showClip.setSelected(this.settings.showClip);
        this.alertClip.setSelected(this.settings.alertClip);
        String alertTO = Integer.toString(this.settings.alertClipTimeout / 60);
        this.alertClipTimeout.setText(alertTO);
        this.setAutoScaleEnabled(this.settings.autoScale);
    }

    @Override
    protected void wasOK() {
        try {
            this.settings.timeChunk = Integer.parseInt(this.chunkList.getSelectedItem().toString()) * 60;
            this.settings.span = Integer.parseInt(this.spanList.getSelectedItem().toString()) * 60;
            this.settings.waveZoomOffset = Integer.parseInt(this.zoomList.getSelectedItem().toString());
            this.settings.refreshInterval = Integer.parseInt(this.refreshInterval.getText());
            this.settings.scrollSize = Integer.parseInt(this.scrollSize.getText());
            if (this.bottomTime.getText().toLowerCase().equals("now")) {
                this.settings.setBottomTime(Double.NaN);
            } else {
                String t = this.bottomTime.getText();
                if (t.length() == 8) {
                    t = String.valueOf(t) + "2359";
                }
                Date bt = this.dateFormat.parse(t);
                double tzo = Time.getTimeZoneOffset(Swarm.config.getTimeZone(this.settings.channel));
                this.settings.setBottomTime(Util.dateToJ2K(bt) - tzo);
            }
            this.settings.forceCenter = this.removeDrift.isSelected();
            this.settings.showClip = this.showClip.isSelected();
            this.settings.alertClip = this.alertClip.isSelected();
            this.settings.alertClipTimeout = Integer.parseInt(this.alertClipTimeout.getText()) * 60;
            this.settings.clipValue = Integer.parseInt(this.clipValue.getText());
            this.settings.autoScale = this.autoScale.isSelected();
            this.settings.barRange = Integer.parseInt(this.barRange.getText());
            this.settings.notifyView();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean allowOK() {
        String message = null;
        try {
            message = "Invalid time; legal format is 'YYYYMMDD' or 'YYYYMMDDhhmm' or 'Now'.";
            if (!this.bottomTime.getText().toLowerCase().equals("now")) {
                Date bt = null;
                String t = this.bottomTime.getText();
                if (t.length() == 8) {
                    t = String.valueOf(t) + "2359";
                }
                if ((bt = this.dateFormat.parse(t)) == null) {
                    throw new ParseException(null, 0);
                }
            }
            message = "Invalid refresh interval; legal values are between 0 and 3600, 0 for no refresh.";
            int ri = Integer.parseInt(this.refreshInterval.getText());
            if (ri < 0 || ri > 3600) {
                throw new NumberFormatException();
            }
            message = "Invalid scroll size; legal values are between 1 and 48.";
            int ss = Integer.parseInt(this.scrollSize.getText());
            if (ss < 1 || ss > 48) {
                throw new NumberFormatException();
            }
            message = "Invalid clip value.";
            Integer.parseInt(this.clipValue.getText());
            message = "Invalid one bar range.";
            Integer.parseInt(this.barRange.getText());
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, message, "Options Error", 0);
            return false;
        }
    }
}

