/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data;

import edu.iris.Fissures.seed.builder.ObjectBuilder;
import edu.iris.Fissures.seed.builder.SeedObjectBuilder;
import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.SeedObjectContainer;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.director.SeedImportDirector;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.vdx.data.wave.Wave;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class FullSeedDataSource
extends SeismicDataSource {
    private List<String> stations;
    private static Map<String, Wave> stationMap;
    private static boolean read;
    private String filename;

    static {
        read = false;
    }

    public FullSeedDataSource(String fn) {
        if (read) {
            return;
        }
        this.filename = fn;
        this.stations = new ArrayList<String>();
        try {
            List<Wave> parts;
            Object object;
            HashMap tempStationMap = new HashMap();
            stationMap = new HashMap<String, Wave>();
            DataInputStream ls = new DataInputStream(new BufferedInputStream(new FileInputStream(fn)));
            SeedImportDirector importDirector = new SeedImportDirector();
            SeedObjectBuilder objectBuilder = new SeedObjectBuilder();
            importDirector.assignBuilder((ObjectBuilder)objectBuilder);
            importDirector.construct((InputStream)ls);
            SeedObjectContainer container = (SeedObjectContainer)importDirector.getBuilder().getContainer();
            container.iterate();
            while ((object = container.getNext()) != null) {
                Blockette b = (Blockette)object;
                if (b.getType() != 999) continue;
                String code = b.getFieldVal(4) + "_" + b.getFieldVal(6) + "_" + b.getFieldVal(7);
                parts = (List)tempStationMap.get(code);
                if (parts == null) {
                    parts = new ArrayList<Wave>();
                    tempStationMap.put(code, parts);
                }
                if (b.getWaveform() == null) continue;
                Waveform wf = b.getWaveform();
                Wave sw = new Wave();
                sw.setSamplingRate(this.getSampleRate(((Integer)b.getFieldVal(10)).intValue(), ((Integer)b.getFieldVal(11)).intValue()));
                Btime bTime = (Btime)b.getFieldVal(8);
                sw.setStartTime(Util.dateToJ2K(this.btimeToDate(bTime)));
                sw.buffer = wf.getDecodedIntegers();
                sw.register();
                parts.add(sw);
            }
            for (String key : tempStationMap.keySet()) {
                parts = (ArrayList<Wave>)tempStationMap.get(key);
                Wave wave = Wave.join(parts);
                Swarm.getCache().cacheWaveAsHelicorder(key, wave);
                Swarm.getCache().putWave(key, wave);
                stationMap.put(key, wave);
                this.stations.add(key);
            }
            read = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Date btimeToDate(Btime bt) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1, bt.getYear());
        cal.set(6, bt.getDayOfYear());
        cal.set(11, bt.getHour());
        cal.set(12, bt.getMinute());
        cal.set(13, bt.getSecond());
        cal.set(14, bt.getTenthMill() / 10);
        return cal.getTime();
    }

    private float getSampleRate(double factor, double multiplier) {
        float sampleRate = 10000.0f;
        if (factor * multiplier != 0.0) {
            sampleRate = (float)(Math.pow(Math.abs(factor), factor / Math.abs(factor)) * Math.pow(Math.abs(multiplier), multiplier / Math.abs(multiplier)));
        }
        return sampleRate;
    }

    @Override
    public HelicorderData getHelicorder(String station, double t1, double t2, GulperListener gl) {
        double dt = t2 - t1;
        double now = CurrentTime.getInstance().nowJ2K();
        if (Math.abs(now - t2) < 3600.0) {
            Wave wave = stationMap.get(station);
            if (wave == null) {
                return null;
            }
            t2 = wave.getEndTime();
            t1 = t2 - dt;
        }
        return Swarm.getCache().getHelicorder(station, t1, t2, gl);
    }

    @Override
    public List<String> getChannels() {
        return this.stations;
    }

    @Override
    public Wave getWave(String station, double t1, double t2) {
        return Swarm.getCache().getBestWave(station, t1, t2);
    }

    @Override
    public String toConfigString() {
        return String.valueOf(this.name) + ";seed:" + this.filename;
    }
}

