/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLElement
implements IXMLElement,
Serializable {
    static final long serialVersionUID = -2383376380548624920L;
    public static final int NO_LINE = -1;
    private IXMLElement parent;
    private Vector<XMLAttribute> attributes = new Vector();
    private Vector<IXMLElement> children = new Vector(8);
    private String name;
    private String fullName;
    private String namespace;
    private String content;
    private String systemID;
    private int lineNr;

    public XMLElement() {
        this(null, null, null, -1);
    }

    public XMLElement(String fullName) {
        this(fullName, null, null, -1);
    }

    public XMLElement(String fullName, String systemID, int lineNr) {
        this(fullName, null, systemID, lineNr);
    }

    public XMLElement(String fullName, String namespace) {
        this(fullName, namespace, null, -1);
    }

    public XMLElement(String fullName, String namespace, String systemID, int lineNr) {
        int index;
        this.fullName = fullName;
        this.name = namespace == null ? fullName : ((index = fullName.indexOf(58)) >= 0 ? fullName.substring(index + 1) : fullName);
        this.namespace = namespace;
        this.content = null;
        this.lineNr = lineNr;
        this.systemID = systemID;
        this.parent = null;
    }

    @Override
    public IXMLElement createPCDataElement() {
        return new XMLElement();
    }

    @Override
    public IXMLElement createElement(String fullName) {
        return new XMLElement(fullName);
    }

    @Override
    public IXMLElement createElement(String fullName, String systemID, int lineNr) {
        return new XMLElement(fullName, systemID, lineNr);
    }

    @Override
    public IXMLElement createElement(String fullName, String namespace) {
        return new XMLElement(fullName, namespace);
    }

    @Override
    public IXMLElement createElement(String fullName, String namespace, String systemID, int lineNr) {
        return new XMLElement(fullName, namespace, systemID, lineNr);
    }

    protected void finalize() throws Throwable {
        this.attributes.clear();
        this.attributes = null;
        this.children = null;
        this.fullName = null;
        this.name = null;
        this.namespace = null;
        this.content = null;
        this.systemID = null;
        this.parent = null;
        super.finalize();
    }

    @Override
    public IXMLElement getParent() {
        return this.parent;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.fullName = name;
        this.namespace = null;
    }

    @Override
    public void setName(String fullName, String namespace) {
        int index = fullName.indexOf(58);
        this.name = namespace == null || index < 0 ? fullName : fullName.substring(index + 1);
        this.fullName = fullName;
        this.namespace = namespace;
    }

    @Override
    public void addChild(IXMLElement child) {
        IXMLElement lastChild;
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (child.getName() == null && !this.children.isEmpty() && (lastChild = this.children.lastElement()).getName() == null) {
            lastChild.setContent(lastChild.getContent() + child.getContent());
            return;
        }
        ((XMLElement)child).parent = this;
        this.children.addElement(child);
    }

    public void insertChild(IXMLElement child, int index) {
        IXMLElement lastChild;
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        if (child.getName() == null && !this.children.isEmpty() && (lastChild = this.children.lastElement()).getName() == null) {
            lastChild.setContent(lastChild.getContent() + child.getContent());
            return;
        }
        ((XMLElement)child).parent = this;
        this.children.insertElementAt(child, index);
    }

    @Override
    public void removeChild(IXMLElement child) {
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        this.children.removeElement(child);
    }

    @Override
    public void removeChildAtIndex(int index) {
        this.children.removeElementAt(index);
    }

    @Override
    public Enumeration enumerateChildren() {
        return this.children.elements();
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public int getChildrenCount() {
        return this.children.size();
    }

    @Override
    public Vector<IXMLElement> getChildren() {
        return this.children;
    }

    @Override
    public IXMLElement getChildAtIndex(int index) throws ArrayIndexOutOfBoundsException {
        return this.children.elementAt(index);
    }

    @Override
    public IXMLElement getFirstChildNamed(String name) {
        Enumeration<IXMLElement> enum1 = this.children.elements();
        while (enum1.hasMoreElements()) {
            IXMLElement child = enum1.nextElement();
            String childName = child.getFullName();
            if (childName == null || !childName.equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    public IXMLElement getFirstChildNamed(String name, String namespace) {
        Enumeration<IXMLElement> enum1 = this.children.elements();
        while (enum1.hasMoreElements()) {
            IXMLElement child = enum1.nextElement();
            String str = child.getName();
            boolean found = str != null && str.equals(name);
            str = child.getNamespace();
            found = str == null ? (found &= name == null) : (found &= str.equals(namespace));
            if (!found) continue;
            return child;
        }
        return null;
    }

    @Override
    public Vector<IXMLElement> getChildrenNamed(String name) {
        Vector<IXMLElement> result = new Vector<IXMLElement>(this.children.size());
        Enumeration<IXMLElement> enum1 = this.children.elements();
        while (enum1.hasMoreElements()) {
            IXMLElement child = enum1.nextElement();
            String childName = child.getFullName();
            if (childName == null || !childName.equals(name)) continue;
            result.addElement(child);
        }
        return result;
    }

    @Override
    public Vector<IXMLElement> getChildrenNamed(String name, String namespace) {
        Vector<IXMLElement> result = new Vector<IXMLElement>(this.children.size());
        Enumeration<IXMLElement> enum1 = this.children.elements();
        while (enum1.hasMoreElements()) {
            IXMLElement child = enum1.nextElement();
            String str = child.getName();
            boolean found = str != null && str.equals(name);
            str = child.getNamespace();
            found = str == null ? (found &= name == null) : (found &= str.equals(namespace));
            if (!found) continue;
            result.addElement(child);
        }
        return result;
    }

    private XMLAttribute findAttribute(String fullName) {
        Enumeration<XMLAttribute> enum1 = this.attributes.elements();
        while (enum1.hasMoreElements()) {
            XMLAttribute attr = enum1.nextElement();
            if (!attr.getFullName().equals(fullName)) continue;
            return attr;
        }
        return null;
    }

    private XMLAttribute findAttribute(String name, String namespace) {
        Enumeration<XMLAttribute> enum1 = this.attributes.elements();
        while (enum1.hasMoreElements()) {
            XMLAttribute attr = enum1.nextElement();
            boolean found = attr.getName().equals(name);
            found = namespace == null ? (found &= attr.getNamespace() == null) : (found &= namespace.equals(attr.getNamespace()));
            if (!found) continue;
            return attr;
        }
        return null;
    }

    @Override
    public int getAttributeCount() {
        return this.attributes.size();
    }

    @Override
    public String getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public String getAttribute(String name, String defaultValue) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    @Override
    public String getAttribute(String name, String namespace, String defaultValue) {
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    @Override
    public int getAttribute(String name, int defaultValue) {
        String value = this.getAttribute(name, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    @Override
    public int getAttribute(String name, String namespace, int defaultValue) {
        String value = this.getAttribute(name, namespace, Integer.toString(defaultValue));
        return Integer.parseInt(value);
    }

    @Override
    public String getAttributeType(String name) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return null;
        }
        return attr.getType();
    }

    @Override
    public String getAttributeNamespace(String name) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            return null;
        }
        return attr.getNamespace();
    }

    @Override
    public String getAttributeType(String name, String namespace) {
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            return null;
        }
        return attr.getType();
    }

    @Override
    public void setAttribute(String name, String value) {
        XMLAttribute attr = this.findAttribute(name);
        if (attr == null) {
            attr = new XMLAttribute(name, name, null, value, "CDATA");
            this.attributes.addElement(attr);
        } else {
            attr.setValue(value);
        }
    }

    @Override
    public void setAttribute(String fullName, String namespace, String value) {
        int index = fullName.indexOf(58);
        String name = fullName.substring(index + 1);
        XMLAttribute attr = this.findAttribute(name, namespace);
        if (attr == null) {
            attr = new XMLAttribute(fullName, name, namespace, value, "CDATA");
            this.attributes.addElement(attr);
        } else {
            attr.setValue(value);
        }
    }

    @Override
    public void removeAttribute(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            XMLAttribute attr = this.attributes.elementAt(i);
            if (!attr.getFullName().equals(name)) continue;
            this.attributes.removeElementAt(i);
            return;
        }
    }

    @Override
    public void removeAttribute(String name, String namespace) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            XMLAttribute attr = this.attributes.elementAt(i);
            boolean found = attr.getName().equals(name);
            found = namespace == null ? (found &= attr.getNamespace() == null) : (found &= attr.getNamespace().equals(namespace));
            if (!found) continue;
            this.attributes.removeElementAt(i);
            return;
        }
    }

    @Override
    public Enumeration<String> enumerateAttributeNames() {
        Vector<String> result = new Vector<String>();
        Enumeration<XMLAttribute> enum1 = this.attributes.elements();
        while (enum1.hasMoreElements()) {
            XMLAttribute attr = enum1.nextElement();
            result.addElement(attr.getFullName());
        }
        return result.elements();
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.findAttribute(name) != null;
    }

    @Override
    public boolean hasAttribute(String name, String namespace) {
        return this.findAttribute(name, namespace) != null;
    }

    @Override
    public Properties getAttributes() {
        Properties result = new Properties();
        Enumeration<XMLAttribute> enum1 = this.attributes.elements();
        while (enum1.hasMoreElements()) {
            XMLAttribute attr = enum1.nextElement();
            result.put(attr.getFullName(), attr.getValue());
        }
        return result;
    }

    @Override
    public Properties getAttributesInNamespace(String namespace) {
        Properties result = new Properties();
        Enumeration<XMLAttribute> enum1 = this.attributes.elements();
        while (enum1.hasMoreElements()) {
            XMLAttribute attr = enum1.nextElement();
            if (namespace == null) {
                if (attr.getNamespace() != null) continue;
                result.put(attr.getName(), attr.getValue());
                continue;
            }
            if (!namespace.equals(attr.getNamespace())) continue;
            result.put(attr.getName(), attr.getValue());
        }
        return result;
    }

    @Override
    public String getSystemID() {
        return this.systemID;
    }

    @Override
    public int getLineNr() {
        return this.lineNr;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public boolean equals(Object rawElement) {
        try {
            return this.equalsXMLElement((IXMLElement)rawElement);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean equalsXMLElement(IXMLElement elt) {
        if (!this.name.equals(elt.getName())) {
            return false;
        }
        if (this.attributes.size() != elt.getAttributeCount()) {
            return false;
        }
        Enumeration<XMLAttribute> enum1 = this.attributes.elements();
        while (enum1.hasMoreElements()) {
            XMLAttribute attr = enum1.nextElement();
            if (!elt.hasAttribute(attr.getName(), attr.getNamespace())) {
                return false;
            }
            String value = elt.getAttribute(attr.getName(), attr.getNamespace(), null);
            if (!attr.getValue().equals(value)) {
                return false;
            }
            String type = elt.getAttributeType(attr.getName(), attr.getNamespace());
            if (attr.getType().equals(type)) continue;
            return false;
        }
        if (this.children.size() != elt.getChildrenCount()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            IXMLElement child2;
            IXMLElement child1 = this.getChildAtIndex(i);
            if (child1.equalsXMLElement(child2 = elt.getChildAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public IXMLElement get(String key) {
        String[] path = key.split("/");
        IXMLElement elt = this;
        for (int i = 0; i < path.length; ++i) {
            if ((elt = elt.getFirstChildNamed(path[i])) != null) continue;
            return null;
        }
        return elt;
    }

    @Override
    public String getContent(String key) {
        IXMLElement elt = this.get(key);
        String result = null;
        if (elt != null) {
            result = elt.getContent();
        }
        return result;
    }
}

