/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.tools;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.tools.ImportSACPanel;
import gov.usgs.winston.tools.ImportSeedPanel;
import gov.usgs.winston.tools.ImportWSPanel;
import gov.usgs.winston.tools.TermIO;
import gov.usgs.winston.tools.TimePanel;
import gov.usgs.winston.tools.WWSClientPanel;
import gov.usgs.winston.tools.WinstonToolsMenu;
import gov.usgs.winston.tools.WinstonToolsPanel;
import gov.usgs.winston.tools.WinstonToolsRunnablePanel;
import gov.usgs.winston.tools.WinstonToolsStoppablePanel;
import gov.usgs.winston.tools.WinstonUpgradePanel;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class WinstonTools
extends JFrame {
    private static final long serialVersionUID = -1L;
    private JTabbedPane tabbedPane;
    private WinstonToolsMenu menuBar;
    private static final String TITLE = "Winston Tools";
    private static final String VERSION = "1.0.0.20110420";
    private final Logger logger = Log.getLogger("gov.usgs.winston");
    private static WinstonTools application;

    public WinstonTools(String[] args) {
        super("Winston Tools [1.0.0.20110420]");
        this.logger.fine("WinstonTools version: 1.0.0.20110420");
        String[] ss = Util.getVersion("gov.usgs.winston.winstonTools");
        if (ss == null) {
            this.logger.fine("no build version information available");
        } else {
            this.logger.fine("build version/date: " + ss[0] + "/" + ss[1]);
        }
        application = this;
    }

    public static void setRunning(WinstonToolsRunnablePanel p) {
        if (p == null) {
            TermIO.stopRunning();
            WinstonTools.enableWinstonPanels(true);
        } else {
            WinstonTools.enableWinstonPanels(false);
            TermIO.startRunning(p instanceof WinstonToolsStoppablePanel);
        }
    }

    private static void enableWinstonPanels(boolean b) {
        JTabbedPane tabbedPane = WinstonTools.getApplication().tabbedPane;
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            WinstonToolsPanel wtp = (WinstonToolsPanel)tabbedPane.getComponentAt(i);
            if (!wtp.needsWinston() || i == tabbedPane.getSelectedIndex()) continue;
            tabbedPane.setEnabledAt(i, b);
        }
    }

    private void createUI() {
        this.menuBar = new WinstonToolsMenu();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.setSize(520, 640);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        this.setJMenuBar(this.menuBar);
        this.tabbedPane = new JTabbedPane(2);
        this.addPanel(new TimePanel());
        this.addPanel(new WWSClientPanel());
        this.addPanel(new ImportSACPanel());
        this.addPanel(new ImportSeedPanel());
        this.addPanel(new ImportWSPanel());
        this.addPanel(new WinstonUpgradePanel());
        this.add(this.tabbedPane);
        WinstonDatabase winston = WinstonDatabase.processWinstonConfigFile(new ConfigFile("Winston.config"));
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            WinstonToolsPanel wtp = (WinstonToolsPanel)this.tabbedPane.getComponentAt(i);
            this.tabbedPane.setTitleAt(i, wtp.getTitle());
        }
        boolean winstonAlive = winston.checkConnect();
        WinstonTools.enableWinstonPanels(winstonAlive);
        if (!winstonAlive) {
            String message = "I couldn't find a valid Winston.config file in \n" + System.getProperty("user.dir") + "." + "\nSome features have been disabled.";
            JOptionPane.showMessageDialog(this, message, "Cannot connect to winston", 0);
        }
    }

    private void addPanel(WinstonToolsPanel p) {
        this.tabbedPane.add(p);
        this.menuBar.addHelpItem(p);
    }

    private static WinstonTools getApplication() {
        return application;
    }

    public static void main(String[] args) {
        TermIO.getTerm();
        try {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e1) {
            // empty catch block
        }
        WinstonTools tools = new WinstonTools(args);
        tools.createUI();
    }
}

