/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.monitor.server;

import gov.usgs.net.Command;
import gov.usgs.net.NetTools;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.wave.Wave;
import gov.usgs.winston.monitor.MonitorServer;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.text.DecimalFormat;

public abstract class BaseCommand
implements Command {
    protected NetTools netTools;
    protected MonitorServer mon;

    public BaseCommand(NetTools nt, MonitorServer mon) {
        this.netTools = nt;
        this.mon = mon;
    }

    protected void sendNoChannelResponse(String id, int pin, String s, String c, String n, String l, SocketChannel channel) {
        String loc = "";
        if (l != null) {
            loc = " " + l;
        }
        this.netTools.writeString(id + " " + id + " " + pin + " " + s + " " + c + " " + n + loc + " FN\n", channel);
    }

    protected int writeByteBuffer(String id, ByteBuffer bb, boolean compress, SocketChannel channel) {
        if (bb == null) {
            this.netTools.writeString(id + " 0\n", channel);
            return 0;
        }
        if (compress) {
            bb = ByteBuffer.wrap(Util.compress(bb.array()));
        }
        this.netTools.writeString(id + " " + bb.limit() + "\n", channel);
        return this.netTools.writeByteBuffer(bb, channel);
    }

    protected String getError(double[] d) {
        if (d == null || d.length != 2) {
            return "";
        }
        if (Double.isNaN(d[0]) && Double.isNaN(d[1])) {
            return "FB";
        }
        if (Double.isNaN(d[0])) {
            return "FL s4 " + Double.toString(Util.j2KToEW(d[1]));
        }
        if (Double.isNaN(d[1])) {
            return "FR s4 " + Double.toString(Util.j2KToEW(d[0]));
        }
        return "OK";
    }

    protected boolean allowTransaction(double[] d) {
        return d != null && d.length == 2 && !Double.isNaN(d[0]) && !Double.isNaN(d[1]);
    }

    public void writeWaveAsAscii(Wave wave, int sid, String id, String s, String c, String n, String l, double t1, double t2, String fill, SocketChannel channel) {
        DecimalFormat numberFormat = new DecimalFormat("#.######");
        String sts = null;
        double ct = wave.getStartTime() - wave.getRegistrationOffset();
        double dt = 1.0 / wave.getSamplingRate();
        for (int i = 0; i < wave.samples() && !(ct >= t1 - dt / 2.0); ct += dt, ++i) {
        }
        sts = numberFormat.format(Util.j2KToEW(ct));
        ByteBuffer bb = ByteBuffer.allocate(wave.samples() * 13 + 256);
        bb.put(id.getBytes());
        bb.put((byte)32);
        bb.put(Integer.toString(sid).getBytes());
        bb.put((byte)32);
        bb.put(s.getBytes());
        bb.put((byte)32);
        bb.put(c.getBytes());
        bb.put((byte)32);
        bb.put(n.getBytes());
        if (l != null) {
            bb.put((byte)32);
            bb.put(l.getBytes());
        }
        bb.put(" F s4 ".getBytes());
        bb.put(sts.getBytes());
        bb.put((byte)32);
        bb.put(Double.toString(wave.getSamplingRate()).getBytes());
        bb.put(" ".getBytes());
        ct = wave.getStartTime();
        int samples = 0;
        for (int i = 0; i < wave.samples(); ++i) {
            if (ct >= t1 - dt / 2.0) {
                ++samples;
                int sample = wave.buffer[i];
                if (sample == Wave.NO_DATA) {
                    bb.put(fill.getBytes());
                } else {
                    bb.put(Integer.toString(wave.buffer[i]).getBytes());
                }
                bb.put((byte)32);
            }
            if ((ct += dt) >= t2) break;
        }
        bb.put((byte)10);
        bb.flip();
        this.netTools.writeByteBuffer(bb, channel);
    }
}

