/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.monitor.collector;

import gov.usgs.earthworm.Menu;
import gov.usgs.earthworm.MenuItem;
import gov.usgs.net.HttpRequest;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.winston.monitor.Collector;
import gov.usgs.winston.server.WWSClient;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;

public class WWSCollector
extends Collector {
    private static final int DEFAULT_INSPECTION_INTERVAL = 5;
    private static final int DEFAULT_PORT = 16022;
    private static final String DEFAULT_SERVER = "localhost";
    private static final String DEFAULT_AGE_THRESHOLD = "-1w";
    private static final String DEFAULT_SPAN = "-1d";
    private String server;
    private int port;
    private double ageThreshold;
    private WWSClient winston;

    public void configure(String n, ConfigFile cc, ConfigFile wc) {
        this.setName(n);
        this.quit = false;
        this.rrdBase = "rrds";
        this.winstonConfig(wc);
        this.inspectionInterval = Util.stringToInt(cc.getString("instpectionInterval"), 5);
        this.port = Util.stringToInt(cc.getString("port"), 16022);
        this.server = Util.stringToString(cc.getString("server"), DEFAULT_SERVER);
        this.ageThreshold = Time.getRelativeTime(Util.stringToString(cc.getString("ageThreshold"), DEFAULT_AGE_THRESHOLD));
        this.winston = new WWSClient(this.server, this.port);
        this.winston.connect();
    }

    protected void poll() {
        String[] status;
        int connectionCount = 0;
        int channelCount = 0;
        double medianDataAge = 0.0;
        if (!this.winston.connected()) {
            this.winston.connect();
        }
        if ((status = this.winston.getStatus(this.ageThreshold)) == null) {
            return;
        }
        for (String s : status) {
            if (s.startsWith("Connection count:")) {
                connectionCount = Integer.parseInt(s.split(": ")[1]);
                continue;
            }
            if (s.startsWith("Channel count:")) {
                channelCount = Integer.parseInt(s.split(": ")[1]);
                continue;
            }
            if (!s.startsWith("Median data age:")) continue;
            medianDataAge = Double.parseDouble(s.split(": ")[1]);
        }
        String rrdPath = this.rrdBase + File.separator + this.getName() + ".rrd";
        if (!new File(rrdPath).exists()) {
            this.createRrd(rrdPath, System.currentTimeMillis() / 1000L);
        }
        this.updateRrd(rrdPath, connectionCount, channelCount, medianDataAge);
    }

    private void createRrd(String rrdPath, long startTime) {
        int interval = 300;
        System.out.println("== Creating RRD file " + rrdPath);
        RrdDef rrdDef = new RrdDef(rrdPath, startTime - (long)interval, (long)interval);
        for (WWSStat t : WWSStat.values()) {
            rrdDef.addDatasource(t.toString(), DsType.GAUGE, 600L, 0.0, Double.NaN);
        }
        rrdDef.addArchive(ConsolFun.LAST, 0.5, 1, 600);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 6, 700);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 24, 775);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 288, 797);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 6, 700);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 24, 775);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 288, 797);
        rrdDef.addArchive(ConsolFun.MIN, 0.5, 6, 700);
        rrdDef.addArchive(ConsolFun.MIN, 0.5, 24, 775);
        rrdDef.addArchive(ConsolFun.MIN, 0.5, 288, 797);
        try {
            RrdDb rrdDb = new RrdDb(rrdDef);
            System.out.println("== RRD file created.");
            if (!rrdDb.getRrdDef().equals((Object)rrdDef)) {
                System.out.println("Invalid RRD file created. This is a serious bug, bailing out");
                return;
            }
            System.out.println("Checking RRD file structure... OK");
            rrdDb.close();
            System.out.println("== RRD file closed.");
        }
        catch (IOException e) {
            System.out.println("Can't create RRD " + rrdPath + ": " + e.getMessage());
        }
    }

    private void updateRrd(String rrdPath, int connectionCount, int channelCount, double medianDataAge) {
        Sample sample = null;
        try {
            RrdDb rrdDb = new RrdDb(rrdPath);
            sample = rrdDb.createSample();
            sample.setTime(System.currentTimeMillis() / 1000L);
            sample.setValue("connectionCount", (double)connectionCount);
            sample.setValue("channelCount", (double)channelCount);
            sample.setValue("medianDataAge", medianDataAge);
            System.out.println(sample.dump());
            try {
                sample.update();
            }
            catch (IllegalArgumentException e) {
                System.out.println("Duplicate rrd update: " + e.getMessage());
            }
            rrdDb.close();
        }
        catch (IOException e) {
            System.out.println("Can't update RRD " + rrdPath + ": " + e.getMessage());
        }
    }

    public byte[] createPlot(HttpRequest req) throws IOException {
        String rrd = this.rrdBase + File.separator + this.getName() + ".rrd";
        long start = System.currentTimeMillis() / 1000L - (long)Time.getRelativeTime(Util.stringToString(req.getArguments().get(this.getName() + "_timeSpan"), DEFAULT_SPAN));
        WWSStat stat = WWSStat.fromString(req.getArguments().get(this.getName() + "_status"));
        RrdGraphDef gDef = this.getGDef();
        gDef.setStartTime(start);
        gDef.setTitle(this.getName() + " " + stat.toTitle());
        gDef.setVerticalLabel(stat.toUnit());
        gDef.datasource(stat.toString() + "_MAX", rrd, stat.toString(), ConsolFun.MAX);
        gDef.datasource(stat.toString() + "_MIN", rrd, stat.toString(), ConsolFun.MIN);
        gDef.datasource(stat.toString() + "_AVG", rrd, stat.toString(), ConsolFun.AVERAGE);
        gDef.area(stat.toString() + "_MAX", (Paint)this.maxColor, "");
        gDef.area(stat.toString() + "_MIN", (Paint)this.minColor, "");
        gDef.line(stat.toString() + "_AVG", (Paint)this.avgColor, "", 2.0f);
        gDef.gprint(stat.toString() + "_AVG", ConsolFun.MAX, "Max = " + stat.format);
        gDef.gprint(stat.toString() + "_AVG", ConsolFun.MIN, "Min = " + stat.format);
        gDef.gprint(stat.toString() + "_AVG", ConsolFun.AVERAGE, "Average = " + stat.format + "\\r");
        RrdGraph graph = new RrdGraph(gDef);
        return graph.getRrdGraphInfo().getBytes();
    }

    public String getMenu() {
        StringBuilder output = new StringBuilder();
        output.append("<INPUT TYPE=\"radio\" NAME=\"" + this.getName() + "_type\" VALUE=\"plot\" CHECKED>");
        output.append("Time Span: <SELECT NAME=\"" + this.getName() + "_timeSpan\">");
        output.append("<OPTION VALUE=\"-1d\">1 day</OPTION>");
        output.append("<OPTION VALUE=\"-1w\" SELECTED>1 week</OPTION>");
        output.append("<OPTION VALUE=\"-4w\">4 weeks</OPTION>");
        output.append("<OPTION VALUE=\"-1y\">1 year</OPTION>");
        output.append("</SELECT>");
        output.append("<BR><INPUT TYPE=\"radio\" NAME=\"" + this.getName() + "_type\" VALUE=\"status\">Status");
        output.append("<BR><INPUT TYPE=\"radio\" NAME=\"" + this.getName() + "_type\" VALUE=\"menu\">Menu");
        return output.toString();
    }

    public String createPlotPane(HttpRequest req) throws IOException {
        String c = req.getArguments().get("collector");
        String ts = req.getArguments().get(c + "_timeSpan");
        String action = req.getArguments().get(c + "_type");
        if (action.equals("plot")) {
            return this.buildPlotsPane(c, ts);
        }
        if (action.equals("status")) {
            return this.buildStatsPane();
        }
        if (action.equals("menu")) {
            return this.buildWWSMenu(req);
        }
        return "Do know how to " + action;
    }

    private String buildPlotsPane(String c, String ts) {
        StringBuilder output = new StringBuilder();
        for (WWSStat w : WWSStat.values()) {
            output.append(String.format("<IMAGE SRC=\"/img?collector=%s&%s_status=%s&%s_timeSpan=%s\">", c, c, w.string, c, ts));
            output.append("<P>");
        }
        return output.toString();
    }

    private String buildWWSMenu(HttpRequest req) {
        StringBuilder output = new StringBuilder();
        if (!this.winston.connected()) {
            this.winston.connect();
        }
        String c = req.getArguments().get("collector");
        String sortOrder = req.getArguments().get(c + "_sortOrder");
        output.append("<DIV style=\"float: left;width: 100%; padding: 0%; \"><DIV style=\"width: 100%; border: solid #2c5700 thin;text-align: center; background: #cbdfe9; padding: .5em;\">" + this.server + ":" + this.port + "</DIV><BR>");
        output.append("<TABLE>");
        output.append("<TR><TD>Station</TD><TD>Start</TD><TD>End</TD></TR>");
        for (MenuItem i : this.winston.getMenu().getItems()) {
            output.append(String.format("<TR><TD>%s</TD><TD>%s&nbsp;&nbsp;</TD><TD>%s</TD></TR>", i.getLocation() == null ? i.getSCN() : i.getSCNL(), Time.toDateString(Util.ewToJ2K(i.getStartTime())), Time.toDateString(Util.ewToJ2K(i.getEndTime()))));
        }
        output.append("</TABLE>");
        for (String key : req.getArguments().keySet()) {
            output.append(key + " =  " + req.getArguments().get(key) + "<BR>");
        }
        return output.toString();
    }

    private String buildStatsPane() {
        StringBuilder output = new StringBuilder();
        if (!this.winston.connected()) {
            this.winston.connect();
        }
        ArrayList<Integer> ages = new ArrayList<Integer>();
        Menu menu = this.winston.getMenu();
        MenuItem mostRecentItem = null;
        int now = (int)(System.currentTimeMillis() / 1000L);
        int lessThanOneMin = 0;
        int lessThanFiveMin = 0;
        int lessThanOneHour = 0;
        int lessThanOneDay = 0;
        int lessThanFourWeeks = 0;
        int moreThanFourWeeks = 0;
        for (MenuItem i : this.winston.getMenu().getItems()) {
            int age = (int)((double)now - i.getEndTime());
            ages.add(age);
            if (mostRecentItem == null || mostRecentItem.getEndTime() < i.getEndTime()) {
                mostRecentItem = i;
            }
            if (age < 60) {
                ++lessThanOneMin;
                continue;
            }
            if (age < 300) {
                ++lessThanFiveMin;
                continue;
            }
            if (age < 3600) {
                ++lessThanOneHour;
                continue;
            }
            if (age < 86400) {
                ++lessThanOneDay;
                continue;
            }
            if (age < 2419200) {
                ++lessThanFourWeeks;
                continue;
            }
            ++moreThanFourWeeks;
        }
        Collections.sort(ages);
        String mostRecent = mostRecentItem.getLocation() == null ? mostRecentItem.getSCN() : mostRecentItem.getSCNL();
        output.append("<DIV style=\"float: left;width: 45%; padding: 0%; \"><DIV style=\"width: 100%; border: solid #2c5700 thin;text-align: center; background: #cbdfe9; padding: .5em;\">" + this.server + ":" + this.port + "</DIV><BR>");
        output.append("Channel count: " + menu.numItems() + "<BR>");
        output.append("Median data age: " + ages.get(ages.size() / 2) + " seconds<BR>");
        output.append("Most recent insert: " + mostRecent + "<BR>");
        output.append("<P><DIV style=\"width: 100%; border: solid #2c5700 thin;text-align: center; background: #cbdfe9; padding: .5em;\">Data Freshness</DIV><BR>");
        output.append(String.format("%d < 1 minute <BR>", lessThanOneMin));
        output.append(String.format("%d < 5 minutes <BR>", lessThanFiveMin));
        output.append(String.format("%d < 1 hour <BR>", lessThanOneHour));
        output.append(String.format("%d < 1 day <BR>", lessThanOneDay));
        output.append(String.format("%d < 4 weeks <BR>", lessThanFourWeeks));
        output.append(String.format("%d>= 4 weeks <BR>", moreThanFourWeeks));
        output.append("</DIV>");
        output.append("<DIV style=\"float: right;width: 45%;padding: 0%; height: 100%;\"><DIV style=\"width: 100%; border: solid #2c5700 thin;text-align: center; background: #cbdfe9; padding: .5em;\">" + (lessThanOneHour + lessThanOneDay) + " channels between 5 minutes and 24 hours old</DIV><BR>");
        for (MenuItem i : this.winston.getMenu().getSortedItems()) {
            if (!((double)now - i.getEndTime() > 300.0) || !((double)now - i.getEndTime() < 86400.0)) continue;
            output.append((i.getLocation() == null ? i.getSCN() : i.getSCNL()) + "<BR>");
        }
        return output.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WWSStat {
        CONNECTIONS("connectionCount", "Connection Count", "Connections", "%.0f%s"),
        CHANNELS("channelCount", "Channel Count", "Channels", "%.0f%s"),
        DATA_AGE("medianDataAge", "Median Data Age", "Seconds", "%.3f%s");

        private String string;
        private String title;
        private String unit;
        private String format;

        private WWSStat(String s, String t, String u, String f) {
            this.string = s;
            this.title = t;
            this.unit = u;
            this.format = f;
        }

        public String toString() {
            return this.string;
        }

        public String toTitle() {
            return this.title;
        }

        public String toUnit() {
            return this.unit;
        }

        public static WWSStat fromString(String s) {
            if (s == null) {
                return null;
            }
            if (s.equals("connectionCount")) {
                return CONNECTIONS;
            }
            if (s.equals("channelCount")) {
                return CHANNELS;
            }
            if (s.equals("medianDataAge")) {
                return DATA_AGE;
            }
            return null;
        }
    }
}

