/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.monitor;

import gov.usgs.util.Util;
import gov.usgs.vdx.data.wave.Wave;

public class McVcoCalPulse {
    private final double startTime;
    private int gain;
    private int unitId;
    private boolean dataFound;
    private double voltage;
    private Wave wave;
    private double endPreambleSignal;
    private String endPreambleString;
    private double endPreambleQuiet;
    private double beginGain;
    private double beginId;
    private double beginVolt;

    public McVcoCalPulse(Wave w) {
        this.wave = w;
        this.startTime = this.wave.getStartTime();
        try {
            this.decode();
            this.dataFound = true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.dataFound = false;
        }
        System.out.println("endPreSig: " + Util.j2KToDateString(this.endPreambleSignal) + "; endPreQuiet: " + Util.j2KToDateString(this.endPreambleQuiet) + "; beginGain: " + Util.j2KToDateString(this.beginGain) + "; beginId: " + Util.j2KToDateString(this.beginId) + "; beginVolt: " + Util.j2KToDateString(this.beginVolt));
        System.out.println(this.endPreambleString);
    }

    public boolean dataFound() {
        return this.dataFound;
    }

    private int decodeBit(int i) {
        return Math.signum(this.wave.buffer[i]) == 1.0f ? 1 : 0;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public int getGain() {
        return this.gain;
    }

    public int getUnitId() {
        return this.unitId;
    }

    public double getVoltage() {
        return this.voltage;
    }

    private void decode() {
        int j;
        Wave w;
        double st = this.wave.getStartTime();
        double et = this.wave.getEndTime();
        double sr = this.wave.getSamplingRate();
        do {
            w = this.wave.subset(st += 0.25, st + 0.25);
        } while (st < et - 0.5 && Math.abs((double)w.max() - w.mean()) > 200.0);
        this.endPreambleSignal = st;
        this.endPreambleString = "abs (max: " + w.max() + "- mean: " + w.mean() + ") = " + Math.abs((double)w.max() - w.mean());
        this.wave = this.wave.subset(st, et);
        double mean = this.wave.mean();
        int i = 0;
        while (i < this.wave.buffer.length) {
            int n = i++;
            this.wave.buffer[n] = (int)((double)this.wave.buffer[n] - mean);
        }
        this.wave.invalidateStatistics();
        double min = this.wave.subset(st, st + 0.25).min();
        int i2 = 0;
        while ((double)this.wave.buffer[i2] > 2.0 * min) {
            ++i2;
        }
        while (this.wave.buffer[i2] < this.wave.buffer[i2 - 1]) {
            --i2;
        }
        this.endPreambleQuiet = st + (double)(++i2) / sr;
        i2 = (int)((double)i2 + sr * 17.0);
        while (Math.abs(this.wave.buffer[i2]) < 500) {
            ++i2;
        }
        this.beginGain = st + (double)i2 / sr;
        for (j = 0; j < 3; ++j) {
            this.gain = (int)((double)this.gain + (double)this.decodeBit(i2) * Math.pow(2.0, j));
            i2 = (int)((double)i2 + sr);
        }
        this.gain *= 10;
        this.beginId = st + (double)i2 / sr;
        for (j = 0; j < 10; ++j) {
            this.unitId = (int)((double)this.unitId + (double)this.decodeBit(i2) * Math.pow(2.0, 9 - j));
            i2 = (int)((double)i2 + sr);
        }
        this.beginVolt = st + (double)i2 / sr;
        double previous2Seconds = 0.0;
        double next2Seconds = 0.0;
        int j2 = 0;
        while ((double)j2 < 2.0 * sr) {
            previous2Seconds += (double)Math.abs(this.wave.buffer[i2 - j2]);
            next2Seconds += (double)Math.abs(this.wave.buffer[i2 + j2]);
            ++j2;
        }
        if (next2Seconds > previous2Seconds * 0.9) {
            this.voltage = 0.0;
            for (j2 = 0; j2 < 12; ++j2) {
                this.voltage += (double)this.decodeBit(i2) * Math.pow(2.0, 11 - j2);
                i2 = (int)((double)i2 + sr);
            }
            this.voltage /= 80.0;
        }
    }
}

