/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in.ew;

import gov.usgs.earthworm.TraceBuf;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.winston.in.ew.Options;
import gov.usgs.winston.in.ew.TraceBufFilter;

public class TimeFilter
extends TraceBufFilter {
    private double tLessThan;
    private double tGreaterThan;

    public TimeFilter() {
    }

    public TimeFilter(double tlt, double tgt) {
        this();
        this.tLessThan = tlt;
        this.tGreaterThan = tgt;
    }

    public void configure(ConfigFile cf) {
        super.configure(cf);
        if (cf == null) {
            return;
        }
        this.tLessThan = Util.stringToDouble(cf.getString("past"), Double.NaN);
        this.tGreaterThan = Util.stringToDouble(cf.getString("future"), Double.NaN);
    }

    protected boolean match(TraceBuf tb, Options options) {
        double dt = tb.getStartTimeJ2K() - CurrentTime.getInstance().nowJ2K();
        if (!Double.isNaN(this.tLessThan) && dt < this.tLessThan) {
            return true;
        }
        return !Double.isNaN(this.tGreaterThan) && dt > this.tGreaterThan;
    }

    public String toString() {
        return String.format("TimeFilter [%s: %.2f > dt > %.2f]", this.accept ? "accept" : "reject", this.tLessThan, this.tGreaterThan);
    }
}

