/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in.ew;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import gov.usgs.earthworm.ImportGeneric;
import gov.usgs.earthworm.Message;
import gov.usgs.earthworm.MessageListener;
import gov.usgs.earthworm.TraceBuf;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import gov.usgs.winston.db.Admin;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.InputEW;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.in.ew.ChannelStatus;
import gov.usgs.winston.in.ew.Options;
import gov.usgs.winston.in.ew.OptionsFilter;
import gov.usgs.winston.in.ew.TraceBufFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportEW
extends Thread {
    public static final String DEFAULT_CONFIG_FILENAME = "ImportEW.config";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 16022;
    public static final int DEFAULT_TIMEOUT = 2000;
    public static final int DEFAULT_HEARTBEAT_INTERVAL = 30000;
    public static final int DEFAULT_EXPECTED_HEARTBEAT_INTERVAL = 30000;
    public static final int DEFAULT_STATUS_INTERVAL = 60;
    public static final String DEFAULT_RECEIVE_ID = "MSG_FROM_EXPORT";
    public static final String DEFAULT_SEND_ID = "MSG_TO_EXPORT";
    public static final String DEFAULT_DRIVER = "com.mysql.jdbc.Driver";
    public static final int DEFAULT_MAX_DAYS = 0;
    public static final int DEFAULT_MAX_BACKLOG = 100;
    public static final String DEFAULT_LOG_LEVEL = "FINE";
    public static final String DEFAULT_LOG_FILE = "ImportEW.log";
    public static final int DEFAULT_LOG_NUM_FILES = 10;
    public static final int DEFAULT_LOG_FILE_SIZE = 1000000;
    public static final double DEFAULT_TIME_THRESHOLD = 1.0;
    public static final int DEFAULT_BACKLOG_THRESHOLD = 1;
    public static final boolean DEFAULT_RSAM_ENABLE = true;
    public static final int DEFAULT_RSAM_DELTA = 10;
    public static final int DEFAULT_RSAM_DURATION = 60;
    public static final int DEFAULT_DROP_TABLE_DELAY = 10;
    public static final int DEFAULT_REPAIR_RETRY_INTERVAL = 600;
    public static String JSAP_PROGRAM_NAME = "java gov.usgs.winston.in.ew.ImportEW";
    public static String JSAP_EXPLANATION_PREFACE = "Winston ImportEW\n\nThis program gets data from an Earthworm export process and imports\nit into a Winston database. See 'ImportEW.config' for more options.\n\n";
    private static final String DEFAULT_JSAP_EXPLANATION = "All output goes to both standard error and the file log.\n\nWhile the process is running (and accepting console input) you can enter\nthese commands into the console (followed by [Enter]):\n0: turn logging off.\n1: normal logging level (WARNING).\n2: high logging level (FINE).\n3: log everything.\ns: display status information.\nc[col][-]: channel list, sorted by col, - for descending. Examples: c, cl-, cx\ni: no longer accept console input.\nq: quit cleanly.\nctrl-c: quit now.\n\nNote that if console input is disabled the only way to\nterminate the program is with ctrl-c or by killing the process.\n";
    private static final Parameter[] DEFAULT_JSAP_PARAMETERS = new Parameter[]{new FlaggedOption("logLevel", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'l', "log-level", "The level of logging to start with\nThis may consist of either a java.util.logging.Level name or an integer value.\nFor example: \"SEVERE\", or \"1000\""), new Switch("logoff", '0', "logoff", "Turn logging off (equivalent to --log-level OFF)."), new Switch("lognormal", '1', "lognormal", "Normal (default) logging level (equivalent to --log-level FINE)."), new Switch("loghigh", '2', "loghigh", "High logging level (equivalent to --log-level ALL)."), new Switch("noinput", 'i', "noinput", "Don't accept input from the console."), new UnflaggedOption("configFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The config file name.")};
    protected String configFilename;
    protected ConfigFile config;
    private WinstonDatabase winston;
    private Channels channels;
    private InputEW input;
    protected ImportGeneric importGeneric;
    private final Set<String> existingChannels;
    private final Map<String, ConcurrentLinkedQueue<TraceBuf>> channelTraceBufs;
    protected final Logger logger;
    protected String logFile;
    protected int logNumFiles;
    protected int logSize;
    private final ExecutorService fixer;
    private WinstonDatabase fixerWinston;
    private Admin fixerAdmin;
    private InputEW fixerInput;
    private final Set<String> underRepair;
    private final Map<String, Double> attemptedRepair;
    private int repairRetryInterval;
    protected final CodeTimer inputTimer;
    protected int totalTraceBufsWritten = 0;
    protected int totalTraceBufs;
    protected int totalTraceBufsDropped;
    protected int totalTraceBufsAccepted;
    protected int totalTraceBufsRejected;
    protected int totalTraceBufsFailed;
    protected final Map<String, ChannelStatus> channelStatus;
    protected final Date importStartTime;
    protected final DateFormat dateFormat;
    protected final DateFormat winstonDateFormat;
    protected int dropTableDelay = 10000;
    protected Options defaultOptions;
    protected final Map<String, Options> channelOptions;
    protected Map<String, Map<String, String>> channelMetadata;
    private volatile boolean quit = false;
    protected List<TraceBufFilter> traceBufFilters;
    protected List<OptionsFilter> optionFilters;

    public ImportEW(String fn) {
        this();
        this.configFilename = Util.stringToString(fn, DEFAULT_CONFIG_FILENAME);
        this.importGeneric = new ImportGeneric(){

            public void outOfMemoryErrorOccurred(OutOfMemoryError e) {
                ImportEW.this.handleOutOfMemoryError(e);
            }
        };
        this.importGeneric.setLogger(this.logger);
        this.config = new ConfigFile(this.configFilename);
        this.channelMetadata = new HashMap<String, Map<String, String>>();
        this.processConfigFile();
    }

    public ImportEW() {
        this.setName("ImportEW");
        this.importStartTime = CurrentTime.getInstance().nowDate();
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.winstonDateFormat = new SimpleDateFormat("yyyy_MM_dd");
        this.winstonDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.channelOptions = new HashMap<String, Options>();
        this.channelStatus = new HashMap<String, ChannelStatus>();
        this.inputTimer = new CodeTimer("inputTimer", false);
        this.channelTraceBufs = new ConcurrentHashMap<String, ConcurrentLinkedQueue<TraceBuf>>(200, 0.75f, 1);
        this.fixer = Executors.newSingleThreadExecutor();
        this.underRepair = Collections.synchronizedSet(new HashSet());
        this.attemptedRepair = Collections.synchronizedMap(new HashMap());
        this.existingChannels = Collections.synchronizedSet(new HashSet());
        this.logger = Log.getLogger("gov.usgs.winston");
        this.logger.setLevel(Level.parse(DEFAULT_LOG_LEVEL));
    }

    public void handleOutOfMemoryError(OutOfMemoryError e) {
        this.channelTraceBufs.clear();
        this.logger.warning("Handled OutOfMemoryError, TraceBuf queues cleared.");
        e.printStackTrace();
    }

    protected void fatalError(String msg) {
        this.logger.severe(msg);
        System.exit(1);
    }

    protected void processConfigFile() {
        this.processLoggerConfig();
        this.processImportConfig();
        this.processWinstonConfig();
        this.processDefaultOptions();
        this.processOptions();
        this.processFilters();
    }

    protected void processLoggerConfig() {
        String[] version;
        this.logFile = Util.stringToString(this.config.getString("import.log.name"), DEFAULT_LOG_FILE);
        this.logNumFiles = Util.stringToInt(this.config.getString("import.log.numFiles"), 10);
        this.logSize = Util.stringToInt(this.config.getString("import.log.maxSize"), 1000000);
        if (this.logNumFiles > 0) {
            Log.attachFileLogger(this.logger, this.logFile, this.logSize, this.logNumFiles, true);
        }
        if ((version = Util.getVersion("gov.usgs.winston")) != null) {
            this.logger.info("Version: " + version[0] + " Built: " + version[1]);
        } else {
            this.logger.info("No version information available.");
        }
        this.logger.info("config: import.log.name=" + this.logFile);
        this.logger.info("config: import.log.numFiles=" + this.logNumFiles);
        this.logger.info("config: import.log.maxSize=" + this.logSize);
    }

    protected void processImportConfig() {
        String host = Util.stringToString(this.config.getString("import.host"), DEFAULT_HOST);
        int port = Util.stringToInt(this.config.getString("import.port"), 16022);
        this.logger.info("config: import.host=" + host);
        this.logger.info("config: import.port=" + port);
        this.importGeneric.setHostAndPort(host, port);
        String recvID = Util.stringToString(this.config.getString("import.receiveID"), DEFAULT_RECEIVE_ID);
        this.importGeneric.setRecvIDString(recvID);
        this.logger.info("config: import.receiveID=" + recvID);
        String sendID = Util.stringToString(this.config.getString("import.sendID"), DEFAULT_SEND_ID);
        this.importGeneric.setSendIDString(sendID);
        this.logger.info("config: import.sendID=" + sendID);
        int hbInt = Util.stringToInt(this.config.getString("import.heartbeatInterval"), 30000);
        this.importGeneric.setHeartbeatInterval(hbInt);
        this.logger.info("config: import.heartbeatInterval=" + hbInt);
        int ehbInt = Util.stringToInt(this.config.getString("import.expectedHeartbeatInterval"), 30000);
        this.importGeneric.setExpectedHeartbeatInterval(ehbInt);
        this.logger.info("config: import.expectedHeartbeatInterval=" + ehbInt);
        int to = Util.stringToInt(this.config.getString("import.timeout"), 2000);
        this.importGeneric.setTimeout(to);
        this.logger.info("config: import.timeout=" + to);
        this.dropTableDelay = Util.stringToInt(this.config.getString("import.dropTableDelay"), 10);
        this.dropTableDelay *= 1000;
        this.logger.info("config: import.dropTableDelay=" + this.dropTableDelay);
    }

    protected void processWinstonConfig() {
        String winstonDriver = Util.stringToString(this.config.getString("winston.driver"), DEFAULT_DRIVER);
        this.logger.info("config: winston.driver=" + winstonDriver);
        String winstonPrefix = this.config.getString("winston.prefix");
        if (winstonPrefix == null) {
            this.fatalError("winston.prefix is missing from config file.");
        }
        this.logger.info("config: winston.prefix=" + winstonPrefix);
        String winstonURL = this.config.getString("winston.url");
        if (winstonURL == null) {
            this.fatalError("winston.url is missing from config file.");
        }
        this.logger.info("config: winston.url=" + winstonURL);
        int winstonStatementCacheCap = Util.stringToInt(this.config.getString("winston.statementCacheCap"), 100);
        this.logger.info("config: winston.statementCacheCap=" + winstonStatementCacheCap);
        this.winston = new WinstonDatabase(winstonDriver, winstonURL, winstonPrefix, winstonStatementCacheCap);
        if (!this.winston.checkDatabase()) {
            this.fatalError("Winston database does not exist.");
        }
        this.fixerWinston = new WinstonDatabase(winstonDriver, winstonURL, winstonPrefix, winstonStatementCacheCap);
        this.fixerInput = new InputEW(this.fixerWinston);
        this.fixerAdmin = new Admin(this.fixerWinston);
        this.channels = new Channels(this.winston);
        this.input = new InputEW(this.winston);
        this.repairRetryInterval = 600;
    }

    protected void processDefaultOptions() {
        this.defaultOptions = new Options();
        this.defaultOptions.bufThreshold = 1;
        this.defaultOptions.timeThreshold = 1.0;
        this.defaultOptions.maxBacklog = 100;
        this.defaultOptions.maxDays = 0;
        this.defaultOptions.rsamEnable = true;
        this.defaultOptions.rsamDelta = 10;
        this.defaultOptions.rsamDuration = 60;
        ConfigFile dcf = this.config.getSubConfig("Default");
        this.defaultOptions = Options.createOptions(dcf, this.defaultOptions);
        this.logger.info("config, options, Default: " + this.defaultOptions);
    }

    protected void processOptions() {
        this.optionFilters = new ArrayList<OptionsFilter>();
        List<String> optionSets = this.config.getList("options");
        for (String options : optionSets) {
            if (options.equals("Default")) continue;
            ConfigFile tc = this.config.getSubConfig(options);
            try {
                OptionsFilter filter = new OptionsFilter(options, tc, this.defaultOptions);
                this.optionFilters.add(filter);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Could not create options: ", ex);
            }
        }
        for (OptionsFilter filter : this.optionFilters) {
            this.logger.info("config, options, " + filter.getName() + ": " + filter);
        }
    }

    protected void processFilters() {
        this.traceBufFilters = new ArrayList<TraceBufFilter>();
        List<String> filters = this.config.getList("filter");
        for (String filterName : filters) {
            ConfigFile fc = this.config.getSubConfig(filterName);
            try {
                TraceBufFilter filter = (TraceBufFilter)Class.forName(fc.getString("class")).newInstance();
                filter.configure(fc);
                this.traceBufFilters.add(filter);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Could not create TraceBuf filter: ", ex);
            }
        }
        Collections.sort(this.traceBufFilters);
        for (TraceBufFilter filter : this.traceBufFilters) {
            this.logger.info("config, filter: " + filter);
        }
    }

    protected TraceBufFilter matchFilter(TraceBuf tb) {
        Options options = this.getOptions(tb);
        for (TraceBufFilter filter : this.traceBufFilters) {
            if (!filter.match(tb, options)) continue;
            Map<String, String> m = filter.getMetadata();
            if (m != null) {
                this.addMetadata(tb.toWinstonString(), m);
            }
            if (!filter.isTerminal()) continue;
            return filter;
        }
        return null;
    }

    private void addMetadata(String c, Map<String, String> m) {
        Map<String, String> cm = this.channelMetadata.get(c);
        if (cm == null) {
            cm = new HashMap<String, String>();
            this.channelMetadata.put(c, cm);
        }
        cm.putAll(m);
    }

    protected void addTraceBufToQueue(TraceBuf tb) {
        String channel = tb.toWinstonString();
        ConcurrentLinkedQueue<TraceBuf> q = this.channelTraceBufs.get(channel);
        if (q == null) {
            q = new ConcurrentLinkedQueue();
            this.channelTraceBufs.put(channel, q);
        }
        Options ip = this.getOptions(tb);
        q.add(tb);
        while (q.size() > ip.maxBacklog) {
            q.poll();
            this.logger.fine("Overfull backlog, dropped TraceBuf: " + channel);
            ++this.totalTraceBufsDropped;
        }
    }

    private void cycle(boolean force) {
        for (String key : this.channelTraceBufs.keySet()) {
            ConcurrentLinkedQueue<TraceBuf> q = this.channelTraceBufs.get(key);
            if (q.isEmpty()) continue;
            Options ip = this.getOptions(q.peek());
            if (!force && !ip.thresholdExceeded(q.peek().getStartTimeJ2K(), q.size())) continue;
            this.importChannel(q);
            if (!this.channelMetadata.containsKey(key)) continue;
            this.importMetadata(key, this.channelMetadata.get(key));
        }
    }

    private Runnable getPurgeRunnable(final String code, final int maxDays) {
        return new Runnable(){

            public void run() {
                try {
                    ImportEW.this.fixerInput.purgeTables(code, maxDays);
                    try {
                        Thread.sleep(ImportEW.this.dropTableDelay);
                    }
                    catch (Exception e) {}
                }
                catch (OutOfMemoryError e) {
                    ImportEW.this.handleOutOfMemoryError(e);
                }
            }
        };
    }

    private Runnable getRepairRunnable(final String database, final String table) {
        if (this.underRepair.contains(table)) {
            return null;
        }
        Double lastRepair = this.attemptedRepair.get(table);
        if (lastRepair != null) {
            if (CurrentTime.getInstance().nowJ2K() - lastRepair > (double)this.repairRetryInterval) {
                this.attemptedRepair.remove(table);
            } else {
                return null;
            }
        }
        this.underRepair.add(table);
        return new Runnable(){

            public void run() {
                try {
                    boolean healthy = ImportEW.this.fixerAdmin.repairTable(database, table);
                    ImportEW.this.logger.info(String.format("After repair attempt, table %s appears to %s.", table, healthy ? "be healthy" : "still be broken"));
                    ImportEW.this.attemptedRepair.put(table, CurrentTime.getInstance().nowJ2K());
                    ImportEW.this.underRepair.remove(table);
                }
                catch (OutOfMemoryError e) {
                    ImportEW.this.handleOutOfMemoryError(e);
                }
            }
        };
    }

    private void importChannel(ConcurrentLinkedQueue<TraceBuf> q) {
        block25: {
            Runnable repairTask;
            ChannelStatus status;
            List<InputEW.InputResult> results;
            Options ip;
            String code;
            TraceBuf tb;
            block24: {
                if (q.isEmpty() || this.underRepair.contains("channels")) {
                    System.out.println("isempty: " + q.isEmpty());
                    System.out.println("underRepair: " + this.underRepair.contains("channels"));
                    return;
                }
                tb = q.peek();
                code = tb.toWinstonString();
                if (!this.existingChannels.contains(code) && !this.channels.channelExists(code)) {
                    this.logger.info("Creating new channel '" + code + "' in Winston database.");
                    this.channels.createChannel(code);
                }
                this.existingChannels.add(code);
                ArrayList<TraceBuf> tbs = new ArrayList<TraceBuf>(q.size());
                while (!q.isEmpty()) {
                    TraceBuf t = q.poll();
                    tbs.add(t);
                    if (!t.sendAck) continue;
                    this.importGeneric.sendAck(t.seq);
                }
                this.inputTimer.start();
                ip = this.getOptions((TraceBuf)tbs.get(0));
                results = this.input.inputTraceBufs(tbs, ip.rsamEnable, ip.rsamDelta, ip.rsamDuration);
                this.inputTimer.stop(false);
                status = this.channelStatus.get(code);
                if (status == null) {
                    status = new ChannelStatus(code);
                    this.channelStatus.put(code, status);
                }
                if (results.size() != 1) break block24;
                InputEW.InputResult result = results.get(0);
                switch (result.code) {
                    case ERROR_DATABASE: 
                    case ERROR_NO_WINSTON: {
                        break;
                    }
                    case ERROR_INPUT: {
                        break;
                    }
                    case ERROR_TIME_SPAN: {
                        this.logger.warning("Time span error.");
                        Runnable repairTask2 = this.getRepairRunnable("ROOT", "channels");
                        if (repairTask2 != null) {
                            this.fixer.submit(repairTask2);
                            break;
                        }
                        break block25;
                    }
                    default: {
                        this.logger.warning("Error: " + (Object)((Object)result.code));
                        break;
                    }
                }
                break block25;
            }
            for (int i = 0; i < results.size() - 2; ++i) {
                InputEW.InputResult result = results.get(i);
                status.process(result.traceBuf, result.code);
                boolean repair = false;
                switch (result.code) {
                    case SUCCESS_CREATED_TABLE: {
                        this.logger.fine("Day table created: " + tb.toWinstonString() + " " + this.winstonDateFormat.format(Util.j2KToDate(tb.getStartTimeJ2K())));
                        this.fixer.submit(this.getPurgeRunnable(code, ip.maxDays));
                    }
                    case SUCCESS: {
                        this.attemptedRepair.remove(code);
                        ++this.totalTraceBufsWritten;
                        this.logger.finest("Insert: " + tb.toLogString());
                        break;
                    }
                    case ERROR_DATABASE: {
                        ++this.totalTraceBufsFailed;
                        repair = true;
                        this.logger.warning("Database error: " + tb.toLogString());
                        break;
                    }
                    case ERROR_UNKNOWN: {
                        ++this.totalTraceBufsFailed;
                        repair = true;
                        this.logger.warning("Unknown insert error: " + tb.toLogString());
                        break;
                    }
                    case ERROR_CHANNEL: 
                    case ERROR_NULL_TRACEBUF: {
                        ++this.totalTraceBufsFailed;
                        this.logger.warning("Bad channel/null TraceBuf.");
                        break;
                    }
                    case ERROR_DUPLICATE: {
                        ++this.totalTraceBufsFailed;
                        this.logger.warning("Duplicate TraceBuf: " + tb.toLogString());
                        break;
                    }
                    case NO_CODE: {
                        ++this.totalTraceBufsFailed;
                        this.logger.warning("No error/success code: " + tb.toLogString());
                    }
                }
                if (!repair) continue;
                String dt = this.winstonDateFormat.format(Util.j2KToDate(tb.getStartTimeJ2K()));
                repairTask = this.getRepairRunnable(code, code + "$$" + dt);
                if (repairTask == null) continue;
                this.fixer.submit(repairTask);
            }
            InputEW.InputResult timeSpanResult = results.get(results.size() - 1);
            if (timeSpanResult.code == InputEW.InputResult.Code.ERROR_TIME_SPAN) {
                this.logger.warning("Time span error.");
                Runnable repairTask3 = this.getRepairRunnable("ROOT", "channels");
                if (repairTask3 != null) {
                    this.fixer.submit(repairTask3);
                }
            }
            InputEW.InputResult heliResult = results.get(results.size() - 2);
            if (heliResult.code == InputEW.InputResult.Code.ERROR_HELICORDER) {
                String dt = this.winstonDateFormat.format(Util.j2KToDate(heliResult.failedHeliJ2K));
                String table = code + "$$H" + dt;
                this.logger.warning("Error writing helicorder data to table " + table + ".");
                repairTask = this.getRepairRunnable(code, table);
                if (repairTask != null) {
                    this.fixer.submit(repairTask);
                }
            }
        }
    }

    private void importMetadata(String channel, Map<String, String> m) {
        if (this.underRepair.contains("channelmetadata")) {
            System.out.println("underRepair: " + this.underRepair.contains("channelmetadata"));
        } else if (!m.isEmpty()) {
            this.inputTimer.start();
            this.input.inputMetadata(channel, m);
            this.inputTimer.stop(false);
        }
    }

    @Override
    public void run() {
        TraceBufHandler tbh = new TraceBufHandler();
        this.importGeneric.addListener(20, tbh);
        this.importGeneric.addListener(19, tbh);
        boolean connected = false;
        while (!connected) {
            connected = this.importGeneric.connect();
            if (connected) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
        while (!this.quit) {
            try {
                this.cycle(true);
                Thread.sleep(10L);
            }
            catch (OutOfMemoryError e) {
                this.handleOutOfMemoryError(e);
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "Main loop exception: ", e);
            }
        }
        try {
            this.cycle(true);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Exception during final cycle: ", e);
        }
    }

    protected Options getOptions(TraceBuf tb) {
        String channel = tb.toWinstonString();
        Options ip = this.channelOptions.get(channel);
        if (ip == null) {
            ip = this.defaultOptions;
            for (OptionsFilter tf : this.optionFilters) {
                if (!tf.match(tb)) continue;
                ip = tf.getOptions();
                break;
            }
            this.channelOptions.put(channel, ip);
        }
        return ip;
    }

    public void setLogLevel(Level level) {
        if (level.equals(Level.ALL)) {
            this.logger.fine("Logging set to high.");
        } else if (level.equals(Level.FINE)) {
            this.logger.fine("Logging set to normal.");
        } else if (level.equals(Level.OFF)) {
            this.logger.fine("Logging turned off.");
        }
        this.logger.setLevel(level);
    }

    public void quit() {
        this.importGeneric.shutdown();
        try {
            this.importGeneric.join();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Failed to cleanly shutdown SeedLink Collector", e);
        }
        this.logger.fine("Quitting cleanly.");
        this.quit = true;
    }

    public void printStatus() {
        Date now = CurrentTime.getInstance().nowDate();
        long nowST = System.currentTimeMillis();
        double uptime = (double)(now.getTime() - this.importStartTime.getTime()) / 1000.0;
        ArrayList<String> strings = new ArrayList<String>(4);
        strings.add("------- ImportEW --------");
        strings.add("Status time: " + this.dateFormat.format(now));
        strings.add("Start time:  " + this.dateFormat.format(this.importStartTime));
        strings.add("Up time:     " + Util.timeDifferenceToString(uptime));
        long ht = this.importGeneric.getLastHeartbeatTime();
        double dt = (double)(nowST - ht) / 1000.0;
        if (ht == 0L) {
            strings.add("Last HB RX:  (never)");
        } else {
            strings.add("Last HB RX:  " + this.dateFormat.format(new Date(ht)) + ", " + Util.timeDifferenceToString(dt));
        }
        ht = this.importGeneric.getLastHeartbeatSentTime();
        dt = (double)(nowST - ht) / 1000.0;
        if (ht == 0L) {
            strings.add("Last HB TX:  (never)");
        } else {
            strings.add("Last HB TX:  " + this.dateFormat.format(new Date(ht)) + ", " + Util.timeDifferenceToString(dt));
        }
        Runtime rt = Runtime.getRuntime();
        strings.add(String.format("Memory (used / max): %.1fMB / %.1fMB", (double)(rt.totalMemory() - rt.freeMemory()) / 1024.0 / 1024.0, (double)rt.maxMemory() / 1024.0 / 1024.0));
        strings.add("---- TraceBufs");
        strings.add("Accepted: " + this.totalTraceBufsAccepted);
        strings.add("Written:  " + this.totalTraceBufsWritten);
        strings.add("Failed:   " + this.totalTraceBufsFailed);
        strings.add("Rejected: " + this.totalTraceBufsRejected);
        strings.add("Dropped:  " + this.totalTraceBufsDropped);
        int pending = this.totalTraceBufsAccepted - this.totalTraceBufsWritten - this.totalTraceBufsFailed - this.totalTraceBufsRejected - this.totalTraceBufsDropped;
        strings.add("Pending:  " + pending);
        strings.add("---- Timing");
        strings.add(String.format("Total input time:        %s", Util.timeDifferenceToString(this.inputTimer.getTotalTimeMillis() / 1000.0)));
        strings.add(String.format("Input time per TraceBuf: %.2fms", this.inputTimer.getTotalTimeMillis() / (double)this.totalTraceBufsWritten));
        for (String s : strings) {
            this.logger.info(s);
        }
    }

    public void printChannels(String s) {
        char col = 'C';
        if (s.length() > 1) {
            col = s.charAt(1);
        }
        boolean desc = s.endsWith("-");
        this.logger.info("------- Channels --------");
        this.logger.info(ChannelStatus.getHeaderString());
        ArrayList<ChannelStatus> channels = new ArrayList<ChannelStatus>(this.channelStatus.size());
        channels.addAll(this.channelStatus.values());
        Collections.sort(channels, ChannelStatus.getComparator(ChannelStatus.SortOrder.parse(col), desc));
        for (ChannelStatus channel : channels) {
            this.logger.info(channel.toString());
        }
        this.logger.info(ChannelStatus.getHeaderString());
    }

    public static JSAPResult getArguments(String[] args) {
        JSAPResult config = null;
        try {
            SimpleJSAP jsap = new SimpleJSAP(JSAP_PROGRAM_NAME, JSAP_EXPLANATION_PREFACE + DEFAULT_JSAP_EXPLANATION, DEFAULT_JSAP_PARAMETERS);
            config = jsap.parse(args);
            if (jsap.messagePrinted()) {
                if (!config.getBoolean("help")) {
                    System.err.println("Try using the --help flag.");
                }
                System.exit(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consoleInputManager(ImportEW im) {
        im.logger.entering(im.getClass().getName(), "consoleInputManager");
        boolean acceptCommands = true;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (acceptCommands) {
            try {
                String s = null;
                try {
                    s = in.readLine();
                }
                catch (IOException ioex) {
                    im.logger.log(Level.SEVERE, "IOException encountered while attempting to read console input.", ioex);
                }
                if (s == null) continue;
                if ((s = s.toLowerCase().trim()).equals("q")) {
                    im.quit();
                    try {
                        im.join();
                    }
                    catch (Throwable e) {
                        im.logger.log(Level.SEVERE, "Failed to quit cleanly.", e);
                    }
                    finally {
                        im.printStatus();
                    }
                    System.exit(0);
                    continue;
                }
                if (s.equals("s")) {
                    im.printStatus();
                    continue;
                }
                if (s.startsWith("c")) {
                    im.printChannels(s);
                    continue;
                }
                if (s.equals("0")) {
                    im.setLogLevel(Level.OFF);
                    continue;
                }
                if (s.equals("1")) {
                    im.setLogLevel(Level.FINE);
                    continue;
                }
                if (s.equals("2")) {
                    im.setLogLevel(Level.ALL);
                    continue;
                }
                if (!s.equals("i")) continue;
                acceptCommands = false;
                im.logger.warning("No longer accepting console commands.");
            }
            catch (OutOfMemoryError e) {
                im.handleOutOfMemoryError(e);
            }
        }
        im.logger.exiting(im.getClass().getName(), "consoleInputManager");
    }

    public static void main(String[] args) {
        JSAPResult config = ImportEW.getArguments(args);
        String fn = Util.stringToString(config.getString("configFilename"), DEFAULT_CONFIG_FILENAME);
        Level logLevel = Level.parse(DEFAULT_LOG_LEVEL);
        if (config.getString("logLevel") != null) {
            try {
                logLevel = Level.parse(config.getString("logLevel"));
            }
            catch (IllegalArgumentException ex) {
                System.err.println("Invalid log level: " + config.getString("logLevel"));
                System.err.println("Using default log level: " + logLevel);
            }
        } else {
            if (config.getBoolean("logoff")) {
                logLevel = Level.OFF;
            }
            if (config.getBoolean("lognormal")) {
                logLevel = Level.FINE;
            }
            if (config.getBoolean("loghigh")) {
                logLevel = Level.ALL;
            }
        }
        ImportEW im = new ImportEW(fn);
        im.setLogLevel(logLevel);
        im.start();
        if (!config.getBoolean("noinput")) {
            ImportEW.consoleInputManager(im);
        }
    }

    class TraceBufHandler
    implements MessageListener {
        TraceBufHandler() {
        }

        public void messageReceived(Message msg) {
            ++ImportEW.this.totalTraceBufs;
            TraceBuf tb = (TraceBuf)msg;
            ImportEW.this.logger.finest("RX: " + tb.toLogString());
            TraceBufFilter matchingFilter = ImportEW.this.matchFilter(tb);
            boolean accept = false;
            if (matchingFilter != null) {
                accept = matchingFilter.isAccept();
                ImportEW.this.logger.log(matchingFilter.getLogLevel(), String.format("%s: %s", matchingFilter, tb.toLogString()));
            } else {
                ImportEW.this.logger.finest("No matching filter, rejected: " + tb);
            }
            if (accept) {
                ++ImportEW.this.totalTraceBufsAccepted;
                ImportEW.this.addTraceBufToQueue(tb);
            } else {
                ++ImportEW.this.totalTraceBufsRejected;
                if (msg.sendAck) {
                    ImportEW.this.importGeneric.sendAck(tb.seq);
                }
                if (matchingFilter.keepRejects()) {
                    // empty if block
                }
            }
        }
    }
}

