/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db.vdx;

import gov.usgs.util.Util;
import gov.usgs.vdx.data.rsam.RSAMData;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import gov.usgs.winston.Channel;
import gov.usgs.winston.db.vdx.VDXSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VDXRSAMSource
extends VDXSource {
    @Override
    public String getType() {
        return "rsam";
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String action = params.get("action");
        if (action.equals("channels")) {
            List<Channel> chs = this.channels.getChannels();
            ArrayList<String> result = new ArrayList<String>();
            for (Channel ch : chs) {
                result.add(ch.toVDXString());
            }
            return new TextResult(result);
        }
        if (action.equals("ratdata")) {
            double period;
            double et;
            double st;
            String cids = params.get("ch");
            RSAMData data = this.getRatSAMData(cids, st = Double.parseDouble(params.get("st")), et = Double.parseDouble(params.get("et")), period = Util.stringToDouble(params.get("period"), 60.0));
            if (data != null) {
                return new BinaryResult(data);
            }
        } else if (action.equals("data") || action == null) {
            int cid = Integer.parseInt(params.get("ch"));
            double st = Double.parseDouble(params.get("st"));
            double et = Double.parseDouble(params.get("et"));
            double period = Util.stringToDouble(params.get("period"), 60.0);
            String code = this.channels.getChannelCode(cid);
            RSAMData data = this.getData(code, st, et, period);
            if (data != null) {
                return new BinaryResult(data);
            }
        }
        return null;
    }

    @Override
    protected RSAMData getData(String code, double st, double et, double period) {
        return this.data.getRSAMData(code, st, et, period);
    }

    protected RSAMData getRatSAMData(String code, double st, double et, double period) {
        RSAMData result1 = null;
        RSAMData result2 = null;
        String[] codes = code.split(",");
        String code1 = this.channels.getChannelCode(Integer.valueOf(codes[0]));
        String code2 = this.channels.getChannelCode(Integer.valueOf(codes[1]));
        result1 = this.getData(code1, st, et, period);
        result2 = this.getData(code2, st, et, period);
        return result1.getRatSAM(result2);
    }
}

