/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db;

import gov.usgs.util.CodeTimer;
import gov.usgs.util.Util;
import gov.usgs.winston.db.WinstonDatabase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Merge {
    private static final double EPSILON = 1.0E-4;
    private WinstonDatabase source;
    private WinstonDatabase dest;
    private Logger logger;

    public Merge(String srcURL, String destURL) {
        String driver = "org.gjt.mm.mysql.Driver";
        this.logger = this.source.getLogger();
        this.source = new WinstonDatabase(driver, srcURL, null);
        this.logger.finer("Connected to source.");
        this.dest = new WinstonDatabase(driver, destURL, null);
        this.logger.finer("Connected to destination.");
    }

    public void flip() {
        WinstonDatabase temp = this.source;
        this.source = this.dest;
        this.dest = temp;
    }

    public void mergeHelicorders(String code, String date) {
        try {
            this.logger.finer("Begin merging helicorders.");
            HashSet<Integer> sourceTimes = new HashSet<Integer>();
            int total = 0;
            this.logger.finer("Getting source times.");
            this.source.useDatabase(code);
            ResultSet srs = this.source.getStatement().executeQuery("SELECT j2ksec FROM " + code + "$$H" + date);
            while (srs.next()) {
                ++total;
                sourceTimes.add((int)Math.round(srs.getDouble(1)));
            }
            this.logger.finer("Getting destination times.");
            this.dest.useDatabase(code);
            ResultSet drs = this.dest.getStatement().executeQuery("SELECT j2ksec FROM " + code + "$$H" + date);
            total = 0;
            while (drs.next()) {
                ++total;
                sourceTimes.remove(new Integer((int)Math.round(drs.getDouble(1))));
            }
            total = 0;
            double read = 0.0;
            double write = 0.0;
            this.logger.finer("Begin merging.");
            PreparedStatement insert = this.dest.getConnection().prepareStatement("INSERT IGNORE INTO " + code + "$$H" + date + " VALUES (?,?,?,?,?)");
            CodeTimer readTimer = new CodeTimer();
            Iterator it = sourceTimes.iterator();
            while (it.hasNext()) {
                int d = (Integer)it.next();
                srs = this.source.getStatement().executeQuery("SELECT j2ksec, smin, smax, rcnt, rsam FROM " + code + "$$H" + date + " WHERE j2ksec=" + d);
                if (!srs.next()) continue;
                insert.setDouble(1, srs.getDouble(1));
                insert.setInt(2, srs.getInt(2));
                insert.setInt(3, srs.getInt(3));
                insert.setInt(4, srs.getInt(4));
                insert.setDouble(5, srs.getDouble(5));
                CodeTimer writeTimer = new CodeTimer();
                insert.execute();
                writeTimer.stop();
                write += writeTimer.getRunTimeMillis();
                ++total;
            }
            readTimer.stop(false);
            read = readTimer.getRunTimeMillis() - write;
            this.logger.finer("Done merging, " + read + "ms reading, " + write + "ms writing.");
            this.logger.info("Merged " + total + " helicorder rows.");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not merge waves.", e);
        }
    }

    public void mergeWaves(String code, String date) {
        try {
            this.logger.finer("Begin merging waves.");
            HashSet<Double> sourceTimes = new HashSet<Double>();
            int total = 0;
            this.logger.finer("Getting source times.");
            this.source.useDatabase(code);
            ResultSet srs = this.source.getStatement().executeQuery("SELECT st FROM " + code + "$$" + date);
            while (srs.next()) {
                ++total;
                sourceTimes.add(Util.register(srs.getDouble(1), 1.0E-4));
            }
            this.logger.finer("Getting destination times.");
            this.dest.useDatabase(code);
            ResultSet drs = this.dest.getStatement().executeQuery("SELECT st FROM " + code + "$$" + date);
            total = 0;
            while (drs.next()) {
                ++total;
                sourceTimes.remove(new Double(Util.register(drs.getDouble(1), 1.0E-4)));
            }
            total = 0;
            this.logger.finer("Begin merging.");
            double read = 0.0;
            double write = 0.0;
            PreparedStatement insert = this.dest.getConnection().prepareStatement("INSERT IGNORE INTO " + code + "$$" + date + " VALUES (?,?,?,?,?)");
            CodeTimer readTimer = new CodeTimer();
            Iterator it = sourceTimes.iterator();
            while (it.hasNext()) {
                double d = (Double)it.next();
                srs = this.source.getStatement().executeQuery("SELECT st, et, sr, datatype, tracebuf FROM " + code + "$$" + date + " WHERE st>=" + (d - 1.0E-4) + " AND st<=" + (d + 1.0E-4));
                if (!srs.next()) continue;
                insert.setDouble(1, srs.getDouble(1));
                insert.setDouble(2, srs.getDouble(2));
                insert.setDouble(3, srs.getDouble(3));
                insert.setString(4, srs.getString(4));
                insert.setBlob(5, srs.getBlob(5));
                CodeTimer writeTimer = new CodeTimer();
                insert.execute();
                writeTimer.stop();
                write += writeTimer.getRunTimeMillis();
                ++total;
            }
            readTimer.stop(false);
            read = readTimer.getRunTimeMillis() - write;
            this.logger.finer("Done merging, " + read + "ms reading, " + write + "ms writing.");
            this.logger.info("Merged " + total + " wave rows.");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not merge waves.", e);
        }
    }

    public void fullMerge(String code, String date) {
        this.mergeWaves(code, date);
        this.mergeHelicorders(code, date);
        this.flip();
        this.mergeWaves(code, date);
        this.mergeHelicorders(code, date);
    }

    public void merge(String code, String date) {
        this.mergeWaves(code, date);
        this.mergeHelicorders(code, date);
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("usage: java gov.usgs.winston.db.Merge [srcURL] [destURL] [table] [date]");
            System.err.println("[table] is case sensitive; example: CRP_SHZ_AK");
            System.err.println("[date] is in YYYY_MM_DD form; example: 2005_03_27");
            System.exit(1);
        }
        Merge merge = new Merge(args[0], args[1]);
        merge.merge(args[2], args[3]);
    }
}

