/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.hypo;

import gov.usgs.util.Arguments;
import gov.usgs.util.ResourceReader;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.hypo.Hypocenter;
import gov.usgs.vdx.data.hypo.SQLHypocenterDataSource;
import gov.usgs.vdx.in.hypo.Importer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportUW
extends Importer {
    private SimpleDateFormat dateIn = new SimpleDateFormat("yyyyMMddHHmm");

    public ImportUW(SQLHypocenterDataSource ds) {
        super(ds);
        this.dateIn.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Override
    public List<Hypocenter> importResource(String resource) {
        String s;
        ResourceReader rr = ResourceReader.getResourceReader(resource);
        if (rr == null) {
            return null;
        }
        ArrayList<Hypocenter> hypos = new ArrayList<Hypocenter>();
        int lines = 0;
        while ((s = rr.nextLine()) != null) {
            try {
                ++lines;
                if (s.charAt(0) != 'A') {
                    throw new Exception("First character not 'A'.");
                }
                if (s.length() < 20) {
                    throw new Exception("Incomplete record.");
                }
                Date d = this.dateIn.parse(s.substring(2, 14));
                double j2ksec = Util.dateToJ2K(d);
                double ds = Double.parseDouble(s.substring(14, 20).trim());
                j2ksec += ds;
                double latdeg = Double.parseDouble(s.substring(21, 23).trim());
                char ns = s.charAt(23);
                double latmin = Double.parseDouble(s.substring(24, 29).trim()) / 100.0;
                double lat = latdeg + latmin / 60.0;
                if (ns == 'S') {
                    lat *= -1.0;
                }
                double londeg = Double.parseDouble(s.substring(29, 32).trim());
                char ew = s.charAt(32);
                double lonmin = Double.parseDouble(s.substring(33, 38).trim()) / 100.0;
                double lon = londeg + lonmin / 60.0;
                if (ew == 'W') {
                    lon *= -1.0;
                }
                double depth = -Double.parseDouble(s.substring(38, 43).trim());
                double mag = Double.parseDouble(s.substring(45, 48));
                Hypocenter hc = new Hypocenter(j2ksec, 0, lat, lon, depth, mag);
                hypos.add(hc);
            }
            catch (Exception e) {
                System.err.println("Line " + lines + ": " + e.getMessage());
            }
        }
        rr.close();
        return hypos;
    }

    public static void main(String[] as) {
        Arguments args = new Arguments(as, flags, keys);
        SQLHypocenterDataSource ds = Importer.getDataSource(args);
        ImportUW.process(args, new ImportUW(ds));
    }
}

