/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.hypo;

import gov.usgs.util.Arguments;
import gov.usgs.util.ResourceReader;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.hypo.Hypocenter;
import gov.usgs.vdx.data.hypo.SQLHypocenterDataSource;
import gov.usgs.vdx.in.hypo.Importer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportEarthworm
extends Importer {
    private SimpleDateFormat dateIn = new SimpleDateFormat("yyyyMMdd HHmm ss.SSS");
    private SimpleDateFormat dateOut;

    public ImportEarthworm(SQLHypocenterDataSource ds) {
        super(ds);
        this.dateIn.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.dateOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dateOut.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Override
    public List<Hypocenter> importResource(String resource) {
        String s;
        ResourceReader rr = ResourceReader.getResourceReader(resource);
        if (rr == null) {
            return null;
        }
        ArrayList<Hypocenter> hypos = new ArrayList<Hypocenter>();
        int lines = 0;
        while ((s = rr.nextLine()) != null) {
            try {
                ++lines;
                String ds = s.substring(0, 19).trim() + "0";
                Date date = this.dateIn.parse(ds);
                double j2ksec = Util.dateToJ2K(date);
                double latdeg = Double.parseDouble(s.substring(20, 22).trim());
                double latdec = Double.parseDouble(s.substring(23, 28).trim());
                double lat = latdeg + latdec / 60.0;
                double londeg = Double.parseDouble(s.substring(29, 32).trim());
                double londec = Double.parseDouble(s.substring(33, 38).trim());
                double lon = londeg + londec / 60.0;
                double depth = Double.parseDouble(s.substring(39, 45).trim());
                double mag = Double.parseDouble(s.substring(47, 52).trim());
                System.out.println("EW: " + j2ksec + " " + this.dateOut.format(date) + " " + (lon *= -1.0) + " " + lat + " " + (depth *= -1.0) + " " + mag);
                Hypocenter ew = new Hypocenter(j2ksec, 0, lat, lon, depth, mag);
                hypos.add(ew);
            }
            catch (Exception e) {
                System.err.println("Line " + lines + ": " + e.getMessage());
            }
        }
        rr.close();
        return hypos;
    }

    public static void main(String[] as) {
        Arguments args = new Arguments(as, flags, keys);
        SQLHypocenterDataSource ds = Importer.getDataSource(args);
        ImportEarthworm.process(args, new ImportEarthworm(ds));
    }
}

