/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in;

import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.FileCopy;
import gov.usgs.util.Util;
import gov.usgs.vdx.in.Importer;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Scheduler {
    public static Set<String> flags = new HashSet<String>();
    public static Set<String> keys = new HashSet<String>();
    public static Logger logger;
    public static ConfigFile params;
    public static ConfigFile schedulerParams;
    public static Class importClass;
    public static File dataDir;
    public static File configFile;
    public static File archiveDir;
    public static String configDirectoryName;
    public static String dataDirectoryName;
    public static String archiveDirectoryName;
    public static String importerName;
    public static String dataDirName;
    public static String configFileName;
    public static String archiveDirName;
    public static String fileSuffix;
    public static String filePrefix;
    public static int cycle;
    public static boolean archive;
    public static boolean delete;
    public static boolean verbose;
    public CurrentTime currentTime = CurrentTime.getInstance();

    public void initialize(String importerClass, String schedulerConfigFile, String schedulerName) {
        logger = Logger.getLogger(importerClass);
        logger.log(Level.INFO, "Scheduler.initialize() succeeded.");
        this.processConfigFile(schedulerConfigFile, schedulerName);
        logger.log(Level.INFO, "importer:   " + importerName);
        logger.log(Level.INFO, "cycle:      " + cycle);
        logger.log(Level.INFO, "fileprefix: " + filePrefix);
        logger.log(Level.INFO, "filesuffix: " + fileSuffix);
        logger.log(Level.INFO, "delete:     " + delete);
        logger.log(Level.INFO, "verbose:    " + verbose);
        logger.log(Level.INFO, "archive:    " + archive);
        logger.log(Level.INFO, "datadir:    " + dataDir.getAbsolutePath());
        logger.log(Level.INFO, "configfile: " + configFile.getAbsolutePath());
        if (archive) {
            logger.log(Level.INFO, "archivedir: " + archiveDir.getAbsolutePath());
        }
        Scheduler scheduler = new Scheduler();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)scheduler.new SchedulerTimerTask(), 0L, (long)(cycle * 1000));
    }

    public void processConfigFile(String schedulerConfigFile, String schedulerName) {
        params = new ConfigFile(schedulerConfigFile);
        if (!params.wasSuccessfullyRead()) {
            logger.log(Level.SEVERE, schedulerConfigFile + " was not successfully read");
            System.exit(-1);
        }
        configDirectoryName = params.getString("configDirectory");
        dataDirectoryName = params.getString("dataDirectory");
        archiveDirectoryName = params.getString("archiveDirectory");
        schedulerParams = params.getSubConfig(schedulerName);
        importerName = schedulerParams.getString("importer");
        dataDirName = schedulerParams.getString("dataDir");
        configFileName = schedulerParams.getString("configFile");
        archiveDirName = schedulerParams.getString("archiveDir");
        filePrefix = Util.stringToString(schedulerParams.getString("filePrefix"), "");
        fileSuffix = Util.stringToString(schedulerParams.getString("fileSuffix"), "");
        cycle = Util.stringToInt(schedulerParams.getString("cycle"), 3600);
        archive = Util.stringToBoolean(schedulerParams.getString("archive"), false);
        delete = Util.stringToBoolean(schedulerParams.getString("delete"), false);
        verbose = Util.stringToBoolean(schedulerParams.getString("verbose"), true);
        if (importerName == null) {
            logger.log(Level.SEVERE, "importer parameter empty");
            System.exit(-1);
        } else {
            try {
                importClass = Class.forName(importerName);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.SEVERE, "importer not found");
                System.exit(-1);
            }
        }
        if (dataDirName == null) {
            logger.log(Level.SEVERE, "dataDir parameter empty");
            System.exit(-1);
        } else if (dataDirName.indexOf("DATA_DIR") > -1) {
            if (dataDirectoryName != null) {
                dataDirName = dataDirName.replaceAll("DATA_DIR", dataDirectoryName);
            } else {
                logger.log(Level.SEVERE, "dataDirectory parameter empty");
                System.exit(-1);
            }
        }
        if (configFileName == null) {
            logger.log(Level.SEVERE, "configFile parameter empty");
            System.exit(-1);
        } else if (configFileName.indexOf("CONFIG_DIR") > -1) {
            if (configDirectoryName != null) {
                configFileName = configFileName.replaceAll("CONFIG_DIR", configDirectoryName);
            } else {
                logger.log(Level.SEVERE, "configDirectory parameter empty");
                System.exit(-1);
            }
        }
        if (archive) {
            if (archiveDirName == null) {
                logger.log(Level.SEVERE, "archiveDir parameter empty");
                System.exit(-1);
            } else if (archiveDirName.indexOf("ARCHIVE_DIR") > -1) {
                if (archiveDirectoryName != null) {
                    archiveDirName = archiveDirName.replaceAll("ARCHIVE_DIR", archiveDirectoryName);
                } else {
                    logger.log(Level.SEVERE, "archiveDirectory parameter empty");
                    System.exit(-1);
                }
            }
        }
        dataDir = new File(dataDirName);
        configFile = new File(configFileName);
        if (archive) {
            archiveDir = new File(archiveDirName);
        }
        if (!dataDir.isDirectory()) {
            logger.log(Level.SEVERE, dataDirName + " does not exist");
            System.exit(-1);
        } else if (!dataDir.canRead()) {
            logger.log(Level.SEVERE, dataDirName + " is not readable");
            System.exit(-1);
        }
        if (!configFile.exists()) {
            logger.log(Level.SEVERE, configFileName + " does not exist");
            System.exit(-1);
        } else if (!configFile.canRead()) {
            logger.log(Level.SEVERE, configFileName + " is not readable");
            System.exit(-1);
        }
        if (archive) {
            if (!archiveDir.isDirectory()) {
                logger.log(Level.SEVERE, archiveDirName + " does not exist");
                System.exit(-1);
            } else if (!archiveDir.canRead()) {
                logger.log(Level.SEVERE, archiveDirName + " is not readable");
                System.exit(-1);
            } else if (!archiveDir.canWrite()) {
                logger.log(Level.SEVERE, archiveDirName + " is not writable");
                System.exit(-1);
            }
        }
    }

    public void outputInstructions(String className, String message) {
        if (message == null) {
            System.err.println(message);
        }
        System.err.println(className + " -c configfile -n schedulername");
    }

    public static void main(String[] as) {
        Scheduler scheduler = new Scheduler();
        Arguments args = new Arguments(as, flags, keys);
        if (args.flagged("-h")) {
            scheduler.outputInstructions(scheduler.getClass().getName(), null);
            System.exit(-1);
        }
        if (!args.contains("-c")) {
            scheduler.outputInstructions(scheduler.getClass().getName(), "config file required");
            System.exit(-1);
        }
        if (!args.contains("-n")) {
            scheduler.outputInstructions(scheduler.getClass().getName(), "scheduler name required");
            System.exit(-1);
        }
        scheduler.initialize(scheduler.getClass().getName(), args.get("-c"), args.get("-n"));
    }

    static {
        keys.add("-c");
        keys.add("-n");
        flags.add("-h");
        flags.add("-v");
    }

    private static class FileComparator
    implements Comparator {
        private Collator c = Collator.getInstance();

        private FileComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            File f1 = (File)o1;
            File f2 = (File)o2;
            if (f1.isDirectory() && f2.isFile()) {
                return -1;
            }
            if (f1.isFile() && f2.isDirectory()) {
                return 1;
            }
            return this.c.compare(f1.getName(), f2.getName());
        }
    }

    class SchedulerTimerTask
    extends TimerTask {
        private ImportFileFilter importFileFilter;
        private File[] selectedFiles;
        private File archiveFile;
        private Importer importer;

        public SchedulerTimerTask() {
            this.importFileFilter = new ImportFileFilter();
        }

        public void run() {
            this.selectedFiles = dataDir.listFiles(this.importFileFilter);
            Arrays.sort(this.selectedFiles, new FileComparator());
            logger.log(Level.INFO, "");
            logger.log(Level.INFO, Scheduler.this.currentTime.nowString() + " begin polling cycle");
            logger.log(Level.INFO, "files:" + this.selectedFiles.length);
            if (this.selectedFiles.length > 0) {
                try {
                    importClass = Class.forName(importerName);
                }
                catch (ClassNotFoundException e) {
                    logger.log(Level.SEVERE, "importer not found");
                    System.exit(-1);
                }
                try {
                    this.importer = (Importer)importClass.newInstance();
                }
                catch (InstantiationException e) {
                    logger.log(Level.SEVERE, importerName + " InstantiationException");
                    System.exit(-1);
                }
                catch (IllegalAccessException e) {
                    logger.log(Level.SEVERE, importerName + " IllegalAccessException");
                    System.exit(-1);
                }
                this.importer.initialize(importerName, configFileName, verbose);
                for (File file : this.selectedFiles) {
                    this.importer.process(file.getAbsolutePath());
                    if (archive) {
                        logger.log(Level.INFO, "archiving " + file.getAbsolutePath() + " to " + archiveDir.getAbsolutePath());
                        this.archiveFile = new File(archiveDir, file.getName());
                        try {
                            FileCopy.fileCopy(file, this.archiveFile);
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "error copying file to archive directory");
                        }
                    }
                    if (!delete) continue;
                    logger.log(Level.INFO, "deleting " + file.getAbsolutePath());
                    if (file.delete()) continue;
                    logger.log(Level.SEVERE, "error deleting " + file.getName());
                }
                this.importer.deinitialize();
            }
            logger.log(Level.INFO, Scheduler.this.currentTime.nowString() + " end polling cycle");
        }
    }

    class ImportFileFilter
    implements FileFilter {
        public boolean accept(File file) {
            boolean prefixMatches = file.getName().startsWith(filePrefix);
            boolean suffixMatches = file.getName().endsWith(fileSuffix);
            return prefixMatches && suffixMatches;
        }
    }
}

