/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in;

import java.util.Calendar;
import java.util.Date;

public abstract class Poller
extends Thread {
    public static final int ONE_DAY = 86400000;
    protected long interval;
    protected long nextInterval;
    protected boolean stopped = true;
    private boolean killThread = false;

    public Poller() {
        this.setName("Poller");
        this.start();
    }

    public abstract void process(String var1);

    public void kill() {
        this.killThread = true;
        this.interrupt();
    }

    public void stopPolling() {
        this.stopped = true;
        this.interrupt();
    }

    public void startPolling() {
        this.stopped = false;
    }

    public void run() {
        do {
            if (!this.stopped) {
                try {
                    Thread.sleep(this.nextInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                this.nextInterval = this.interval;
                if (this.stopped || this.killThread) continue;
                this.process("");
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.killThread);
    }

    public void setNextAsTime(int hr, int min, int sec, int ms) {
        Calendar cal = Calendar.getInstance();
        Date now = new Date();
        cal.setTime(now);
        cal.set(11, hr);
        cal.set(12, min);
        cal.set(13, sec);
        cal.set(14, ms);
        if (cal.getTime().getTime() <= now.getTime()) {
            cal.add(6, 1);
        }
        this.nextInterval = cal.getTime().getTime() - now.getTime();
    }
}

