/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.GenericDataMatrix;
import gov.usgs.vdx.data.Rank;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.SQLDataSourceDescriptor;
import gov.usgs.vdx.data.SQLDataSourceHandler;
import gov.usgs.vdx.in.CCSAILMessage;
import gov.usgs.vdx.in.ColumnValue;
import gov.usgs.vdx.in.ConnectionSettings;
import gov.usgs.vdx.in.FreewaveIPConnection;
import gov.usgs.vdx.in.Importer;
import gov.usgs.vdx.in.Poller;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportPoll
extends Poller
implements Importer {
    public static Set<String> flags = new HashSet<String>();
    public static Set<String> keys = new HashSet<String>();
    public String vdxConfig;
    public ConfigFile params;
    public ConfigFile vdxParams;
    public ConfigFile rankParams;
    public ConfigFile columnParams;
    public ConfigFile channelParams;
    public ConfigFile dataSourceParams;
    public ConfigFile translationParams;
    public String driver;
    public String prefix;
    public String url;
    public SimpleDateFormat dateIn;
    public SimpleDateFormat dateOut;
    public Date date;
    public Double j2ksec;
    public String filenameMask;
    public int headerLines;
    public String timestampMask;
    public String timeZone;
    public String importColumns;
    public String[] importColumnArray;
    public Map<Integer, String> importColumnMap;
    public String dataSource;
    public SQLDataSource sqlDataSource;
    public SQLDataSourceHandler sqlDataSourceHandler;
    public SQLDataSourceDescriptor sqlDataSourceDescriptor;
    public List<String> dataSourceList;
    public Map<String, SQLDataSource> sqlDataSourceMap;
    public Map<String, String> dataSourceColumnMap;
    public Map<String, String> dataSourceChannelMap;
    public Map<String, Integer> dataSourceRankMap;
    public Rank rank;
    public String rankName;
    public int rankValue;
    public int rankDefault;
    public int rid;
    public Channel channel;
    public String channelCode;
    public String channelName;
    public double channelLon;
    public double channelLat;
    public double channelHeight;
    public List<String> channelList;
    public Map<String, Channel> channelMap;
    public String channels;
    public String[] channelArray;
    public String[] dsChannelArray;
    public String defaultChannels;
    public String channelCols;
    public Map<String, String> channelColumnMap;
    public Column column;
    public String columnName;
    public String columnDescription;
    public String columnUnit;
    public int columnIdx;
    public boolean columnActive;
    public boolean columnChecked;
    public List<String> columnList;
    public HashMap<String, Column> columnMap;
    public Map<String, Column> dbColumnMap;
    public String columns;
    public String[] columnArray;
    public String defaultColumns;
    public String deviceIP;
    public int devicePort;
    public int postConnectDelay;
    public int betweenPollDelay;
    public int callNumber;
    public int repeater;
    public int dataLines;
    public int connTimeout;
    public int dataTimeout;
    public int maxRetries;
    public String timeSource;
    public String instrument;
    public String delimiter;
    public int tiltid;
    public Map<String, ConnectionSettings> settingMap;
    public ConnectionSettings settings;
    public FreewaveIPConnection connection;
    public double azimuthNom;
    public double azimuthInst;
    public String importerType;
    public Logger logger;
    public CurrentTime currentTime = CurrentTime.getInstance();
    public String timeDataSource = null;

    public void initialize(String importerClass, String configFile, boolean verbose) {
        this.logger = Logger.getLogger(importerClass);
        this.logger.log(Level.INFO, "ImportPoll.initialize() succeeded.");
        this.processConfigFile(configFile);
    }

    public void deinitialize() {
        this.sqlDataSource.disconnect();
    }

    public ImportPoll() {
        this.nextInterval = 0L;
    }

    public void processConfigFile(String configFile) {
        int i;
        this.logger.log(Level.INFO, "Reading config file " + configFile);
        this.params = new ConfigFile(configFile);
        if (!this.params.wasSuccessfullyRead()) {
            this.logger.log(Level.SEVERE, "%s was not successfully read", configFile);
            System.exit(-1);
        }
        this.vdxConfig = Util.stringToString(this.params.getString("vdx.config"), "VDX.config");
        if (this.vdxConfig == null) {
            this.logger.log(Level.SEVERE, "vdx.config parameter missing from config file");
            System.exit(-1);
        }
        this.vdxParams = new ConfigFile(this.vdxConfig);
        this.driver = this.vdxParams.getString("vdx.driver");
        this.url = this.vdxParams.getString("vdx.url");
        this.prefix = this.vdxParams.getString("vdx.prefix");
        this.timestampMask = Util.stringToString(this.params.getString("timestampMask"), "yyyy-MM-dd HH:mm:ss");
        this.timeZone = Util.stringToString(this.params.getString("timezone"), "GMT");
        this.dateIn = new SimpleDateFormat(this.timestampMask);
        this.dateOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dateIn.setTimeZone(TimeZone.getTimeZone(this.timeZone));
        this.dateOut.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.rankParams = this.params.getSubConfig("rank");
        this.rankName = Util.stringToString(this.rankParams.getString("name"), "DEFAULT");
        this.rankValue = Util.stringToInt(this.rankParams.getString("value"), 1);
        this.rankDefault = Util.stringToInt(this.rankParams.getString("default"), 0);
        this.rank = new Rank(0, this.rankName, this.rankValue, this.rankDefault);
        this.deviceIP = this.params.getString("deviceIP");
        this.devicePort = Util.stringToInt(this.params.getString("devicePort"));
        this.postConnectDelay = Util.stringToInt(this.params.getString("postConnectDelay"), 5000);
        this.betweenPollDelay = Util.stringToInt(this.params.getString("betweenPollDelay"), 5000);
        this.columnList = this.params.getList("column");
        if (this.columnList != null) {
            this.dbColumnMap = new HashMap<String, Column>();
            for (i = 0; i < this.columnList.size(); ++i) {
                this.columnName = this.columnList.get(i);
                this.columnParams = this.params.getSubConfig(this.columnName);
                this.columnIdx = Util.stringToInt(this.columnParams.getString("idx"), i);
                this.columnDescription = Util.stringToString(this.columnParams.getString("description"), this.columnName);
                this.columnUnit = Util.stringToString(this.columnParams.getString("unit"), this.columnName);
                this.columnChecked = Util.stringToBoolean(this.columnParams.getString("checked"), false);
                this.columnActive = Util.stringToBoolean(this.columnParams.getString("active"), true);
                this.column = new Column(this.columnIdx, this.columnName, this.columnDescription, this.columnUnit, this.columnChecked, this.columnActive);
                this.dbColumnMap.put(this.columnName, this.column);
            }
        }
        this.importColumns = this.params.getString("importColumns");
        if (this.importColumns == null) {
            this.logger.log(Level.SEVERE, "importColumns parameter missing from config file");
            System.exit(-1);
        }
        this.defaultColumns = "";
        this.importColumnArray = this.importColumns.split(",");
        for (i = 0; i < this.importColumnArray.length; ++i) {
            this.columnName = this.importColumnArray[i].trim();
            if (this.columnName.equals("IGNORE") || this.columnName.equals("CHANNEL") || this.columnName.equals("TIMESTAMP")) continue;
            this.defaultColumns = this.defaultColumns + this.columnName + ",";
        }
        this.defaultColumns = this.defaultColumns.substring(0, this.defaultColumns.length() - 1);
        if (this.defaultColumns.length() == 0) {
            this.logger.log(Level.SEVERE, "importColumns parameter does not contain any data columns");
            System.exit(-1);
        }
        this.defaultChannels = "";
        this.channelList = this.params.getList("channel");
        if (this.channelList != null) {
            this.channelMap = new HashMap<String, Channel>();
            this.settingMap = new HashMap<String, ConnectionSettings>();
            this.channelColumnMap = new HashMap<String, String>();
            for (i = 0; i < this.channelList.size(); ++i) {
                this.channelCode = this.channelList.get(i);
                this.defaultChannels = this.defaultChannels + this.channelCode + ",";
                this.channelParams = this.params.getSubConfig(this.channelCode);
                this.channelName = Util.stringToString(this.channelParams.getString("name"), this.channelCode);
                this.channelLon = Util.stringToDouble(this.channelParams.getString("longitude"), Double.NaN);
                this.channelLat = Util.stringToDouble(this.channelParams.getString("latitude"), Double.NaN);
                this.channelHeight = Util.stringToDouble(this.channelParams.getString("height"), Double.NaN);
                this.channel = new Channel(0, this.channelCode, this.channelName, this.channelLon, this.channelLat, this.channelHeight);
                this.channelMap.put(this.channelCode, this.channel);
                this.channelCols = this.channelParams.getString("columns");
                if (this.channelCols == null) {
                    this.channelCols = this.importColumns;
                }
                this.channelColumnMap.put(this.channelCode, this.channelCols);
                this.callNumber = Util.stringToInt(this.channelParams.getString("callNumber"));
                this.repeater = Util.stringToInt(this.channelParams.getString("repeater"), 0);
                this.dataLines = Util.stringToInt(this.channelParams.getString("dataLines"), 50);
                this.connTimeout = Util.stringToInt(this.channelParams.getString("connTimeout"), 50000);
                this.dataTimeout = Util.stringToInt(this.channelParams.getString("dataTimeout"), 50000);
                this.maxRetries = Util.stringToInt(this.channelParams.getString("maxRetries"), 2);
                this.timeSource = Util.stringToString(this.channelParams.getString("timeSource"), "tilt");
                this.instrument = Util.stringToString(this.channelParams.getString("instrument"), "zeno");
                this.delimiter = Util.stringToString(this.channelParams.getString("delimiter"), ",");
                this.tiltid = Util.stringToInt(this.channelParams.getString("tiltid"), 0);
                this.settings = new ConnectionSettings(this.callNumber, this.repeater, this.dataLines, this.connTimeout, this.dataTimeout, this.maxRetries, this.timeSource, this.instrument, this.delimiter, this.tiltid);
                this.settingMap.put(this.channelCode, this.settings);
            }
            this.defaultChannels = this.defaultChannels.substring(0, this.defaultChannels.length() - 1);
        }
        this.dataSourceList = this.params.getList("dataSource");
        if (this.dataSourceList == null) {
            this.logger.log(Level.SEVERE, "dataSource parameter(s) missing from config file");
            System.exit(-1);
        }
        this.sqlDataSourceHandler = new SQLDataSourceHandler(this.driver, this.url, this.prefix);
        this.sqlDataSourceMap = new HashMap<String, SQLDataSource>();
        this.dataSourceChannelMap = new HashMap<String, String>();
        this.dataSourceColumnMap = new HashMap<String, String>();
        this.dataSourceRankMap = new HashMap<String, Integer>();
        for (i = 0; i < this.dataSourceList.size(); ++i) {
            this.dataSource = this.dataSourceList.get(i);
            this.dataSourceParams = this.params.getSubConfig(this.dataSource);
            String timesource = this.dataSourceParams.getString("timesource");
            if (timesource != null && timesource.equals("true")) {
                this.timeDataSource = this.dataSource;
            }
            this.columns = this.dataSourceParams.getString("columns");
            if (this.columns == null) {
                this.logger.log(Level.WARNING, this.dataSource + " columns not defined. all available columns will be imported");
                this.columns = this.defaultColumns;
            }
            this.dataSourceColumnMap.put(this.dataSource, this.columns);
            this.channels = this.dataSourceParams.getString("channels");
            if (this.channels == null) {
                this.logger.log(Level.WARNING, this.dataSource + " channels not defined.  all available channels will be imported");
                this.channels = this.defaultChannels;
            }
            this.dataSourceChannelMap.put(this.dataSource, this.channels);
            this.sqlDataSourceDescriptor = this.sqlDataSourceHandler.getDataSourceDescriptor(this.dataSource);
            if (this.sqlDataSourceDescriptor == null) {
                this.logger.log(Level.SEVERE, this.dataSource + " sql data source does not exist in vdxSources.config");
                continue;
            }
            this.sqlDataSource = this.sqlDataSourceDescriptor.getSQLDataSource();
            this.sqlDataSourceMap.put(this.dataSource, this.sqlDataSource);
            if (this.sqlDataSource.getRanksFlag()) {
                Rank tempRank = this.sqlDataSource.defaultGetRank(this.rank);
                if (tempRank == null) {
                    tempRank = this.sqlDataSource.defaultInsertRank(this.rank);
                }
                if (tempRank == null) {
                    this.logger.log(Level.SEVERE, "invalid rank for dataSource " + this.dataSource);
                    System.exit(-1);
                }
                this.dataSourceRankMap.put(this.dataSource, tempRank.getId());
            }
            if (this.sqlDataSource.getColumnsFlag()) {
                this.columnArray = this.columns.split(",");
                for (int j = 0; j < this.columnArray.length; ++j) {
                    this.columnName = this.columnArray[j];
                    if (this.sqlDataSource.defaultGetColumn(this.columnName) != null) continue;
                    this.column = this.dbColumnMap.get(this.columnName);
                    if (this.column == null) {
                        this.column = new Column(1, this.columnName, this.columnName, this.columnName, false);
                    }
                    this.sqlDataSource.defaultInsertColumn(this.column);
                }
            }
            if (this.sqlDataSource.getTranslationsFlag()) {
                this.sqlDataSource.defaultCreateTranslation();
            }
            if (!this.sqlDataSource.getChannelsFlag() || this.channels.length() <= 0) continue;
            this.channelArray = this.channels.split(",");
            for (int j = 0; j < this.channelArray.length; ++j) {
                this.channelCode = this.channelArray[j];
                this.channel = this.channelMap.get(this.channelCode);
                this.channelParams = this.params.getSubConfig(this.channelCode);
                if (this.sqlDataSource.defaultGetChannel(this.channel.getCode(), this.sqlDataSource.getChannelTypesFlag()) == null) {
                    if (this.sqlDataSource.getType().equals("tilt")) {
                        this.azimuthNom = Util.stringToDouble(this.channelParams.getString("azimuth"), 0.0);
                        this.sqlDataSource.defaultCreateTiltChannel(this.channel, 1, this.azimuthNom, this.sqlDataSource.getChannelsFlag(), this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), this.sqlDataSource.getColumnsFlag());
                    } else {
                        this.sqlDataSource.defaultCreateChannel(this.channel, 1, this.sqlDataSource.getChannelsFlag(), this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), this.sqlDataSource.getColumnsFlag());
                    }
                    this.channel = this.sqlDataSource.defaultGetChannel(this.channel.getCode(), this.sqlDataSource.getChannelTypesFlag());
                    this.channelMap.put(this.channelArray[i], this.channel);
                }
                if (!this.sqlDataSource.getTranslationsFlag()) continue;
                int tid = 1;
                int extraColumn = 0;
                this.translationParams = this.channelParams.getSubConfig("translation");
                List<Column> columnList = this.sqlDataSource.defaultGetColumns(true, false);
                if (this.sqlDataSource.getType().equals("tilt")) {
                    extraColumn = 1;
                }
                DoubleMatrix2D dm = DoubleFactory2D.dense.make(1, columnList.size() * 2 + extraColumn);
                String[] columnNames = new String[columnList.size() * 2 + extraColumn];
                if (this.sqlDataSource.getType().equals("tilt")) {
                    this.azimuthInst = Util.stringToDouble(this.translationParams.getString("azimuth"), 0.0);
                    dm.setQuick(0, columnList.size() * 2, this.azimuthInst);
                    columnNames[columnList.size() * 2] = "azimuth";
                }
                for (int k = 0; k < columnList.size(); ++k) {
                    this.column = columnList.get(k);
                    this.columnName = this.column.name;
                    double multiplier = Util.stringToDouble(this.translationParams.getString("c" + this.columnName), 1.0);
                    double offset = Util.stringToDouble(this.translationParams.getString("d" + this.columnName), 0.0);
                    dm.setQuick(0, k * 2, multiplier);
                    dm.setQuick(0, k * 2 + 1, offset);
                    columnNames[k * 2] = "c" + this.columnName;
                    columnNames[k * 2 + 1] = "d" + this.columnName;
                }
                GenericDataMatrix gdm = new GenericDataMatrix(dm);
                gdm.setColumnNames(columnNames);
                tid = this.sqlDataSource.defaultGetTranslation(this.channel.getCode(), gdm);
                if (tid == 1) {
                    tid = this.sqlDataSource.defaultInsertTranslation(this.channel.getCode(), gdm);
                }
                if (tid == this.sqlDataSource.defaultGetChannelTranslationID(this.channel.getCode())) continue;
                this.sqlDataSource.defaultUpdateChannelTranslationID(this.channel.getCode(), tid);
            }
        }
        if (this.timeDataSource == null) {
            this.logger.log(Level.SEVERE, "dataSource time source not specified");
            System.exit(-1);
        }
        this.logger.log(Level.INFO, "");
        this.logger.log(Level.INFO, "###### CONNECTION SETTINGS ######");
        this.logger.log(Level.INFO, "###### MASTER ######");
        this.logger.log(Level.INFO, this.outputConnectionHeader());
        this.logger.log(Level.INFO, this.outputConnectionInfo());
        this.channelArray = this.defaultChannels.split(",");
        for (int c = 0; c < this.channelArray.length; ++c) {
            this.channel = this.channelMap.get(this.channelArray[c]);
            this.settings = this.settingMap.get(this.channelArray[c]);
            this.logger.log(Level.INFO, "###### " + this.channel.getCode() + " ######");
            this.logger.log(Level.INFO, this.settings.headerString());
            this.logger.log(Level.INFO, this.settings.toString());
        }
        this.logger.log(Level.INFO, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String filename) {
        try {
            this.logger.log(Level.INFO, "");
            this.logger.log(Level.INFO, "BEGIN POLLING CYCLE");
            this.channelArray = this.defaultChannels.split(",");
            for (int c = 0; c < this.channelArray.length; ++c) {
                this.channel = this.channelMap.get(this.channelArray[c]);
                this.channelCode = this.channel.getCode();
                this.settings = this.settingMap.get(this.channelCode);
                this.channelCols = this.channelColumnMap.get(this.channelCode);
                this.importColumnArray = this.channelCols.split(",");
                this.importColumnMap = new HashMap<Integer, String>();
                for (int i = 0; i < this.importColumnArray.length; ++i) {
                    this.importColumnMap.put(i, this.importColumnArray[i].trim());
                }
                this.sqlDataSource = this.sqlDataSourceMap.get(this.timeDataSource);
                Date lastDataTime = this.sqlDataSource.defaultGetLastDataTime(this.channelCode);
                if (lastDataTime == null) {
                    lastDataTime = new Date(0L);
                }
                this.logger.log(Level.INFO, "");
                this.logger.log(Level.INFO, "Begin Polling [" + this.channelCode + "] (lastDataTime: " + this.dateOut.format(lastDataTime) + ")");
                boolean done = false;
                for (int tries = 1; tries < this.settings.maxRetries + 1 && !done; ++tries) {
                    String line = "";
                    int lineNumber = 1;
                    try {
                        if (this.connection == null) {
                            this.connection = new FreewaveIPConnection(this.deviceIP, this.devicePort, this.settings.dataTimeout);
                        }
                        this.connection.connect(this.settings.repeater, this.settings.callNumber, this.settings.connTimeout);
                        Thread.sleep(this.postConnectDelay);
                        CCSAILMessage ccMsg = new CCSAILMessage(this.settings.tiltid);
                        String dataRequest = ccMsg.makeDA(lastDataTime, this.settings.dataLines);
                        this.connection.writeString(dataRequest);
                        String reply = this.connection.getMsg(this.settings.dataTimeout);
                        String replyString = ccMsg.getMsg(reply, true);
                        StringTokenizer st = new StringTokenizer(replyString, "\n");
                        while (st.hasMoreTokens()) {
                            ColumnValue columnValue;
                            double value;
                            String name;
                            line = st.nextToken();
                            if (line.startsWith("EOF") || line.startsWith("#") || line.length() <= 1) continue;
                            String[] valueArray = line.split(this.settings.delimiter, -1);
                            HashMap<Integer, String> valueMap = new HashMap<Integer, String>();
                            for (int i = 0; i < valueArray.length; ++i) {
                                valueMap.put(i, valueArray[i].trim());
                            }
                            if (this.importColumnMap.size() > valueMap.size()) {
                                this.logger.log(Level.SEVERE, "Skipping line " + lineNumber + " (too few values)");
                                ++lineNumber;
                                continue;
                            }
                            HashMap<Integer, ColumnValue> columnValueMap = new HashMap<Integer, ColumnValue>();
                            int count = 0;
                            String tsValue = "";
                            for (int i = 0; i < this.importColumnMap.size(); ++i) {
                                name = this.importColumnMap.get(i);
                                if (name.equals("IGNORE")) continue;
                                if (name.equals("CHANNEL")) {
                                    this.channelCode = (String)valueMap.get(i);
                                    continue;
                                }
                                if (name.equals("TIMESTAMP")) {
                                    tsValue = tsValue + (String)valueMap.get(i) + " ";
                                    continue;
                                }
                                value = ((String)valueMap.get(i)).length() == 0 ? Double.NaN : Double.parseDouble((String)valueMap.get(i));
                                columnValue = new ColumnValue(name, value);
                                columnValueMap.put(count, columnValue);
                                ++count;
                            }
                            if (tsValue.length() == 0) {
                                this.logger.log(Level.SEVERE, "Skipping line " + lineNumber + " (timestamp not found)");
                                continue;
                            }
                            try {
                                String timestamp = tsValue.trim();
                                this.date = this.dateIn.parse(timestamp);
                                this.j2ksec = Util.dateToJ2K(this.date);
                            }
                            catch (ParseException e) {
                                this.logger.log(Level.SEVERE, "Skipping line " + lineNumber + " (timestamp parse error)");
                                continue;
                            }
                            ColumnValue tsColumn = new ColumnValue("j2ksec", this.j2ksec);
                            for (int i = 0; i < this.dataSourceList.size(); ++i) {
                                double j2ksec;
                                DoubleMatrix2D temp;
                                this.dataSource = this.dataSourceList.get(i);
                                this.sqlDataSource = this.sqlDataSourceMap.get(this.dataSource);
                                if (this.sqlDataSource == null) {
                                    this.logger.log(Level.SEVERE, "Skipping dataSource " + this.dataSource + " for line " + lineNumber);
                                    continue;
                                }
                                boolean channelMemberOfDataSource = false;
                                this.channels = this.dataSourceChannelMap.get(this.dataSource);
                                if (this.channels.length() > 0) {
                                    this.dsChannelArray = this.channels.split(",");
                                    for (int j = 0; j < this.dsChannelArray.length; ++j) {
                                        if (!this.channelCode.equals(this.dsChannelArray[j])) continue;
                                        channelMemberOfDataSource = true;
                                    }
                                    if (!channelMemberOfDataSource) continue;
                                }
                                if (this.sqlDataSource.getChannelsFlag() && this.sqlDataSource.defaultGetChannel(this.channelCode, this.sqlDataSource.getChannelTypesFlag()) == null) {
                                    this.sqlDataSource.defaultCreateChannel(new Channel(0, this.channelCode, null, Double.NaN, Double.NaN, Double.NaN), 1, this.sqlDataSource.getChannelsFlag(), this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), this.sqlDataSource.getColumnsFlag());
                                }
                                this.columns = this.dataSourceColumnMap.get(this.dataSource);
                                this.columnArray = this.columns.split(",");
                                HashMap<Integer, String> dsColumnMap = new HashMap<Integer, String>();
                                for (int j = 0; j < this.columnArray.length; ++j) {
                                    dsColumnMap.put(j, this.columnArray[j]);
                                }
                                this.rid = this.sqlDataSource.getRanksFlag() ? this.dataSourceRankMap.get(this.dataSource) : 1;
                                HashMap<Integer, ColumnValue> dataSourceEntryMap = new HashMap<Integer, ColumnValue>();
                                count = 0;
                                dataSourceEntryMap.put(count, tsColumn);
                                ++count;
                                for (int j = 0; j < columnValueMap.size(); ++j) {
                                    columnValue = (ColumnValue)columnValueMap.get(j);
                                    name = columnValue.columnName;
                                    value = columnValue.columnValue;
                                    for (int k = 0; k < dsColumnMap.size(); ++k) {
                                        if (!name.equals(dsColumnMap.get(k))) continue;
                                        dataSourceEntryMap.put(count, columnValue);
                                        ++count;
                                    }
                                }
                                DoubleMatrix2D dm = DoubleFactory2D.dense.make(1, dataSourceEntryMap.size());
                                String[] columnNames = new String[dataSourceEntryMap.size()];
                                for (int j = 0; j < dataSourceEntryMap.size(); ++j) {
                                    columnValue = (ColumnValue)dataSourceEntryMap.get(j);
                                    name = columnValue.columnName;
                                    value = columnValue.columnValue;
                                    columnNames[j] = name;
                                    dm.setQuick(0, j, value);
                                }
                                GenericDataMatrix gdm = new GenericDataMatrix(dm);
                                gdm.setColumnNames(columnNames);
                                this.sqlDataSource.defaultInsertData(this.channelCode, gdm, this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), this.rid);
                                if (this.dataSource.equals("hvo_deformation_tilt") && this.sqlDataSource.getType().equals("tilt")) {
                                    temp = gdm.getColumn("j2ksec");
                                    j2ksec = temp.getQuick(0, 0);
                                    temp = gdm.getColumn("xTilt");
                                    double xTilt = temp.getQuick(0, 0);
                                    temp = gdm.getColumn("yTilt");
                                    double yTilt = temp.getQuick(0, 0);
                                    temp = gdm.getColumn("holeTemp");
                                    double holeTemp = temp.getQuick(0, 0);
                                    temp = gdm.getColumn("boxTemp");
                                    double boxTemp = temp.getQuick(0, 0);
                                    temp = gdm.getColumn("instVolt");
                                    double instVolt = temp.getQuick(0, 0);
                                    temp = gdm.getColumn("gndVolt");
                                    double gndVolt = temp.getQuick(0, 0);
                                    temp = gdm.getColumn("rainfall");
                                    double rainfall = temp.getQuick(0, 0);
                                    this.sqlDataSource.insertV2TiltData(this.channelCode.toLowerCase(), j2ksec, xTilt, yTilt, holeTemp, boxTemp, instVolt, gndVolt, rainfall);
                                    continue;
                                }
                                if (this.dataSource.equals("hvo_deformation_strain") && this.sqlDataSource.getType().equals("genericfixed")) {
                                    temp = gdm.getColumn("j2ksec");
                                    j2ksec = temp.getQuick(0, 0);
                                    temp = gdm.getColumn("dt01");
                                    double dt01 = temp.getQuick(0, 0);
                                    temp = gdm.getColumn("dt02");
                                    double dt02 = temp.getQuick(0, 0);
                                    temp = gdm.getColumn("barometer");
                                    double barometer = temp.getQuick(0, 0);
                                    this.sqlDataSource.insertV2StrainData(this.channelCode.toLowerCase(), j2ksec, dt01, dt02, barometer);
                                    continue;
                                }
                                if (!this.dataSource.equals("hvo_gas_co2") || !this.sqlDataSource.getType().equals("genericfixed")) continue;
                                temp = gdm.getColumn("j2ksec");
                                j2ksec = temp.getQuick(0, 0);
                                temp = gdm.getColumn("co2l");
                                double co2l = temp.getQuick(0, 0);
                                temp = gdm.getColumn("co2h");
                                double co2h = temp.getQuick(0, 0);
                                this.sqlDataSource.insertV2GasData(1, j2ksec, co2l);
                                this.sqlDataSource.insertV2GasData(2, j2ksec, co2h);
                            }
                            ++lineNumber;
                        }
                        done = true;
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "ImportPoll.process() failed for channel " + this.channel.getCode() + " try " + tries, e);
                        continue;
                    }
                    finally {
                        if (this.connection != null) {
                            this.connection.disconnect();
                        }
                    }
                }
                if (done) {
                    this.logger.log(Level.INFO, "End Polling [" + this.channelCode + "] Success");
                } else {
                    this.logger.log(Level.INFO, "End Polling [" + this.channelCode + "] Failure");
                }
                Thread.sleep(this.betweenPollDelay);
            }
            this.logger.log(Level.INFO, "");
            this.logger.log(Level.INFO, "END POLLING CYCLE");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "DataPoller.process() failed.", e);
        }
    }

    public String outputConnectionInfo() {
        return this.deviceIP + "|" + this.devicePort + "|" + this.postConnectDelay + "|" + this.betweenPollDelay;
    }

    public String outputConnectionHeader() {
        return "deviceIP|devicePort|postConnectDelay|betweenPollDelay";
    }

    public void outputInstructions(String importerClass, String message) {
        if (message == null) {
            System.err.println(message);
        }
        System.err.println(importerClass + " -c configfile");
    }

    public static void main(String[] as) {
        ImportPoll importer = new ImportPoll();
        Arguments args = new Arguments(as, flags, keys);
        if (args.flagged("-h")) {
            importer.outputInstructions(importer.getClass().getName(), null);
            System.exit(-1);
        }
        if (!args.contains("-c")) {
            importer.outputInstructions(importer.getClass().getName(), "Config file required");
            System.exit(-1);
        }
        importer.initialize(importer.getClass().getName(), args.get("-c"), args.flagged("-v"));
        importer.startPolling();
    }

    static {
        keys.add("-c");
        flags.add("-h");
        flags.add("-v");
    }
}

