/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.heli.plot;

import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.plot.AxisRenderer;
import gov.usgs.plot.FrameDecorator;
import gov.usgs.plot.FrameRenderer;
import gov.usgs.plot.LegendRenderer;
import gov.usgs.plot.SmartTick;
import gov.usgs.plot.TextRenderer;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.heli.HelicorderData;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class HelicorderRenderer
extends FrameRenderer {
    private static final Font LARGE_FONT = Font.decode("Dialog-BOLD-40");
    private HelicorderData data;
    private boolean forceCenter = false;
    private double timeChunk;
    private int numRows;
    private double rowHeight;
    private double hcMinX;
    private double hcMaxX;
    private double hcMinY;
    private double hcMaxY;
    private Color[] colors = new Color[]{new Color(0, 0, 255), new Color(0, 0, 205), new Color(0, 0, 155), new Color(0, 0, 105)};
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    private int clipValue = 3000;
    private boolean showClip = false;
    private boolean alertClip = false;
    private String clipWav;
    private int alertClipTimeout;
    private double lastClipAlert;
    private double lastClipTime;
    private String channel;
    private boolean largeChannelDisplay;
    private FrameDecorator decorator;
    private boolean showDecorator = true;

    public HelicorderRenderer() {
    }

    public HelicorderRenderer(HelicorderData d, double xs) {
        this();
        this.data = d;
        this.timeChunk = xs;
    }

    public void setData(HelicorderData d) {
        this.data = d;
    }

    public void setTimeChunk(double xs) {
        this.timeChunk = xs;
    }

    public double getTimeChunk() {
        return this.timeChunk;
    }

    public void setLargeChannelDisplay(boolean b) {
        this.largeChannelDisplay = b;
    }

    public double[] getTranslationInfo(boolean adjTime) {
        double tzo = 0.0;
        if (adjTime) {
            tzo = Time.getTimeZoneOffset(this.timeZone, this.getViewEndTime());
        }
        return new double[]{this.graphX, this.graphX + this.graphWidth, this.rowHeight, this.graphY, this.hcMinX + tzo, this.hcMaxX + tzo, this.timeChunk, this.timeChunk / (double)this.graphWidth};
    }

    public double helicorderGetXScale() {
        return (double)this.graphWidth / this.timeChunk;
    }

    public double helicorderGetYScale() {
        return (double)this.graphHeight / (double)this.numRows / (this.hcMaxY - this.hcMinY);
    }

    public double helicorderGetXPixel(double x) {
        double tx = (x - this.hcMinX) % this.timeChunk;
        return tx * this.helicorderGetXScale() + (double)this.graphX;
    }

    public double helicorderGetYPixel(double x, double y) {
        int row = this.numRows - (int)((x - this.hcMinX) / this.timeChunk) - 1;
        return (double)(this.graphY + this.graphHeight) - (y - this.hcMinY) * this.helicorderGetYScale() - (double)row * this.rowHeight;
    }

    public double getHelicorderMaxX() {
        return this.hcMaxX;
    }

    public double getHelicorderMinX() {
        return this.hcMinX;
    }

    public double getViewEndTime() {
        return this.hcMinX + (double)this.numRows * this.timeChunk;
    }

    public void setHelicorderExtents(double loX, double hiX, double loY, double hiY) {
        this.hcMinY = loY;
        this.hcMaxY = hiY;
        this.hcMinX = loX - loX % this.timeChunk;
        this.hcMaxX = hiX + (this.timeChunk - hiX % this.timeChunk);
        this.numRows = (int)((this.hcMaxX - this.hcMinX) / this.timeChunk);
        this.rowHeight = (double)this.graphHeight / (double)this.numRows;
        super.setExtents(0.0, this.timeChunk, 0.0, this.numRows);
    }

    public int getRow(double x) {
        if (x - this.hcMinX < 0.0) {
            return -1;
        }
        return (int)((x - this.hcMinX) / this.timeChunk);
    }

    public void setChannel(String ch) {
        this.channel = ch.replace('$', ' ');
    }

    public void setClipBars(int clipBars) {
    }

    public void setClipWav(String cw) {
        this.clipWav = cw;
    }

    public void setClipAlertTimeout(int to) {
        this.alertClipTimeout = to;
    }

    public void setForceCenter(boolean forceCenter) {
        this.forceCenter = forceCenter;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setTimeZone(TimeZone tz) {
        if (tz != null) {
            this.timeZone = tz;
        }
    }

    public void setTimeZoneAbbr(String s) {
    }

    public void setTimeZoneOffset(double h) {
    }

    public void setShowClip(boolean b) {
        this.showClip = b;
    }

    public void setAlertClip(boolean b) {
        this.alertClip = b;
    }

    public void setClipValue(int i) {
        this.clipValue = i;
    }

    public double getRowHeight() {
        return this.rowHeight;
    }

    public void setFrameDecorator(FrameDecorator d) {
        this.decorator = d;
    }

    public void setColors(Color[] cs) {
        this.colors = cs;
    }

    public void setShowDecorator(boolean sd) {
        this.showDecorator = sd;
    }

    public void createDefaultLegendRenderer(String[] s) {
        this.legendRenderer = new LegendRenderer();
        this.legendRenderer.x = this.graphX + 6;
        this.legendRenderer.y = this.graphY + 6;
        for (int i = 0; i < s.length; ++i) {
            this.legendRenderer.addLine(null, null, s[i]);
        }
    }

    public void render(Graphics2D g) {
        if (this.data == null) {
            return;
        }
        if (this.decorator != null) {
            this.decorator.decorate(this);
        }
        AffineTransform origAT = g.getTransform();
        Color origColor = g.getColor();
        Shape origClip = g.getClip();
        if (this.axis != null) {
            this.axis.render(g);
        }
        g.setClip(new Rectangle(this.graphX + 1, this.graphY + 1, this.graphWidth - 1, this.graphHeight - 1));
        DoubleMatrix2D j2k = this.data.getTimes();
        DoubleMatrix2D min = this.data.getMin();
        DoubleMatrix2D max = this.data.getMax();
        double t2 = 0.0;
        double bias = Double.NaN;
        int lastRow = -1;
        int numRows = j2k.rows();
        Color lastColor = null;
        for (int j = 0; j < numRows; ++j) {
            int r;
            double t1 = j2k.getQuick(j, 0);
            int k = (int)((t1 - this.hcMinX) / this.timeChunk) % this.colors.length;
            if (k < 0) {
                k = 0;
            }
            if (lastColor != this.colors[k]) {
                g.setColor(this.colors[k]);
                lastColor = this.colors[k];
            }
            if ((r = this.getRow(t2 = t1 + 1.0)) != lastRow) {
                double st = this.hcMinX + (double)r * this.timeChunk;
                bias = this.data.getBiasBetween(st, st + this.timeChunk);
                lastRow = r;
            }
            double x = this.helicorderGetXPixel(t1);
            double w = this.helicorderGetXPixel(t2) - x;
            double ymax = max.getQuick(j, 0);
            double ymin = min.getQuick(j, 0);
            if (ymax == -2.147483648E9 || ymin == -2.147483648E9) continue;
            ymax -= bias;
            ymin -= bias;
            if (this.showClip && (ymax >= (double)this.clipValue || ymin <= (double)(-this.clipValue))) {
                this.lastClipTime = t1;
                if (lastColor != Color.red) {
                    g.setColor(Color.red);
                    lastColor = Color.red;
                }
            }
            if (ymax > (double)this.clipValue) {
                ymax = this.clipValue;
            }
            if (ymin < (double)(-this.clipValue)) {
                ymin = -this.clipValue;
            }
            double y = this.helicorderGetYPixel(t1, ymax);
            double h = this.helicorderGetYPixel(t1, ymin) - y;
            int hgt = (int)(h + 1.0);
            if (hgt < 1) {
                hgt = 1;
            }
            if (this.forceCenter) {
                y = this.helicorderGetYPixel(t1, 0.0) - (double)(hgt / 2);
            }
            g.fillRect((int)(x + 1.0), (int)(y + 1.0), (int)(w + 1.0), hgt);
        }
        g.setClip(origClip);
        g.setColor(origColor);
        g.setTransform(origAT);
        if (this.legendRenderer != null) {
            this.legendRenderer.render(g);
        }
        if (this.axis != null) {
            this.axis.postRender(g);
        }
        if (this.largeChannelDisplay && this.channel != null) {
            Font oldFont = g.getFont();
            g.setFont(LARGE_FONT);
            String c = this.channel.replace('_', ' ');
            FontMetrics fm = g.getFontMetrics();
            Font f = g.getFont();
            float s = f.getSize();
            int width = fm.stringWidth(c);
            while ((double)width / (double)this.graphWidth > 0.5) {
                float f2;
                s -= 1.0f;
                if (!(f2 > 1.0f)) break;
                g.setFont(f.deriveFont(s));
                fm = g.getFontMetrics();
                width = fm.stringWidth(c);
            }
            int height = fm.getAscent() + fm.getDescent();
            int lw = width + 20;
            if (this.alertClip && this.lastClipTime > t2 - (double)this.alertClipTimeout && this.clipWav != null) {
                g.setColor(Color.red);
                if (this.lastClipTime > this.lastClipAlert + (double)this.alertClipTimeout) {
                    this.lastClipAlert = t2;
                    this.playClipAlert();
                }
            } else if (this.alertClip) {
                g.setColor(new Color(128, 255, 128, 192));
            } else {
                g.setColor(new Color(255, 255, 255, 192));
            }
            g.fillRect(this.graphX + this.graphWidth / 2 - lw / 2, 3, lw, height);
            g.setColor(Color.black);
            g.drawRect(this.graphX + this.graphWidth / 2 - lw / 2, 3, lw, height);
            g.drawString(c, this.graphX + this.graphWidth / 2 - width / 2, height - fm.getDescent());
            g.setFont(oldFont);
        } else if (this.alertClip && this.lastClipTime > t2 - (double)this.alertClipTimeout && this.clipWav != null && this.lastClipTime > this.lastClipAlert + (double)this.alertClipTimeout) {
            this.lastClipAlert = t2;
            this.playClipAlert();
        }
    }

    public void createMinimumAxis() {
        this.decorator = new MinimumDecorator();
    }

    public void createDefaultAxis() {
        this.decorator = new StandardDecorator();
    }

    private void playClipAlert() {
        Runnable r = new Runnable(){

            public void run() {
                File soundFile = new File(HelicorderRenderer.this.clipWav);
                AudioInputStream audioInputStream = null;
                try {
                    audioInputStream = AudioSystem.getAudioInputStream(soundFile);
                    AudioFormat audioFormat = audioInputStream.getFormat();
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                    SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
                    line.open(audioFormat);
                    line.start();
                    int nBytesRead = 0;
                    byte[] abData = new byte[1024];
                    while (nBytesRead != -1) {
                        nBytesRead = audioInputStream.read(abData, 0, abData.length);
                        if (nBytesRead < 0) continue;
                        line.write(abData, 0, nBytesRead);
                    }
                    line.drain();
                    line.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    class StandardDecorator
    extends FrameDecorator {
        StandardDecorator() {
        }

        public void decorate(FrameRenderer fr) {
            int minutes;
            HelicorderRenderer.this.axis = new AxisRenderer(fr);
            HelicorderRenderer.this.axis.createDefault();
            int majorTicks = minutes = (int)Math.round(HelicorderRenderer.this.timeChunk / 60.0);
            if (minutes > 30 && minutes < 180) {
                majorTicks = minutes / 5;
            } else if (minutes >= 180 && minutes < 360) {
                majorTicks = minutes / 10;
            } else if (minutes >= 360) {
                majorTicks = minutes / 20;
            }
            double[] mjt = SmartTick.intervalTick(HelicorderRenderer.this.minX, HelicorderRenderer.this.maxX, majorTicks);
            int minorTicks = 0;
            if (minutes <= 30) {
                minorTicks = (int)Math.round(HelicorderRenderer.this.timeChunk / 10.0);
            } else if (minutes > 30 && minutes <= 180) {
                minorTicks = minutes;
            } else if (minutes > 180) {
                minorTicks = minutes / 5;
            }
            double[] mnt = SmartTick.intervalTick(HelicorderRenderer.this.minX, HelicorderRenderer.this.maxX, minorTicks);
            HelicorderRenderer.this.axis.createBottomTicks(mjt, mnt);
            HelicorderRenderer.this.axis.createTopTicks(mjt, mnt);
            HelicorderRenderer.this.axis.createVerticalGridLines(mjt);
            String[] btl = new String[mjt.length];
            for (int i = 0; i < mjt.length; ++i) {
                btl[i] = Long.toString(Math.round(mjt[i] / 60.0));
            }
            HelicorderRenderer.this.axis.createBottomTickLabels(mjt, btl);
            if (HelicorderRenderer.this.showDecorator) {
                HelicorderRenderer.this.axis.setBottomLabelAsText("+ Minutes");
            }
            double[] labelPosLR = new double[HelicorderRenderer.this.numRows];
            String[] leftLabelText = new String[HelicorderRenderer.this.numRows];
            String[] rightLabelText = new String[HelicorderRenderer.this.numRows];
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
            SimpleDateFormat dayFormat = new SimpleDateFormat("MM-dd");
            timeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            dayFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            boolean dst = HelicorderRenderer.this.timeZone.inDaylightTime(Util.j2KToDate(HelicorderRenderer.this.getViewEndTime()));
            double timeOffset = Time.getTimeZoneOffset(HelicorderRenderer.this.timeZone, dst);
            double pixelsPast = 0.0;
            double pixelsPerRow = HelicorderRenderer.this.graphHeight / HelicorderRenderer.this.numRows;
            String lastDayL = "";
            String lastDayR = "";
            for (int i = HelicorderRenderer.this.numRows - 1; i >= 0; --i) {
                pixelsPast += pixelsPerRow;
                labelPosLR[i] = (double)i + 0.5;
                double j2ks = HelicorderRenderer.this.hcMaxX - (double)(i + 1) * HelicorderRenderer.this.timeChunk;
                double j2ke = j2ks + HelicorderRenderer.this.timeChunk;
                Date dtz = Util.j2KToDate(j2ks + timeOffset);
                String ftl = timeFormat.format(dtz);
                String fdl = dayFormat.format(dtz);
                Date dutc = Util.j2KToDate(j2ke);
                String ftr = timeFormat.format(dutc);
                String fdr = dayFormat.format(dutc);
                leftLabelText[i] = null;
                if (!fdl.equals(lastDayL)) {
                    leftLabelText[i] = fdl + "           ";
                }
                if (timeOffset != 0.0 && !fdr.equals(lastDayR)) {
                    rightLabelText[i] = "           " + fdr;
                }
                lastDayL = fdl;
                lastDayR = fdr;
                if (!(pixelsPast > 20.0)) continue;
                leftLabelText[i] = leftLabelText[i] != null ? fdl + " " + ftl : ftl;
                if (timeOffset != 0.0) {
                    rightLabelText[i] = rightLabelText[i] != null ? ftr + " " + fdr : ftr;
                }
                pixelsPast = 0.0;
            }
            HelicorderRenderer.this.axis.createLeftTickLabels(labelPosLR, leftLabelText);
            HelicorderRenderer.this.axis.createRightTickLabels(labelPosLR, rightLabelText);
            if (HelicorderRenderer.this.showDecorator) {
                HelicorderRenderer.this.axis.setBottomLeftLabelAsText("Time (" + HelicorderRenderer.this.timeZone.getDisplayName(dst, 0) + ")");
                if (timeOffset != 0.0) {
                    HelicorderRenderer.this.axis.setBottomRightLabelAsText("Time (UTC)");
                }
            }
            double[] hg = new double[HelicorderRenderer.this.numRows - 1];
            for (int i = 0; i < HelicorderRenderer.this.numRows - 1; ++i) {
                hg[i] = (double)i + 1.0;
            }
            HelicorderRenderer.this.axis.createHorizontalGridLines(hg);
            HelicorderRenderer.this.axis.setBackgroundColor(Color.white);
        }
    }

    class MinimumDecorator
    extends FrameDecorator {
        MinimumDecorator() {
        }

        public void decorate(FrameRenderer fr) {
            int minutes;
            HelicorderRenderer.this.axis = new AxisRenderer(fr);
            HelicorderRenderer.this.axis.createDefault();
            int majorTicks = minutes = (int)Math.round(HelicorderRenderer.this.timeChunk / 60.0);
            if (minutes > 30 && minutes < 180) {
                majorTicks = minutes / 5;
            } else if (minutes >= 180 && minutes < 360) {
                majorTicks = minutes / 10;
            } else if (minutes >= 360) {
                majorTicks = minutes / 20;
            }
            double[] mjt = SmartTick.intervalTick(HelicorderRenderer.this.minX, HelicorderRenderer.this.maxX, majorTicks);
            HelicorderRenderer.this.axis.createBottomTicks(null, mjt);
            HelicorderRenderer.this.axis.createTopTicks(null, mjt);
            HelicorderRenderer.this.axis.createVerticalGridLines(mjt);
            String[] btl = new String[mjt.length];
            for (int i = 0; i < mjt.length; ++i) {
                btl[i] = Long.toString(Math.round(mjt[i] / 60.0));
            }
            double[] labelPosLR = new double[HelicorderRenderer.this.numRows];
            String[] leftLabelText = new String[HelicorderRenderer.this.numRows];
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
            SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
            timeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            dayFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            double pixelsPast = 0.0;
            double pixelsPerRow = HelicorderRenderer.this.graphHeight / HelicorderRenderer.this.numRows;
            for (int i = HelicorderRenderer.this.numRows - 1; i >= 0; --i) {
                pixelsPast += pixelsPerRow;
                labelPosLR[i] = (double)i + 0.5;
                Date dtz = Util.j2KToDate(HelicorderRenderer.this.hcMaxX - (double)(i + 1) * HelicorderRenderer.this.timeChunk);
                String ftl = timeFormat.format(dtz);
                leftLabelText[i] = null;
                if (!(pixelsPast > 20.0)) continue;
                leftLabelText[i] = ftl;
                pixelsPast = 0.0;
            }
            HelicorderRenderer.this.axis.createLeftTickLabels(labelPosLR, leftLabelText);
            HelicorderRenderer.this.axis.addRenderer(new TextRenderer(HelicorderRenderer.this.graphX, HelicorderRenderer.this.graphY - 3, HelicorderRenderer.this.channel + ", " + dayFormat.format(Util.j2KToDate(HelicorderRenderer.this.hcMaxX))));
            double[] hg = new double[HelicorderRenderer.this.numRows - 1];
            for (int i = 0; i < HelicorderRenderer.this.numRows - 1; ++i) {
                hg[i] = (double)i + 1.0;
            }
            HelicorderRenderer.this.axis.createHorizontalGridLines(hg);
            HelicorderRenderer.this.axis.setBackgroundColor(Color.white);
        }
    }
}

