/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFile {
    private Map<String, List<String>> config;
    private String name;
    private boolean successfullyRead = false;

    public ConfigFile() {
        this.config = new HashMap<String, List<String>>();
    }

    public ConfigFile(Map<String, List<String>> map) {
        this.config = map;
    }

    public ConfigFile(String fn) {
        this.setName(fn);
        this.config = new HashMap<String, List<String>>();
        this.readConfigFile(fn);
    }

    public boolean wasSuccessfullyRead() {
        return this.successfullyRead;
    }

    public void readConfigFile(String fn) {
        try {
            String s;
            File f = new File(fn);
            BufferedReader in = new BufferedReader(new FileReader(f));
            while ((s = in.readLine()) != null) {
                if ((s = s.trim()).length() != 0 && !s.startsWith("#") && !s.startsWith("@")) {
                    String key = s.substring(0, s.indexOf(61));
                    String val = s.substring(s.indexOf(61) + 1);
                    if (val.toLowerCase().equals("@begin-multiline")) {
                        StringBuffer sb = new StringBuffer(2048);
                        boolean done = false;
                        while (!done) {
                            String is = in.readLine();
                            if (is.toLowerCase().equals("@end-multiline")) {
                                done = true;
                                continue;
                            }
                            sb.append(is);
                            sb.append('\n');
                        }
                        val = sb.toString();
                    }
                    List<String> ss = this.getOrCreateList(key);
                    ss.add(val);
                }
                if (!s.toLowerCase().startsWith("@include ")) continue;
                String ifn = s.substring(s.indexOf(" ") + 1);
                ifn = f.getAbsoluteFile().getParent() + File.separator + ifn;
                this.readConfigFile(ifn);
            }
            in.close();
            this.successfullyRead = true;
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> get(String key) {
        return this.config.get(key);
    }

    private List<String> getOrCreateList(String key) {
        List<String> ss = this.config.get(key);
        if (ss == null) {
            ss = new ArrayList<String>();
            this.config.put(key, ss);
        }
        return ss;
    }

    public void putList(String key, List<String> list) {
        this.config.put(key, list);
    }

    public void put(String key, String val) {
        this.getOrCreateList(key).add(val);
    }

    public void put(String key, String val, boolean l) {
        if (!l) {
            this.remove(key);
        }
        this.put(key, val);
    }

    public void remove(String key) {
        this.config.remove(key);
    }

    public void remove(String key, String val) {
        List<String> ss = this.config.get(key);
        if (ss == null) {
            return;
        }
        ss.remove(val);
        if (ss.size() == 0) {
            this.config.remove(key);
        }
    }

    public String getString(String key) {
        List<String> ss = this.config.get(key);
        if (ss == null || ss.size() == 0) {
            return null;
        }
        return ss.get(0);
    }

    public List<String> getList(String key) {
        return this.config.get(key);
    }

    public ConfigFile getSubConfig(String prefix) {
        ConfigFile result = new ConfigFile();
        result.successfullyRead = true;
        result.name = prefix;
        for (String key : this.config.keySet()) {
            if (!key.startsWith(prefix) || key.length() <= prefix.length()) continue;
            String newKey = key.substring(prefix.length() + 1);
            result.getConfig().put(newKey, this.config.get(key));
        }
        return result;
    }

    public Map<String, List<String>> getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n.endsWith(".config") ? n.substring(0, n.indexOf(".config")) : n;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.config.keySet()) {
            List<String> list = this.config.get(key);
            if (list.size() == 1) {
                sb.append(key + "=" + list.get(0) + "\n");
                continue;
            }
            sb.append(key + "=[list]\n");
            for (String s : list) {
                sb.append("\t" + s + "\n");
            }
        }
        return sb.toString();
    }

    public void writeToFile(String fn) {
        this.setName(fn);
        Set<String> keySet = this.config.keySet();
        Iterator<String> it = keySet.iterator();
        ArrayList<String> v = new ArrayList<String>();
        while (it.hasNext()) {
            v.add(it.next());
        }
        Object[] keys = new String[v.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = (String)v.get(i);
        }
        Arrays.sort(keys);
        try {
            File f = new File(fn);
            File bak = new File(fn + ".bak");
            if (bak.exists()) {
                bak.delete();
            }
            if (f.exists()) {
                f.renameTo(bak);
            }
            PrintWriter out = new PrintWriter(new FileWriter(fn));
            for (int i = 0; i < keys.length; ++i) {
                Object k = keys[i];
                List<String> o = this.config.get(k);
                if (o instanceof String) {
                    out.println((String)k + "=" + o);
                } else {
                    List<String> vals = o;
                    Iterator<String> it2 = vals.iterator();
                    while (it2.hasNext()) {
                        out.println((String)k + "=" + it2.next());
                    }
                }
                out.println();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            ConfigFile cf = new ConfigFile(args[i]);
            System.out.println(cf);
        }
    }
}

