/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.proj;

import gov.usgs.proj.Projection;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoRange {
    private double west;
    private double east;
    private double south;
    private double north;

    public GeoRange() {
        this.north = Double.NaN;
        this.south = Double.NaN;
        this.east = Double.NaN;
        this.west = Double.NaN;
    }

    public GeoRange(Rectangle2D.Double rect) {
        this.setWest(rect.getMinX());
        this.setEast(rect.getMaxX());
        this.setSouth(rect.getMinY());
        this.setNorth(rect.getMaxY());
    }

    public GeoRange(double w, double e, double s, double n) {
        this.setWest(w);
        this.setEast(e);
        this.setSouth(s);
        this.setNorth(n);
    }

    public int hashCode() {
        return new Double(this.west).hashCode() + new Double(this.east).hashCode() + new Double(this.south).hashCode() + new Double(this.north).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeoRange)) {
            return false;
        }
        GeoRange gr = (GeoRange)obj;
        return this.west == gr.west && this.east == gr.east && this.north == gr.north && this.south == gr.south;
    }

    public GeoRange(Projection proj, double left, double right, double bottom, double top) {
        this.set(proj, left, right, bottom, top);
    }

    public GeoRange(Projection proj, Point2D.Double center, double xm, double ym) {
        Point2D.Double pt = proj.forward(center);
        double left = pt.x - xm / 2.0;
        double right = pt.x + xm / 2.0;
        double top = pt.y + ym / 2.0;
        double bottom = pt.y - ym / 2.0;
        this.set(proj, left, right, bottom, top);
    }

    public boolean isValid() {
        return !Double.isNaN(this.west) && !Double.isNaN(this.east) && !Double.isNaN(this.south) && !Double.isNaN(this.north);
    }

    public void set(Projection proj, double left, double right, double bottom, double top) {
        Point2D.Double[] pt = new Point2D.Double[8];
        pt[0] = new Point2D.Double(left, top);
        pt[1] = new Point2D.Double(left, bottom);
        pt[2] = new Point2D.Double(right, top);
        pt[3] = new Point2D.Double(right, bottom);
        double dx = right - left;
        double dy = top - bottom;
        pt[4] = new Point2D.Double(left + dx / 2.0, top);
        pt[5] = new Point2D.Double(left + dx / 2.0, bottom);
        pt[6] = new Point2D.Double(left, bottom + dy / 2.0);
        pt[7] = new Point2D.Double(right, bottom + dy / 2.0);
        this.west = Double.MAX_VALUE;
        this.south = Double.MAX_VALUE;
        this.east = -1.7976931348623157E308;
        this.north = -1.7976931348623157E308;
        for (int i = 0; i < 8; ++i) {
            pt[i] = proj.inverse(pt[i]);
            this.west = Math.min(this.west, pt[i].x);
            this.south = Math.min(this.south, pt[i].y);
            this.east = Math.max(this.east, pt[i].x);
            this.north = Math.max(this.north, pt[i].y);
        }
        this.setEast(this.east);
        this.setWest(this.west);
        this.setSouth(this.south);
        this.setNorth(this.north);
    }

    public void pad(double lonPad, double latPad) {
        double lr = this.getLonRange();
        if (lr + lonPad > 360.0) {
            lonPad = 360.0 - lr;
        }
        this.setWest(this.west - lonPad / 2.0);
        this.setEast(this.east + lonPad / 2.0);
        lr = this.getLatRange();
        if (lr + latPad > 180.0) {
            latPad = 180.0 - lr;
        }
        this.setWest(this.west - latPad / 2.0);
        this.setEast(this.east + latPad / 2.0);
    }

    public void padPercent(double lonPad, double latPad) {
        this.pad(this.getLonRange() * lonPad, this.getLatRange() * latPad);
    }

    public void includePoint(Point2D.Double lonLat, double singleBuffer) {
        if (Double.isNaN(this.west)) {
            this.west = lonLat.x - singleBuffer;
            this.east = lonLat.x + singleBuffer;
            this.south = lonLat.y - singleBuffer;
            this.north = lonLat.y + singleBuffer;
            return;
        }
        if (this.contains(lonLat)) {
            return;
        }
        this.setSouth(Math.min(this.south, lonLat.y));
        this.setNorth(Math.max(this.north, lonLat.y));
        if (!this.containsLongitude(lonLat.x)) {
            double lre;
            double lrw = Math.abs(GeoRange.getLonRange(this.west, lonLat.x));
            if (lrw > 180.0) {
                lrw = Math.abs(lrw - 360.0);
            }
            if ((lre = Math.abs(GeoRange.getLonRange(this.east, lonLat.x))) > 180.0) {
                lre = Math.abs(lre - 360.0);
            }
            if (lrw <= lre) {
                this.setWest(lonLat.x);
            } else {
                this.setEast(lonLat.x);
            }
        }
    }

    public double getScale(Projection proj, int w, int h) {
        double[] r = this.getProjectedExtents(proj);
        double scale = Math.max((r[1] - r[0]) / (double)w, (r[3] - r[2]) / (double)h);
        return scale;
    }

    public void flipEastWest() {
        double t = this.west;
        this.west = this.east;
        this.east = t;
    }

    public void setWest(double w) {
        while (w >= 180.0) {
            w -= 360.0;
        }
        while (w < -180.0) {
            w += 360.0;
        }
        this.west = w;
    }

    public void setEast(double e) {
        while (e > 180.0) {
            e -= 360.0;
        }
        while (e <= -180.0) {
            e += 360.0;
        }
        this.east = e;
    }

    public void setNorth(double n) {
        if (n > 90.0) {
            n = 90.0;
        }
        this.north = n;
    }

    public void setSouth(double s) {
        if (s < -90.0) {
            s = 90.0;
        }
        this.south = s;
    }

    public static double normalize(double d) {
        d %= 360.0;
        while (d > 180.0) {
            d -= 360.0;
        }
        while (d < -180.0) {
            d += 360.0;
        }
        return d;
    }

    public static double getLonRange(double w, double e) {
        double d = e - w;
        if (e < w) {
            return 360.0 + d;
        }
        return d;
    }

    public GeoRange(GeoRange copy) {
        this.west = copy.west;
        this.east = copy.east;
        this.south = copy.south;
        this.north = copy.north;
    }

    public double getNorth() {
        return this.north;
    }

    public double getSouth() {
        return this.south;
    }

    public double getWest() {
        return this.west;
    }

    public double getEast() {
        return this.east;
    }

    public double getLonRange() {
        double w = this.west;
        if (w > this.east) {
            w -= 360.0;
        }
        return Math.abs(w - this.east);
    }

    public double getLatRange() {
        return Math.abs(this.north - this.south);
    }

    public Point2D.Double getCenter() {
        return new Point2D.Double(GeoRange.normalize(this.west + this.getLonRange() / 2.0), this.north - (this.north - this.south) / 2.0);
    }

    public Rectangle2D.Double getRectangle() {
        return new Rectangle2D.Double(this.west, this.south, this.getLonRange(), this.getLatRange());
    }

    public boolean contains(Point2D.Double pt) {
        boolean inLat;
        double lat = pt.y;
        boolean bl = inLat = lat >= this.south && lat <= this.north;
        if (!inLat) {
            return false;
        }
        double lon = GeoRange.normalize(pt.x);
        if (this.west < this.east) {
            return this.west <= lon && lon <= this.east;
        }
        return this.west <= lon && lon <= 180.0 || lon <= this.east && lon >= -180.0;
    }

    public boolean containsLongitude(double lon) {
        lon = GeoRange.normalize(lon);
        if (this.west < this.east) {
            return this.west <= lon && lon <= this.east;
        }
        return this.west <= lon && lon <= 180.0 || lon <= this.east && lon >= -180.0;
    }

    public boolean overlaps(GeoRange range) {
        double d;
        Rectangle2D.Double[] rects = new Rectangle2D.Double[4];
        int numRects = 2;
        rects[0] = this.getRectangle();
        rects[1] = range.getRectangle();
        if (rects[0].x + rects[0].width > 180.0) {
            d = rects[0].x + rects[0].width - 180.0;
            rects[0].width = 180.0 - rects[0].x;
            rects[numRects++] = new Rectangle2D.Double(-180.0, rects[0].y, d, rects[0].height);
        }
        if (rects[1].x + rects[1].width > 180.0) {
            d = rects[1].x + rects[1].width - 180.0;
            rects[1].width = 180.0 - rects[1].x;
            rects[numRects++] = new Rectangle2D.Double(-180.0, rects[1].y, d, rects[1].height);
        }
        for (int i = 0; i < numRects; ++i) {
            for (int j = i + 1; j < numRects; ++j) {
                if (!rects[i].intersects(rects[j])) continue;
                return true;
            }
        }
        return false;
    }

    public double[] getProjectedExtents(Projection proj) {
        Point2D.Double[] pt = new Point2D.Double[]{new Point2D.Double(this.west, this.north), new Point2D.Double(this.west, this.south), new Point2D.Double(this.east, this.north), new Point2D.Double(this.east, this.south), new Point2D.Double(GeoRange.normalize(this.west + this.getLonRange() / 2.0), this.south), new Point2D.Double(GeoRange.normalize(this.west + this.getLonRange() / 2.0), this.north), new Point2D.Double(this.west, this.south + (this.north - this.south) / 2.0), new Point2D.Double(this.east, this.south + (this.north - this.south) / 2.0)};
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (int i = 0; i < 8; ++i) {
            pt[i] = proj.forward(pt[i]);
            minX = Math.min(minX, pt[i].x);
            minY = Math.min(minY, pt[i].y);
            maxX = Math.max(maxX, pt[i].x);
            maxY = Math.max(maxY, pt[i].y);
        }
        return new double[]{minX, maxX, minY, maxY};
    }

    public static GeoRange getBoundingBox(Collection<Point2D.Double> pts) {
        if (pts == null || pts.size() <= 0) {
            return null;
        }
        Rectangle2D rect = null;
        for (Point2D.Double pt : pts) {
            if (pt == null) continue;
            if (rect == null) {
                rect = new Rectangle2D.Double(pt.x, pt.y, 0.0, 0.0);
            }
            rect.add(pt);
        }
        double n = Math.max(((Rectangle2D.Double)rect).width, ((Rectangle2D.Double)rect).height);
        double nw = n * 2.0;
        double nh = n * 2.0;
        ((Rectangle2D.Double)rect).x -= (nw - ((Rectangle2D.Double)rect).width) / 2.0;
        ((Rectangle2D.Double)rect).y -= (nh - ((Rectangle2D.Double)rect).height) / 2.0;
        ((Rectangle2D.Double)rect).width = nw;
        ((Rectangle2D.Double)rect).height = nh;
        if (((Rectangle2D.Double)rect).width == 0.0 || ((Rectangle2D.Double)rect).height == 0.0) {
            ((Rectangle2D.Double)rect).x -= 0.15;
            ((Rectangle2D.Double)rect).y -= 0.15;
            ((Rectangle2D.Double)rect).width = 0.3;
            ((Rectangle2D.Double)rect).height = 0.3;
        }
        GeoRange gr = new GeoRange((Rectangle2D.Double)rect);
        return gr;
    }

    public String toString() {
        return "GeoRange: " + this.west + "," + this.east + "," + this.south + "," + this.north;
    }

    public static void test() {
        int j;
        int i;
        Point2D.Double[] tps = new Point2D.Double[]{new Point2D.Double(165.0, 60.0), new Point2D.Double(170.0, 60.0), new Point2D.Double(175.0, 60.0), new Point2D.Double(-180.0, 60.0), new Point2D.Double(180.0, 60.0), new Point2D.Double(-175.0, 60.0), new Point2D.Double(-172.0, 60.0), new Point2D.Double(-170.0, 60.0), new Point2D.Double(-160.0, 60.0)};
        GeoRange[] grs = new GeoRange[]{new GeoRange(-170.0, 170.0, -45.0, 45.0)};
        for (i = 0; i < grs.length; ++i) {
            System.out.println(grs[i] + "\n\tLonRange: " + grs[i].getLonRange() + "\n\tCenter: " + grs[i].getCenter());
            for (j = 0; j < tps.length; ++j) {
                System.out.println("\t\t" + tps[j] + " in " + grs[i] + ": " + grs[i].contains(tps[j]));
            }
        }
        for (i = 0; i < grs.length; ++i) {
            for (j = i; j < grs.length; ++j) {
                System.out.println(grs[i] + " overlaps " + grs[j] + ": " + grs[i].overlaps(grs[j]) + "\n");
            }
        }
    }

    public static void main(String[] args) {
        GeoRange.test();
        System.out.println(GeoRange.getLonRange(179.12659626750332, -150.0));
        System.out.println(GeoRange.getLonRange(-150.0, -100.0));
        System.out.println(GeoRange.getLonRange(100.0, 150.0));
        System.out.println(GeoRange.getLonRange(-150.0, 100.0));
        System.out.println(GeoRange.getLonRange(170.0, -170.0));
        System.out.println(GeoRange.getLonRange(180.0, -170.0));
        System.out.println(GeoRange.getLonRange(-179.0, 179.0));
        double[] d = new double[]{-1.0E300, -720.0, -510.0, -360.0, -270.0, -180.0, -90.0, 0.0, 90.0, 180.0, 270.0, 360.0, 510.0, 720.0, 1.0E300};
        for (int i = 0; i < d.length; ++i) {
            System.out.println(d[i] + " -> " + d[i] % 360.0);
        }
    }
}

