/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.plot.TextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;

public class ShadowedTextRenderer
extends TextRenderer {
    public Color shadowColor = Color.LIGHT_GRAY;
    public int shadowX = 1;
    public int shadowY = 1;

    public ShadowedTextRenderer() {
        this.color = Color.BLACK;
    }

    public ShadowedTextRenderer(double xx, double yy, String t) {
        super(xx, yy, t);
        this.color = Color.BLACK;
    }

    public void render(Graphics2D g) {
        Font origFont = g.getFont();
        AffineTransform origAT = g.getTransform();
        Color origColor = g.getColor();
        Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(this.font);
        if (this.text != null) {
            Point loc = this.getPixelLocation(g);
            g.translate(loc.x, loc.y);
            g.rotate(Math.toRadians(this.orientation));
            FontMetrics fm = g.getFontMetrics(g.getFont());
            g.setColor(this.shadowColor);
            g.drawString(this.text, -fm.stringWidth(this.text) / 2 + this.shadowX, fm.getHeight() / 2 + this.shadowY);
            g.setColor(this.color);
            g.drawString(this.text, -fm.stringWidth(this.text) / 2, fm.getHeight() / 2);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
        g.setColor(origColor);
        g.setFont(origFont);
        g.setTransform(origAT);
    }
}

