/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.plot.DataPointRenderer;
import gov.usgs.plot.FrameRenderer;
import gov.usgs.plot.LegendRenderer;
import gov.usgs.plot.Renderer;
import hep.aida.ref.Histogram1D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class HistogramRenderer
extends FrameRenderer {
    private Histogram1D histogram;
    public Color fillColor;
    public Color strokeColor;
    private List<Renderer> renderers;

    public HistogramRenderer(Histogram1D h) {
        this.histogram = h;
        this.fillColor = new Color(0.0f, 0.0f, 0.56f);
        this.strokeColor = Color.BLACK;
        this.renderers = new ArrayList<Renderer>();
    }

    public void addRenderer(Renderer r) {
        this.renderers.add(r);
    }

    public void setDefaultExtents() {
        if (this.histogram == null) {
            this.minX = 0.0;
            this.maxX = 1.0;
            this.minY = 0.0;
            this.maxY = 1.0;
        } else {
            this.minX = this.histogram.xAxis().lowerEdge();
            this.maxX = this.histogram.xAxis().upperEdge();
            this.minY = 0.0;
            this.maxY = this.histogram.binHeight(this.histogram.minMaxBins()[1]) * 1.1;
            if (this.maxY == 0.0) {
                this.maxY = 1.0;
            }
        }
    }

    public void createDefaultLegendRenderer(String[] s) {
        this.legendRenderer = new LegendRenderer();
        this.legendRenderer.x = this.graphX + 6;
        this.legendRenderer.y = this.graphY + 6;
        DataPointRenderer dpr = new DataPointRenderer('s', 8.0f);
        dpr.color = this.strokeColor;
        dpr.filled = true;
        dpr.fillColor = this.fillColor;
        this.legendRenderer.addLine(null, dpr, s[0]);
    }

    public void render(Graphics2D g) {
        Color origColor = g.getColor();
        Paint origPaint = g.getPaint();
        AffineTransform origAT = g.getTransform();
        Shape origClip = g.getClip();
        if (this.axis != null) {
            this.axis.render(g);
        }
        if (this.histogram != null) {
            int bins = this.histogram.xAxis().bins();
            g.setClip(new Rectangle(this.graphX + 1, this.graphY + 1, this.graphWidth - 1, this.graphHeight - 1));
            Rectangle2D.Double rect = new Rectangle2D.Double();
            double offset = 0.0;
            for (int i = 0; i < bins; ++i) {
                double binWidth = this.histogram.xAxis().binWidth(i);
                rect.setRect(this.getXPixel(this.histogram.xAxis().lowerEdge() + offset), this.getYPixel(this.histogram.binHeight(i)), binWidth * this.getXScale(), this.histogram.binHeight(i) * this.getYScale());
                offset += binWidth;
                if (this.fillColor != null) {
                    g.setPaint(this.fillColor);
                    g.fill(rect);
                }
                if (this.strokeColor == null) continue;
                g.setPaint(Color.black);
                g.draw(rect);
            }
            g.setClip(origClip);
        }
        for (Renderer renderer : this.renderers) {
            renderer.render(g);
        }
        if (this.legendRenderer != null) {
            this.legendRenderer.render(g);
        }
        g.setTransform(origAT);
        g.setPaint(origPaint);
        g.setColor(origColor);
    }
}

