/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.math;

import gov.usgs.util.CodeTimer;

public class FFT {
    public static final double LOG10 = Math.log(10.0);

    public static double[][] pad(double[][] array) {
        int i;
        int n = array.length;
        int p2 = (int)Math.ceil(Math.log(n) / Math.log(2.0));
        int newSize = (int)Math.pow(2.0, p2);
        if (newSize == n) {
            return array;
        }
        double[][] result = new double[newSize][];
        for (i = 0; i < n; ++i) {
            result[i] = array[i];
        }
        for (i = n; i < newSize; ++i) {
            result[i] = new double[]{0.0, 0.0};
        }
        return result;
    }

    public static double[][] halve(double[][] array) {
        int n = array.length / 2;
        double[][] result = new double[n][];
        for (int i = 0; i < n; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] fastHalve(double[] array) {
        int n = array.length / 2;
        double[] result = new double[n];
        System.arraycopy(array, 0, result, 0, n);
        return result;
    }

    public static void toPowerFreq(double[][] array, double samplingRate, boolean logPower) {
        for (int i = 0; i < array.length; ++i) {
            double re = array[i][0];
            double im = array[i][1];
            double mag = Math.sqrt(re * re + im * im);
            if (logPower) {
                mag = Math.log(mag) / LOG10;
            }
            array[i][0] = (double)i / (double)array.length * (samplingRate / 2.0);
            array[i][1] = mag;
        }
    }

    public static void fastToPowerFreq(double[] array, double samplingRate, boolean logPower, boolean logFreq) {
        double n = array.length / 4;
        int i = 0;
        while ((double)i < n) {
            double re = array[i * 2];
            double im = array[i * 2 + 1];
            double mag = Math.sqrt(re * re + im * im);
            if (logPower) {
                mag = Math.log(mag) / LOG10;
            }
            array[i * 2] = (double)i / n * (samplingRate / 2.0);
            if (logFreq) {
                array[i * 2] = Math.log(array[i * 2]) / LOG10;
            }
            array[i * 2 + 1] = mag;
            ++i;
        }
    }

    public static void toPowerFreq(double[][] array, double samplingRate, boolean logPower, boolean logFreq) {
        for (int i = 0; i < array.length; ++i) {
            double re = array[i][0];
            double im = array[i][1];
            double mag = Math.sqrt(re * re + im * im);
            if (logPower) {
                mag = Math.log(mag) / LOG10;
            }
            array[i][0] = (double)i / (double)array.length * (samplingRate / 2.0);
            if (logFreq) {
                array[i][0] = Math.log(array[i][0]) / LOG10;
            }
            array[i][1] = mag;
        }
    }

    public static void fft(double[] array) {
        double t_i;
        double t_r;
        int i;
        int n = array.length / 2;
        int ln = (int)(Math.log(n) / Math.log(2.0) + 0.5);
        int nv2 = n / 2;
        int j = 1;
        for (i = 1; i < n; ++i) {
            int k;
            if (i < j) {
                t_r = array[2 * (i - 1)];
                t_i = array[2 * (i - 1) + 1];
                array[2 * (i - 1)] = array[2 * (j - 1)];
                array[2 * (i - 1) + 1] = array[2 * (j - 1) + 1];
                array[2 * (j - 1)] = t_r;
                array[2 * (j - 1) + 1] = t_i;
            }
            for (k = nv2; k < j; j -= k, k /= 2) {
            }
            j += k;
        }
        for (int l = 1; l <= ln; ++l) {
            int le = (int)(Math.exp((double)l * Math.log(2.0)) + 0.5);
            int le1 = le / 2;
            double u_r = 1.0;
            double u_i = 0.0;
            double w_r = Math.cos(Math.PI / (double)le1);
            double w_i = -Math.sin(Math.PI / (double)le1);
            for (j = 1; j <= le1; ++j) {
                i = j;
                int p = 2 * (i - 1);
                while (i <= n) {
                    int ip = i + le1;
                    int q = 2 * (ip - 1);
                    t_r = array[q] * u_r - u_i * array[q + 1];
                    t_i = array[q + 1] * u_r + u_i * array[q];
                    array[q] = array[p] - t_r;
                    array[q + 1] = array[p + 1] - t_i;
                    array[p] = array[p] + t_r;
                    array[p + 1] = array[p + 1] + t_i;
                    i += le;
                    p += 2 * le;
                }
                t_r = u_r * w_r - w_i * u_i;
                u_i = w_r * u_i + w_i * u_r;
                u_r = t_r;
            }
        }
    }

    public static void fft(double[][] array) {
        double t_i;
        double t_r;
        int i;
        int n = array.length;
        int ln = (int)(Math.log(n) / Math.log(2.0) + 0.5);
        int nv2 = n / 2;
        int j = 1;
        for (i = 1; i < n; ++i) {
            int k;
            if (i < j) {
                t_r = array[i - 1][0];
                t_i = array[i - 1][1];
                array[i - 1][0] = array[j - 1][0];
                array[i - 1][1] = array[j - 1][1];
                array[j - 1][0] = t_r;
                array[j - 1][1] = t_i;
            }
            for (k = nv2; k < j; j -= k, k /= 2) {
            }
            j += k;
        }
        for (int l = 1; l <= ln; ++l) {
            int le = (int)(Math.exp((double)l * Math.log(2.0)) + 0.5);
            int le1 = le / 2;
            double u_r = 1.0;
            double u_i = 0.0;
            double w_r = Math.cos(Math.PI / (double)le1);
            double w_i = -Math.sin(Math.PI / (double)le1);
            for (j = 1; j <= le1; ++j) {
                for (i = j; i <= n; i += le) {
                    int ip = i + le1;
                    t_r = array[ip - 1][0] * u_r - u_i * array[ip - 1][1];
                    t_i = array[ip - 1][1] * u_r + u_i * array[ip - 1][0];
                    array[ip - 1][0] = array[i - 1][0] - t_r;
                    array[ip - 1][1] = array[i - 1][1] - t_i;
                    array[i - 1][0] = array[i - 1][0] + t_r;
                    array[i - 1][1] = array[i - 1][1] + t_i;
                }
                t_r = u_r * w_r - w_i * u_i;
                u_i = w_r * u_i + w_i * u_r;
                u_r = t_r;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int n = (int)Math.pow(2.0, Integer.parseInt(args[0]));
        System.out.println("n: " + n);
        double[] oneD = new double[n * 2];
        int trials = 0;
        double timeOneD = 0.0;
        while (true) {
            System.out.println("trial: " + ++trials);
            CodeTimer ct0 = new CodeTimer("init");
            for (int i = 0; i < n; ++i) {
                double r;
                oneD[i * 2] = r = Math.random();
            }
            ct0.stop();
            CodeTimer ct1 = new CodeTimer("oneD");
            FFT.fft(oneD);
            ct1.stop(false);
            System.out.printf("1-d, last: %.3f, avg: %.3f\n", ct1.getRunTimeMillis(), (timeOneD += ct1.getRunTimeMillis()) / (double)trials);
        }
    }
}

