/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.director;

import edu.iris.Fissures.seed.builder.BuilderFilter;
import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.BlocketteFactory;
import edu.iris.Fissures.seed.container.SeedDictionaryReferenceMap;
import edu.iris.Fissures.seed.container.SeedObjectContainer;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.director.ExportDirector;
import edu.iris.Fissures.seed.exception.BuilderException;
import edu.iris.Fissures.seed.exception.ContainerException;
import edu.iris.Fissures.seed.exception.SeedException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class SeedExportDirector
extends ExportDirector {
    private Vector cacheLookup = null;
    private Vector cacheObject = null;
    private HashMap dictionarySequence = null;
    private HashMap dictionaryMap = null;
    private static final int[] responseBlockettes = new int[]{60, 53, 54, 61, 55, 56, 57, 58};
    private static final int responseBlkSize = responseBlockettes.length;
    private int lastResponseBlk = 0;
    private int parent50 = 0;
    private int parent52 = 0;
    private int parent999 = 0;

    public void fillTemplate(BuilderFilter templateFilter) throws Exception {
        if (this.expTemplate == null) {
            throw new BuilderException("template not assigned to director");
        }
        if (this.container == null) {
            throw new BuilderException("container not assigned to director");
        }
        if (templateFilter != null && !templateFilter.getType().equals("SEED")) {
            throw new BuilderException("indicated filter not of type SEED");
        }
        int[][] blkTypeList = new int[][]{{3, 50}, {4, 71, 72}, {5, 999}};
        Blockette blk = null;
        int i = 0;
        while (i < blkTypeList.length) {
            if (templateFilter != null) {
                Vector stations = templateFilter.getParameter("station");
                Vector channels = templateFilter.getParameter("channel");
                if (stations == null && channels == null) {
                    this.container.iterate(blkTypeList[i][0]);
                } else {
                    ((SeedObjectContainer)this.container).iterate(stations, channels, blkTypeList[i][0]);
                }
            } else {
                this.container.iterate(blkTypeList[i][0]);
            }
            block1: while ((blk = (Blockette)this.container.getNext()) != null) {
                int j = 1;
                while (j < blkTypeList[i].length) {
                    if (blk.getType() == blkTypeList[i][j] && this.filterBlockette(blk, templateFilter, 0)) {
                        int numChld = blk.numberofChildBlockettes();
                        int idx = 0;
                        while (idx < numChld) {
                            Blockette chld = blk.getChildBlockette(idx);
                            if (this.filterBlockette(chld, templateFilter, blk.getLookupId())) {
                                int numChld2 = chld.numberofChildBlockettes();
                                int idx2 = 0;
                                while (idx2 < numChld2) {
                                    Blockette chld2 = chld.getChildBlockette(idx2);
                                    this.filterBlockette(chld2, templateFilter, chld.getLookupId());
                                    ++idx2;
                                }
                            }
                            ++idx;
                        }
                        continue block1;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void startVolume() {
        this.cacheLookup = new Vector(8, 8);
        this.cacheObject = new Vector(8, 8);
        this.dictionarySequence = new HashMap();
        this.dictionaryMap = new HashMap();
        this.lastResponseBlk = 0;
        this.parent50 = 0;
        this.parent52 = 0;
        this.parent999 = 0;
    }

    protected Object getObject(int refNum) throws Exception {
        int blkType;
        Object nextObject = this.getFromCache(refNum);
        if (nextObject == null) {
            nextObject = this.container.get(refNum);
            if (nextObject != null) {
                Waveform waveform;
                this.cacheLookup = new Vector(8, 8);
                this.cacheObject = new Vector(8, 8);
                this.cacheLookup.add(new Integer(refNum));
                Blockette newBlockette = BlocketteFactory.createBlockette(((Blockette)nextObject).toString());
                newBlockette.setLookupId(refNum);
                int numLookups = ((Blockette)nextObject).numberofDictionaryLookups();
                int i = 0;
                while (i < numLookups) {
                    int lookupId = ((Blockette)nextObject).getDictionaryLookup(i + 1);
                    newBlockette.addDictionaryLookup(lookupId);
                    ++i;
                }
                this.resequence(newBlockette);
                this.cacheObject.add(newBlockette);
                this.cacheChildren((Blockette)nextObject);
                if (newBlockette.getType() == 999 && (waveform = ((Blockette)nextObject).getWaveform()) != null) {
                    byte[] wavebytes = waveform.getEncodedBytes();
                    byte[] newWavebytes = new byte[wavebytes.length];
                    System.arraycopy(wavebytes, 0, newWavebytes, 0, wavebytes.length);
                    newBlockette.attachWaveform(new Waveform(newWavebytes, 0, waveform.getNumSamples(), waveform.getEncoding(), waveform.getSwapBytes()));
                }
                nextObject = newBlockette;
            } else {
                throw new BuilderException("ERROR: unable to locate object for reference number " + refNum);
            }
        }
        if ((blkType = ((Blockette)nextObject).getType()) == 50) {
            this.parent50 = ((Blockette)nextObject).getLookupId();
        }
        if (blkType == 52) {
            this.parent52 = ((Blockette)nextObject).getLookupId();
        }
        if (blkType == 999) {
            this.parent999 = ((Blockette)nextObject).getLookupId();
        }
        return nextObject;
    }

    protected long getContext(int objType) throws BuilderException {
        int parentId = 0;
        if (objType == 51 || objType == 52) {
            parentId = this.parent50;
        } else if (objType > 52 && objType < 62) {
            parentId = this.parent52;
        } else if (objType > 99 && objType != 999) {
            parentId = this.parent999;
        }
        return this.generateContext(objType, parentId);
    }

    private Object getFromCache(int refNum) {
        int vectorSize = this.cacheLookup.size();
        int i = 0;
        while (i < vectorSize) {
            int lookupId = (Integer)this.cacheLookup.get(i);
            if (lookupId == refNum) {
                return this.cacheObject.get(i);
            }
            ++i;
        }
        return null;
    }

    private void cacheChildren(Blockette blk) throws BuilderException, SeedException {
        int numChildren = blk.numberofChildBlockettes();
        int i = 0;
        while (i < numChildren) {
            Blockette childBlk = blk.getChildBlockette(i);
            int refNum = childBlk.getLookupId();
            if (childBlk != null) {
                this.cacheLookup.add(new Integer(refNum));
                Blockette newBlockette = BlocketteFactory.createBlockette(childBlk.toString());
                newBlockette.setLookupId(refNum);
                int numLookups = childBlk.numberofDictionaryLookups();
                int j = 0;
                while (j < numLookups) {
                    int lookupId = childBlk.getDictionaryLookup(j + 1);
                    newBlockette.addDictionaryLookup(lookupId);
                    ++j;
                }
                this.resequence(newBlockette);
                this.cacheObject.add(newBlockette);
                this.cacheChildren(childBlk);
            }
            ++i;
        }
    }

    private void resequence(Blockette blk) throws BuilderException, SeedException {
        if (this.dictionarySequence == null) {
            throw new BuilderException("dictionarySequence map not initialized");
        }
        if (this.dictionaryMap == null) {
            throw new BuilderException("dictionaryMap not initialized");
        }
        int blkType = blk.getType();
        int[] srcFld = SeedDictionaryReferenceMap.lookupSourceFld(blkType);
        int i = 0;
        while (srcFld != null && i < srcFld.length) {
            StringTokenizer strTok = new StringTokenizer(blk.toString(srcFld[i]), "[], ");
            int listIndex = 0;
            while (strTok.hasMoreTokens()) {
                String strFieldVal = strTok.nextToken();
                int refVal = Integer.parseInt(strFieldVal);
                if (refVal <= 0) continue;
                Integer seqNum = null;
                int refId = blk.getDictionaryLookup(refVal);
                if (refId == 0) {
                    System.err.println("Warning: lookupId value = 0 for blkType = " + blkType + ", field = " + srcFld[i] + ", ref value = " + refVal);
                    seqNum = new Integer(0);
                } else {
                    seqNum = (Integer)this.dictionaryMap.get(new Integer(refId));
                }
                if (seqNum == null) {
                    int[] destBlk = SeedDictionaryReferenceMap.lookupDestBlk(blkType, srcFld[i]);
                    int j = 0;
                    while (destBlk != null && j < destBlk.length) {
                        seqNum = (Integer)this.dictionarySequence.get(new Integer(destBlk[j]));
                        seqNum = seqNum == null ? new Integer(1) : new Integer(seqNum + 1);
                        this.dictionarySequence.put(new Integer(destBlk[j]), seqNum);
                        ++j;
                    }
                    this.dictionaryMap.put(new Integer(refId), seqNum);
                }
                blk.setFieldVal(srcFld[i], listIndex, seqNum);
                ++listIndex;
            }
            ++i;
        }
        int destFld = SeedDictionaryReferenceMap.lookupDestFld(blkType);
        if (destFld > 0) {
            int lookupId = blk.getLookupId();
            Integer seqNum = (Integer)this.dictionaryMap.get(new Integer(lookupId));
            if (seqNum == null) {
                seqNum = (Integer)this.dictionarySequence.get(new Integer(blkType));
                seqNum = seqNum == null ? new Integer(1) : new Integer(seqNum + 1);
                this.dictionarySequence.put(new Integer(blkType), seqNum);
                this.dictionaryMap.put(new Integer(lookupId), seqNum);
            }
            blk.setFieldVal(destFld, seqNum);
        }
    }

    private boolean filterBlockette(Blockette blk, BuilderFilter templateFilter, int parentId) throws BuilderException, ContainerException {
        if (templateFilter == null || templateFilter.qualify(blk)) {
            int blkType = blk.getType();
            if (blkType == 50 && templateFilter != null && blk.numberofChildBlockettes() == 0) {
                return false;
            }
            long refId = this.generateContext(blkType, parentId);
            this.expTemplate.addRefNum(refId, blk.getLookupId());
            if (blkType == 52) {
                this.lastResponseBlk = 0;
            }
            if (blkType > 52 && blkType < 62 && blkType != 59) {
                while (responseBlockettes[this.lastResponseBlk] != blkType) {
                    refId = this.generateContext(responseBlockettes[this.lastResponseBlk], parentId);
                    this.expTemplate.addRefNum(refId, 0);
                    ++this.lastResponseBlk;
                    if (this.lastResponseBlk < responseBlkSize) continue;
                    this.lastResponseBlk = 0;
                }
                ++this.lastResponseBlk;
                if (this.lastResponseBlk >= responseBlkSize) {
                    this.lastResponseBlk = 0;
                }
            }
            int numLookups = blk.numberofDictionaryLookups();
            int k = 0;
            while (k < numLookups) {
                int dictLookupId = blk.getDictionaryLookup(k + 1);
                Blockette dictBlk = (Blockette)this.container.get(dictLookupId);
                if (dictBlk != null) {
                    refId = this.generateContext(dictBlk.getType(), 0);
                    this.expTemplate.addRefNum(refId, dictLookupId);
                }
                ++k;
            }
            return true;
        }
        return false;
    }

    public long generateContext(int childObjType, int parentId) throws BuilderException {
        try {
            if (parentId == 0) {
                return childObjType;
            }
            long contextRef = (long)childObjType * 10000000000L;
            return contextRef += (long)parentId;
        }
        catch (Exception e) {
            throw new BuilderException("(generateContext): " + e);
        }
    }
}

