/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.director;

import edu.iris.Fissures.seed.exception.BuilderException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ExportTemplate {
    protected HashMap refNumMap = new HashMap();
    protected HashMap uniqMap = new HashMap();

    public void addRefNum(long objType, int refNum) throws BuilderException {
        if (refNum < 0) {
            throw new BuilderException("illegal reference number: " + refNum + " for objType " + objType);
        }
        if (objType <= 0L) {
            throw new BuilderException("illegal object type: " + objType + " for refNum " + refNum);
        }
        if (refNum != 0 && this.uniqMap.containsKey(new Integer(refNum))) {
            return;
        }
        Vector<Integer> mapVec = (Vector<Integer>)this.refNumMap.get(new Long(objType));
        if (mapVec == null) {
            mapVec = new Vector<Integer>();
            mapVec.add(new Integer(1));
            this.refNumMap.put(new Long(objType), mapVec);
        }
        mapVec.add(new Integer(refNum));
        this.uniqMap.put(new Integer(refNum), new Integer(1));
    }

    public void reset() throws BuilderException {
        long[] objTypes = this.getObjectTypes();
        int objTypesSize = objTypes.length;
        int i = 0;
        while (i < objTypesSize) {
            Vector mapVec = (Vector)this.refNumMap.get(new Long(objTypes[i]));
            if (mapVec.size() > 0) {
                mapVec.set(0, new Integer(1));
            }
            ++i;
        }
    }

    public int getNext(long objType) throws BuilderException {
        if (objType <= 0L) {
            throw new BuilderException("illegal object type: " + objType);
        }
        Vector mapVec = (Vector)this.refNumMap.get(new Long(objType));
        if (mapVec == null) {
            return -1;
        }
        int nextIdx = (Integer)mapVec.get(0);
        if (nextIdx < 1) {
            throw new BuilderException("illegal refNum vector index: " + nextIdx);
        }
        int refNum = 0;
        if (nextIdx >= mapVec.size()) {
            refNum = -1;
        } else {
            refNum = Integer.parseInt(mapVec.get(nextIdx).toString());
            mapVec.set(0, new Integer(++nextIdx));
        }
        return refNum;
    }

    public long[] getObjectTypes() {
        Set mapEntries = this.refNumMap.entrySet();
        long[] returnTypes = new long[mapEntries.size()];
        Iterator mapIter = mapEntries.iterator();
        int typesIdx = 0;
        int returnSize = returnTypes.length;
        while (mapIter.hasNext() && typesIdx < returnSize) {
            Map.Entry entry = mapIter.next();
            long objType = (Long)entry.getKey();
            returnTypes[typesIdx++] = objType;
        }
        return returnTypes;
    }

    public void debugDump() {
        System.err.println("refNumMap debug dump:\n" + this.refNumMap.toString());
        System.err.println("uniqMap debug dump:\n" + this.uniqMap.toString());
    }
}

