/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.container;

import edu.iris.Fissures.seed.container.BlocketteFactory;
import edu.iris.Fissures.seed.container.BlocketteVector;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.SeedObject;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.exception.SeedException;
import edu.iris.Fissures.seed.exception.SeedFormatException;
import edu.iris.Fissures.seed.exception.SeedInputException;
import edu.iris.Fissures.seed.util.Utility;
import java.util.StringTokenizer;
import java.util.Vector;

public class Blockette
extends SeedObject {
    private Vector fieldValue;
    private BlocketteVector childBlockette;
    private Blockette parentBlockette;
    private Waveform waveformData;
    private Vector lookupMap;
    private int lookupId;
    private int blocketteType;
    private float version;
    private static final float minSEEDVersion = 2.0f;
    private static final float maxSEEDVersion = 2.4f;
    private static final float defaultSEEDVersion = BlocketteFactory.getDefaultVersion();
    private int numBytes;
    private boolean incompleteFlag;

    Blockette(byte[] blocketteStream, boolean swapFlag, boolean isData, float version) throws SeedException {
        this.initialize(blocketteStream, swapFlag, isData, version);
    }

    Blockette(int blkType) throws SeedException {
        int numFields = BlocketteFactory.getNumFields(blkType, Blockette.getDefaultVersion());
        String delimiter = "|";
        String blank = "^";
        StringBuffer inputStringBuf = new StringBuffer(String.valueOf(blkType));
        int i = 1;
        while (i < numFields) {
            inputStringBuf.append(delimiter);
            inputStringBuf.append(blank);
            ++i;
        }
        this.initialize(inputStringBuf.toString(), delimiter, blank);
    }

    Blockette(byte[] blocketteStream, boolean swapFlag, boolean isData) throws SeedException {
        this.initialize(blocketteStream, swapFlag, isData);
    }

    Blockette(String inputString, String delimiter, String blank, float version) throws SeedException {
        this.initialize(inputString, delimiter, blank, version);
    }

    Blockette(String inputString, String delimiter, String blank) throws SeedException {
        this.initialize(inputString, delimiter, blank);
    }

    Blockette(String inputString) throws SeedException {
        this.initialize(inputString);
    }

    Blockette(String inputString, float version) throws SeedException {
        this.initialize(inputString, version);
    }

    public void initialize(byte[] blocketteStream, boolean swapFlag, boolean isData, float version) throws SeedException {
        this.instanceInit();
        this.setVersion(version);
        this.numBytes = this.setByteStream(blocketteStream, swapFlag, isData);
        if (this.numBytes == 0) {
            this.incompleteFlag = true;
        }
    }

    public void initialize(byte[] blocketteStream, boolean swapFlag, boolean isData) throws SeedException {
        this.instanceInit();
        this.numBytes = this.setByteStream(blocketteStream, swapFlag, isData);
        if (this.numBytes == 0) {
            this.incompleteFlag = true;
        }
    }

    public void initialize(String inputString, String delimiter, String blank, float version) throws SeedException {
        this.instanceInit();
        this.setVersion(version);
        this.setTokenString(inputString, delimiter, blank);
    }

    public void initialize(String inputString, String delimiter, String blank) throws SeedException {
        this.instanceInit();
        this.setTokenString(inputString, delimiter, blank);
    }

    public void initialize(String inputString) throws SeedException {
        this.instanceInit();
        this.setTokenString(inputString, "|", "^");
    }

    public void initialize(String inputString, float version) throws SeedException {
        this.instanceInit();
        this.setVersion(version);
        this.setTokenString(inputString, "|", "^");
    }

    public void setValuesFrom(String inputString, String delimiter, String blank) throws SeedException {
        this.fieldValue = new Vector(8, 8);
        this.setTokenString(inputString, delimiter, blank);
    }

    public void setValuesFrom(String inputString) throws SeedException {
        this.setValuesFrom(inputString, "|", "^");
    }

    public int getType() {
        return this.blocketteType;
    }

    public float getVersion() throws SeedException {
        if (this.version < 2.0f || this.version > 2.4f) {
            throw new SeedException("Blockette version invalid");
        }
        return this.version;
    }

    public boolean isIncomplete() {
        return this.incompleteFlag;
    }

    public int getNumBytes() throws SeedException {
        try {
            return this.numBytes;
        }
        catch (Exception e) {
            throw new SeedException(e.toString());
        }
    }

    public String toString(int fieldNum, int fieldIndex) {
        try {
            Object fieldObj = this.getFieldVal(fieldNum, fieldIndex);
            if (fieldObj == null) {
                return new String("");
            }
            return BlocketteFactory.formatDecimal(this.getType(), fieldNum, fieldObj);
        }
        catch (SeedException e) {
            System.err.println("field " + fieldNum + ", fieldIndex " + fieldIndex + ": " + e);
            e.printStackTrace();
            return new String("");
        }
    }

    public String toString(int fieldNum) {
        return this.toString(fieldNum, 0);
    }

    public String toString(String delimiter, String blank) {
        int curField = 1;
        int fieldOffset = 0;
        try {
            StringBuffer outputStr = new StringBuffer("");
            int numFields = this.getNumFields();
            while (curField <= numFields) {
                int rptIndex;
                if (curField > 1) {
                    outputStr.append(delimiter);
                }
                if ((rptIndex = this.getFieldRepeat(curField)) > 0) {
                    Object rptVal = this.getFieldVal(rptIndex);
                    if (rptVal == null) {
                        throw new SeedException("Number of repeat fields is null: field num = " + rptIndex);
                    }
                    int rptSize = Integer.parseInt(rptVal.toString());
                    int grpSize = 0;
                    int i = 0;
                    while (i < rptSize) {
                        Vector grpVec = this.getFieldGrp(curField, i);
                        grpSize = grpVec.size();
                        int j = 0;
                        while (j < grpSize) {
                            if (j > 0 || i > 0) {
                                outputStr.append(delimiter);
                            }
                            fieldOffset = j;
                            String fmtStr = BlocketteFactory.formatDecimal(this.getType(), curField + j, grpVec.get(j));
                            if (fmtStr.length() == 0) {
                                fmtStr = new String(blank);
                            }
                            outputStr.append(fmtStr);
                            ++j;
                        }
                        ++i;
                    }
                    if (grpSize == 0) {
                        outputStr.append(blank);
                        ++curField;
                        continue;
                    }
                    curField += grpSize;
                    continue;
                }
                String fmtStr = this.toString(curField, 0);
                if (fmtStr.length() == 0) {
                    fmtStr = new String(blank);
                }
                outputStr.append(fmtStr);
                ++curField;
            }
            return outputStr.toString();
        }
        catch (SeedException e) {
            int fldNum = curField + fieldOffset;
            System.err.println("field " + fldNum + ": " + e);
            e.printStackTrace();
            return new String("");
        }
    }

    public String toString() {
        String delimiter = "|";
        String blank = "^";
        return this.toString(delimiter, blank);
    }

    public String getName() throws SeedException {
        return BlocketteFactory.getName(this.getType());
    }

    public String getCategory() throws SeedException {
        return BlocketteFactory.getCategory(this.getType());
    }

    public int getNumFields() throws SeedException {
        return BlocketteFactory.getNumFields(this.getType(), this.version);
    }

    public String getFieldName(int fieldNum) throws SeedException {
        return BlocketteFactory.getFieldName(this.getType(), fieldNum);
    }

    public String getFieldType(int fieldNum) throws SeedException {
        return BlocketteFactory.getFieldType(this.getType(), fieldNum);
    }

    public String getFieldLength(int fieldNum) throws SeedException {
        return BlocketteFactory.getFieldLength(this.getType(), fieldNum);
    }

    public String getFieldMask(int fieldNum) throws SeedException {
        return BlocketteFactory.getFieldMask(this.getType(), fieldNum);
    }

    public int getFieldRepeat(int fieldNum) throws SeedException {
        return BlocketteFactory.getFieldRepeat(this.getType(), fieldNum);
    }

    public String getDefinition() throws SeedException {
        return BlocketteFactory.getBlocketteDefinition(this.getType());
    }

    public Object getFieldVal(int fieldNum, int fieldIndex) throws SeedException {
        int maxFieldNum = this.fieldValue.size() - 1;
        if (fieldNum > maxFieldNum) {
            throw new SeedException("field number out of bounds (blktype = " + this.getType() + "max = " + maxFieldNum + ")");
        }
        Object fieldVal = this.fieldValue.get(fieldNum);
        if (fieldVal == null) {
            return null;
        }
        int repeatField = this.getFieldRepeat(fieldNum);
        if (repeatField > 0) {
            Vector fieldVec = (Vector)fieldVal;
            fieldVal = fieldIndex >= fieldVec.size() ? null : fieldVec.get(fieldIndex);
        }
        return fieldVal;
    }

    public Object getFieldVal(int fieldNum) throws SeedException {
        return this.getFieldVal(fieldNum, 0);
    }

    public Vector getFieldGrp(int fieldNum, int fieldIndex) throws SeedException {
        int numFields = this.getNumFields();
        if (fieldNum > numFields) {
            throw new SeedException("fieldNum is larger than the number of blockette fields (" + numFields + ")");
        }
        int repeatField = this.getFieldRepeat(fieldNum);
        if (repeatField == 0) {
            throw new SeedException("This field is not part of a repeat group");
        }
        Object rptVal = this.getFieldVal(repeatField);
        if (rptVal == null) {
            throw new SeedException("Number of repeat fields is null: field num = " + repeatField);
        }
        int grpSize = Integer.parseInt(rptVal.toString());
        if (fieldIndex > grpSize - 1) {
            throw new SeedException("fieldIndex is larger than the index of the last repeating field (" + new Integer(grpSize - 1) + ")");
        }
        Vector<Object> returnVector = new Vector<Object>();
        int i = 0;
        while (fieldNum + i <= numFields) {
            if (this.getFieldRepeat(fieldNum + i) == 0) break;
            Object fieldVal = this.getFieldVal(fieldNum + i, fieldIndex);
            returnVector.add(fieldVal);
            ++i;
        }
        return returnVector;
    }

    public String translate(int fieldNum) throws SeedException {
        return BlocketteFactory.getTranslation(this.getType(), fieldNum, this.getFieldVal(fieldNum));
    }

    public Blockette getChildBlockette(int index) {
        if (index + 1 > this.childBlockette.size()) {
            return null;
        }
        return (Blockette)this.childBlockette.get(index);
    }

    public int numberofChildBlockettes() {
        return this.childBlockette.size();
    }

    public boolean hasParent() {
        return this.parentBlockette != null;
    }

    public Blockette getParentBlockette() {
        return this.parentBlockette;
    }

    public Waveform getWaveform() {
        return this.waveformData;
    }

    public int getDictionaryLookup(int index) {
        if (index + 1 > this.lookupMap.size()) {
            return 0;
        }
        Object lookupObj = this.lookupMap.get(index);
        if (lookupObj == null) {
            return 0;
        }
        return Integer.parseInt(lookupObj.toString());
    }

    public int numberofDictionaryLookups() {
        return this.lookupMap.size() - 1;
    }

    public int getLookupId() {
        return this.lookupId;
    }

    public void setVersion(float ver) throws SeedException {
        if (ver < 2.0f || ver > 2.4f) {
            throw new SeedException("Blockette version invalid");
        }
        this.version = ver;
    }

    public void setFieldVal(int fieldNum, int fieldIndex, Object value, boolean lenient) throws SeedException {
        if (fieldNum == 1) {
            throw new SeedInputException("Cannot alter field number " + fieldNum);
        }
        if (value == null) {
            value = "";
        }
        String stringVal = value.toString();
        this.setFieldString(this.getType(), fieldNum, fieldIndex, stringVal, lenient);
        this.update();
    }

    public void setFieldVal(int fieldNum, int fieldIndex, Object value) throws SeedException {
        this.setFieldVal(fieldNum, fieldIndex, value, true);
    }

    public void setFieldVal(int fieldNum, Object value) throws SeedException {
        this.setFieldVal(fieldNum, 0, value);
    }

    public void addFieldGrp(int fieldNum, Vector valueVec) throws SeedException {
        int repeatField = this.getFieldRepeat(fieldNum);
        if (repeatField == 0) {
            throw new SeedInputException("Blockette field " + fieldNum + " not listed as a repeating field");
        }
        int numFields = this.getNumFields();
        int curRepeatField = repeatField;
        int lastField = fieldNum;
        while (curRepeatField == repeatField) {
            if (++lastField > numFields) break;
            curRepeatField = this.getFieldRepeat(lastField);
        }
        int grpSize = lastField - fieldNum;
        if (valueVec.size() != grpSize) {
            throw new SeedInputException("invalid Vector size " + valueVec.size() + " (need " + grpSize + ")");
        }
        int fSize = 0;
        int i = 0;
        while (i < grpSize) {
            Vector tmpVec = (Vector)this.fieldValue.get(fieldNum + i);
            if (tmpVec == null) {
                this.fieldValue.set(fieldNum + i, new Vector(1, 1));
                tmpVec = (Vector)this.fieldValue.get(fieldNum + i);
            }
            fSize = tmpVec.size();
            String stringVal = valueVec.get(i).toString();
            this.setFieldString(this.getType(), fieldNum + i, fSize, stringVal);
            ++i;
        }
        String stringVal = Integer.toString(fSize + 1);
        this.setFieldString(this.getType(), repeatField, 0, stringVal);
        this.update();
    }

    public void insertFieldGrp(int fieldNum, int fieldIndex, Vector valueVec) throws SeedException {
        int repeatField = this.getFieldRepeat(fieldNum);
        if (repeatField == 0) {
            throw new SeedInputException("Blockette field " + fieldNum + " not listed as a repeating field");
        }
        int numFields = this.getNumFields();
        int curRepeatField = repeatField;
        int lastField = fieldNum;
        while (curRepeatField == repeatField) {
            if (++lastField > numFields) break;
            curRepeatField = this.getFieldRepeat(lastField);
        }
        int grpSize = lastField - fieldNum;
        if (valueVec.size() != grpSize) {
            throw new SeedInputException("invalid Vector size " + valueVec.size() + " (need " + grpSize + ")");
        }
        int fSize = 0;
        int i = 0;
        while (i < grpSize) {
            Vector tmpVec = (Vector)this.fieldValue.get(fieldNum + i);
            if (tmpVec == null) {
                this.fieldValue.set(fieldNum + i, new Vector(1, 1));
                tmpVec = (Vector)this.fieldValue.get(fieldNum + i);
            }
            fSize = tmpVec.size();
            String stringVal = valueVec.get(i).toString();
            if (fSize == 0 || fieldIndex >= fSize) {
                this.setFieldString(this.getType(), fieldNum + i, fSize, stringVal);
            } else {
                Object copyObj = tmpVec.get(fieldIndex);
                tmpVec.insertElementAt(copyObj, fieldIndex);
                this.setFieldString(this.getType(), fieldNum + i, fieldIndex, stringVal);
            }
            ++i;
        }
        String stringVal = Integer.toString(fSize + 1);
        this.setFieldString(this.getType(), repeatField, 0, stringVal);
        this.update();
    }

    public void deleteFieldGrp(int fieldNum, int fieldIndex) throws SeedException {
        int repeatField = this.getFieldRepeat(fieldNum);
        if (repeatField == 0) {
            throw new SeedInputException("Blockette field " + fieldNum + " not listed as a repeating field");
        }
        int numFields = this.getNumFields();
        int curRepeatField = repeatField;
        int lastField = fieldNum;
        while (curRepeatField == repeatField) {
            if (++lastField > numFields) break;
            curRepeatField = this.getFieldRepeat(lastField);
        }
        int grpSize = lastField - fieldNum;
        int fSize = 0;
        int i = 0;
        while (i < grpSize) {
            Vector tmpVec = (Vector)this.fieldValue.get(fieldNum + i);
            if (tmpVec == null) {
                this.fieldValue.set(fieldNum + i, new Vector(1, 1));
                tmpVec = (Vector)this.fieldValue.get(fieldNum + i);
            }
            if ((fSize = tmpVec.size()) == 0) {
                return;
            }
            if (fieldIndex >= fSize) {
                tmpVec.remove(fSize - 1);
            } else {
                tmpVec.remove(fieldIndex);
            }
            ++i;
        }
        String stringVal = Integer.toString(fSize - 1);
        this.setFieldString(this.getType(), repeatField, 0, stringVal);
        this.update();
    }

    public int addChildBlockette(Blockette addBlockette) {
        this.childBlockette.add(addBlockette);
        return this.childBlockette.size() - 1;
    }

    public void removeChildBlockette(int index) {
        this.childBlockette.remove(index);
    }

    public void replaceChildBlockette(int index, Blockette newBlockette) {
        this.childBlockette.set(index, newBlockette);
    }

    public void attachParent(Blockette parent) {
        this.parentBlockette = parent;
    }

    public void removeParent() {
        this.parentBlockette = null;
    }

    public void attachWaveform(Waveform data) {
        this.waveformData = data;
    }

    public void removeWaveform() {
        this.waveformData = null;
    }

    public int addDictionaryLookup(int abbrevLookupId) {
        if (this.lookupMap.size() == 0) {
            this.lookupMap.add(new Integer(0));
        }
        this.lookupMap.add(new Integer(abbrevLookupId));
        return this.lookupMap.size() - 1;
    }

    public int addDictionaryLookupIfNeeded(int abbrevLookupId) {
        if (this.lookupMap.size() == 0) {
            this.lookupMap.add(new Integer(0));
        }
        int lucount = this.numberofDictionaryLookups();
        int curid = -1;
        int i = 1;
        while (i <= lucount) {
            curid = this.getDictionaryLookup(i);
            if (curid == abbrevLookupId) {
                return i;
            }
            ++i;
        }
        return this.addDictionaryLookup(abbrevLookupId);
    }

    public void setDictionaryLookup(int index, int abbrevLookupId) {
        if (index >= this.lookupMap.size()) {
            this.lookupMap.setSize(index + 1);
        }
        this.lookupMap.set(index, new Integer(abbrevLookupId));
    }

    public void setLookupId(int idValue) {
        this.lookupId = idValue;
    }

    public Btime getMTime() {
        return (Btime)this.fieldValue.get(0);
    }

    public static float getDefaultVersion() {
        return defaultSEEDVersion;
    }

    private int setByteStream(byte[] blocketteStream, boolean swapFlag, boolean isData) throws SeedException {
        int curField = 0;
        int fldCount = 0;
        int arrIndex = 0;
        int indexCount = 0;
        int indexCountStart = 0;
        int rptGrpStart = 0;
        int blkType = 0;
        int bInt = 0;
        String blkStr = "";
        String fldType = "";
        int suggestBytes = 0;
        while (arrIndex <= blocketteStream.length) {
            if (suggestBytes > 0 && arrIndex >= suggestBytes) break;
            if (++curField == 1) {
                blkStr = null;
                int indexIncrement = 0;
                if (isData) {
                    if (blocketteStream.length - arrIndex < 2) {
                        this.incompleteFlag = true;
                        return blocketteStream.length;
                    }
                    byte[] sampArr = new byte[2];
                    System.arraycopy(blocketteStream, arrIndex, sampArr, 0, 2);
                    bInt = Utility.uBytesToInt(sampArr[0], sampArr[1], swapFlag);
                    blkStr = Integer.toString(bInt);
                    indexIncrement = 2;
                } else {
                    if (blocketteStream.length - arrIndex < 3) {
                        this.incompleteFlag = true;
                        return blocketteStream.length;
                    }
                    blkStr = new String(blocketteStream, arrIndex, 3);
                    indexIncrement = 3;
                }
                boolean retryLoop = false;
                int d = 0;
                while (d < blkStr.length()) {
                    char a = blkStr.charAt(d);
                    if (!(Character.isDigit(a) || a == ' ' && d + 1 < blkStr.length())) {
                        System.err.println("WARNING: encountered odd character where expecting blockette type: '" + a + "'.");
                        System.err.println("LOCATION: " + new String(blocketteStream, arrIndex, blocketteStream.length));
                        System.err.println("CORRECTION: retry reading SEED record, byte shifted by one.");
                        indexIncrement = 1;
                        --curField;
                        retryLoop = true;
                        break;
                    }
                    ++d;
                }
                arrIndex += indexIncrement;
                if (retryLoop) continue;
                try {
                    blkType = Integer.parseInt(blkStr.trim());
                }
                catch (Exception e) {
                    throw new SeedInputException("ERROR in reading next blockette type from string: '" + blkStr + "' in byte stream: " + new String(blocketteStream, 0, blocketteStream.length));
                }
                float blkVer = BlocketteFactory.getVersion(blkType);
                if (blkVer > this.version) {
                    throw new SeedInputException("blockette type " + blkType + " is a version " + blkVer + " blockette");
                }
                fldCount = BlocketteFactory.getNumFields(blkType, this.version);
                this.fieldValue.setSize(fldCount + 1);
            } else {
                int i;
                int fldRpt;
                if (curField > fldCount) {
                    if (indexCount < 2) break;
                    --indexCount;
                    curField = rptGrpStart;
                }
                if ((fldRpt = BlocketteFactory.getFieldRepeat(blkType, curField)) > 0) {
                    if (this.fieldValue.get(curField) == null) {
                        this.fieldValue.set(curField, new Vector(1, 1));
                    }
                    if (indexCount == 0) {
                        indexCountStart = indexCount = Integer.parseInt(this.fieldValue.get(fldRpt).toString());
                        rptGrpStart = curField;
                        if (indexCountStart == 0) {
                            continue;
                        }
                    }
                } else if (indexCount > 0) {
                    if (--indexCount > 0) {
                        curField = rptGrpStart;
                    } else {
                        indexCountStart = 0;
                    }
                }
                if (arrIndex == blocketteStream.length) {
                    this.incompleteFlag = true;
                    break;
                }
                fldType = BlocketteFactory.getFieldType(blkType, curField);
                String fldLen = BlocketteFactory.getFieldLength(blkType, curField);
                if (fldType.equals("L")) {
                    Vector<Integer> listVec = new Vector<Integer>();
                    int rptFld = BlocketteFactory.getFieldRepeat(blkType, curField);
                    Vector fieldVec = (Vector)this.fieldValue.get(rptFld);
                    if (fieldVec == null) {
                        this.fieldValue.set(rptFld, new Vector(1, 1));
                        fieldVec = (Vector)this.fieldValue.get(rptFld);
                    }
                    int numValues = Integer.parseInt(fieldVec.get(indexCountStart - indexCount).toString());
                    i = 0;
                    while (i < numValues) {
                        int intLen = Integer.parseInt(fldLen);
                        if (intLen > blocketteStream.length - arrIndex) {
                            this.incompleteFlag = true;
                            break;
                        }
                        String sampStr = new String(blocketteStream, arrIndex, intLen);
                        Integer intVal = new Integer(sampStr);
                        listVec.add(intVal);
                        arrIndex += intLen;
                        ++i;
                    }
                    blkStr = listVec.toString();
                } else if (fldType.equals("V")) {
                    String sampStr;
                    int endIndex;
                    StringTokenizer tok = new StringTokenizer(fldLen, "-");
                    String sLen = tok.nextToken();
                    sLen = tok.nextToken();
                    int intLen = Integer.parseInt(sLen);
                    if (intLen >= blocketteStream.length - arrIndex) {
                        intLen = blocketteStream.length - arrIndex - 1;
                    }
                    if ((endIndex = (sampStr = new String(blocketteStream, arrIndex, intLen + 1)).indexOf("~")) == -1) {
                        if (intLen < Integer.parseInt(sLen)) {
                            this.incompleteFlag = true;
                            break;
                        }
                        Object lenObj = this.fieldValue.get(2);
                        if (lenObj == null) {
                            this.incompleteFlag = true;
                            break;
                        }
                        int blkLen = Integer.parseInt(lenObj.toString());
                        if (blkLen > blocketteStream.length - arrIndex) {
                            blkLen = blocketteStream.length - arrIndex;
                        }
                        if ((endIndex = (sampStr = new String(blocketteStream, arrIndex, blkLen)).indexOf("~", arrIndex)) == -1) {
                            if (blkLen < Integer.parseInt(lenObj.toString())) {
                                this.incompleteFlag = true;
                                break;
                            }
                            endIndex = blkLen - 1;
                        }
                    }
                    blkStr = sampStr.substring(0, endIndex);
                    arrIndex += endIndex + 1;
                } else if (fldType.equals("B")) {
                    String fldMask = BlocketteFactory.getFieldMask(blkType, curField);
                    int intLen = Integer.parseInt(fldLen);
                    if (intLen > blocketteStream.length - arrIndex) {
                        this.incompleteFlag = true;
                        break;
                    }
                    byte[] sampArr = new byte[intLen];
                    System.arraycopy(blocketteStream, arrIndex, sampArr, 0, intLen);
                    if (fldMask.equals("BTIME")) {
                        Btime bTime = new Btime(sampArr, swapFlag);
                        blkStr = bTime.getStringTime();
                    } else if (fldMask.equals("FLOAT")) {
                        bInt = Utility.bytesToInt(sampArr[0], sampArr[1], sampArr[2], sampArr[3], swapFlag);
                        Float bFloat = new Float(Float.intBitsToFloat(bInt));
                        blkStr = bFloat.toString();
                    } else if (fldMask.equals("UBYTE") || fldMask.equals("BYTE")) {
                        StringBuffer sbuf = new StringBuffer();
                        i = 0;
                        while (i < sampArr.length) {
                            if (i > 0) {
                                sbuf.append(" ");
                            }
                            bInt = fldMask.equals("UBYTE") ? Utility.uBytesToInt(sampArr[i]) : Utility.bytesToInt(sampArr[i]);
                            sbuf.append(Integer.toString(bInt));
                            ++i;
                        }
                        blkStr = sbuf.toString();
                    } else if (fldMask.equals("WORD") || fldMask.equals("UWORD")) {
                        bInt = fldMask.equals("UWORD") ? Utility.uBytesToInt(sampArr[0], sampArr[1], swapFlag) : Utility.bytesToInt(sampArr[0], sampArr[1], swapFlag);
                        blkStr = Integer.toString(bInt);
                    } else if (fldMask.equals("LONG") || fldMask.equals("ULONG")) {
                        if (fldMask.equals("ULONG")) {
                            long bLong = Utility.uBytesToLong(sampArr[0], sampArr[1], sampArr[2], sampArr[3], swapFlag);
                            blkStr = Long.toString(bLong);
                        } else {
                            bInt = Utility.bytesToInt(sampArr[0], sampArr[1], sampArr[2], sampArr[3], swapFlag);
                            blkStr = Integer.toString(bInt);
                        }
                    } else {
                        throw new SeedInputException("unrecognized field mask: " + fldMask);
                    }
                    arrIndex += intLen;
                } else {
                    int intLen = Integer.parseInt(fldLen);
                    if (intLen > blocketteStream.length - arrIndex) {
                        this.incompleteFlag = true;
                        break;
                    }
                    blkStr = new String(blocketteStream, arrIndex, intLen);
                    if (curField == 2 && !isData && blocketteStream.length >= 7) {
                        suggestBytes = Integer.parseInt(blkStr.trim());
                    }
                    arrIndex += intLen;
                }
            }
            this.setFieldString(blkType, curField, indexCountStart - indexCount, blkStr);
        }
        if ((curField < fldCount || indexCount > 1) && arrIndex < suggestBytes) {
            this.incompleteFlag = true;
        }
        this.update();
        return arrIndex;
    }

    /*
     * Unable to fully structure code
     */
    private void setFieldString(int blkType, int fieldNum, int fieldIndex, String addVal, boolean lenient) throws SeedException {
        block77: {
            fldType = BlocketteFactory.getFieldType(blkType, fieldNum);
            fldMask = BlocketteFactory.getFieldMask(blkType, fieldNum);
            fldLen = BlocketteFactory.getFieldLength(blkType, fieldNum);
            fldRpt = BlocketteFactory.getFieldRepeat(blkType, fieldNum);
            isRepeating = fldRpt > 0;
            v0 = isBlank = addVal.length() == 0;
            if (isBlank) {
                if (isRepeating && fieldIndex == 0) {
                    this.fieldValue.set(fieldNum, new Vector<E>(1, 1));
                } else {
                    this.fieldValue.set(fieldNum, null);
                }
                return;
            }
            addTrim = addVal.trim();
            if (addTrim.length() > 0) {
                addVal = addTrim;
            }
            if (fldMask.charAt(0) == '\"') {
                try {
                    if (addTrim.length() != 0) ** GOTO lbl96
                    addVal = new String("0");
                }
                catch (NumberFormatException e) {
                    throw new SeedFormatException("Encountered NumberFormatException for blockette " + blkType + ", field " + fieldNum + ", value '" + addVal + "'");
                }
            } else if (fldMask.charAt(0) == '[') {
                testUpper = false;
                testLower = false;
                testDigit = false;
                testPunct = false;
                testSpace = false;
                testUnder = false;
                allowAll = true;
                i = 1;
                while (i < fldMask.length() && (c = fldMask.charAt(i)) != ']') {
                    allowAll = false;
                    switch (e) {
                        case 85: {
                            testUpper = true;
                            break;
                        }
                        case 76: {
                            testLower = true;
                            break;
                        }
                        case 78: {
                            testDigit = true;
                            break;
                        }
                        case 80: {
                            testPunct = true;
                            break;
                        }
                        case 83: {
                            testSpace = true;
                            break;
                        }
                        case 95: {
                            testUnder = true;
                        }
                    }
                    ++i;
                }
                i = 0;
                while (!allowAll && i < addVal.length()) {
                    a = addVal.charAt(i);
                    if (!(testUpper && Character.isUpperCase(a) || testLower && Character.isLowerCase(a) || testDigit && Character.isDigit(a) || testPunct && this.isPunctuation(a) || testSpace && a == ' ' || testUnder && a == '_')) {
                        exString = new StringBuffer();
                        charByte = new Byte((byte)a);
                        exString.append("character '" + a + "' (value=" + charByte.intValue() + ") is not acceptable for Blockette " + blkType + " field " + fieldNum + "\nExpected one of:\n");
                        substitute = ' ';
                        if (testUpper) {
                            exString.append("\tUpperCase\n");
                            substitute = 'Z';
                        }
                        if (testLower) {
                            exString.append("\tLowerCase\n");
                            substitute = 'z';
                        }
                        if (testDigit) {
                            exString.append("\tDigit\n");
                            substitute = '0';
                        }
                        if (testPunct) {
                            exString.append("\tPunctuation\n");
                            substitute = '.';
                        }
                        if (testUnder) {
                            exString.append("\tUnderscore\n");
                            substitute = '_';
                        }
                        if (testSpace) {
                            exString.append("\tSpace\n");
                        }
                        if (lenient) {
                            System.err.println("WARNING: " + exString.toString());
                            System.err.println("CORRECTION: substituting with character '" + substitute + "'");
                            addVal = newVal = addVal.replace(a, substitute);
                        } else {
                            throw new SeedInputException(exString.toString());
                        }
                    }
                    ++i;
                }
            }
lbl96:
            // 5 sources

            fvIndex = 0;
            fvVec = null;
            if (isRepeating) {
                fvVec = (Vector)this.fieldValue.get(fieldNum);
                if (fvVec == null) {
                    this.fieldValue.set(fieldNum, new Vector<E>(1, 1));
                    fvVec = (Vector)this.fieldValue.get(fieldNum);
                }
                if (fvVec.size() < fieldIndex + 1) {
                    fvVec.setSize(fieldIndex + 1);
                }
                fvIndex = fieldIndex;
            } else {
                fvVec = this.fieldValue;
                fvIndex = fieldNum;
            }
            try {
                if (fldType.equals("L")) {
                    if (addVal.charAt(0) != '[') {
                        addVal = "[" + addVal + "]";
                    }
                    listTok = new StringTokenizer(addVal, "[], ");
                    listVec = new Vector<Integer>();
                    while (listTok.hasMoreTokens()) {
                        try {
                            listVec.add(new Integer(listTok.nextToken()));
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Error with Integer list value for fieldNum=" + fieldNum + " and fieldIndex=" + fieldIndex + ": forcing value of zero");
                            System.err.println("blktype=" + this.getType() + ", value=" + addVal);
                            listVec.add(new Integer(0));
                        }
                    }
                    fvVec.set(fvIndex, listVec);
                    break block77;
                }
                if (fldType.equals("A")) {
                    intLen = Integer.parseInt(fldLen);
                    if (intLen < addVal.length()) {
                        addVal = trimVal = addVal.substring(0, intLen);
                    }
                    fvVec.set(fvIndex, addVal);
                    break block77;
                }
                if (fldType.equals("D")) {
                    if (fldMask.indexOf(46) > 0) {
                        try {
                            fvVec.set(fvIndex, new Double(addVal));
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Error with Double field value for fieldNum=" + fieldNum + " and fieldIndex=" + fieldIndex + ": forcing value of zero");
                            System.err.println("blktype=" + this.getType() + ", value=" + addVal);
                            fvVec.set(fvIndex, new Double(0.0));
                        }
                    } else {
                        try {
                            fvVec.set(fvIndex, new Integer(addVal));
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Error with Integer field value for fieldNum=" + fieldNum + " and fieldIndex=" + fieldIndex + ": forcing value of zero");
                            System.err.println("blktype=" + this.getType() + ", value=" + addVal);
                            fvVec.set(fvIndex, new Integer(0));
                        }
                    }
                    break block77;
                }
                if (fldType.equals("F")) {
                    try {
                        fvVec.set(fvIndex, new Double(addVal));
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Error with Double field value for fieldNum=" + fieldNum + " and fieldIndex=" + fieldIndex + ": forcing value of zero");
                        System.err.println("blktype=" + this.getType() + ", value=" + addVal);
                        fvVec.set(fvIndex, new Double(0.0));
                    }
                    break block77;
                }
                if (fldType.equals("V")) {
                    tok = new StringTokenizer(fldLen, "-");
                    sLen = tok.nextToken();
                    sLen = tok.nextToken();
                    intLen = Integer.parseInt(sLen);
                    if (intLen < addVal.length()) {
                        addVal = trimVal = addVal.substring(0, intLen);
                    }
                    if (fldMask.equals("TIME")) {
                        bTime = new Btime(addVal);
                        fvVec.set(fvIndex, bTime);
                    } else {
                        fvVec.set(fvIndex, addVal);
                    }
                    break block77;
                }
                if (fldType.equals("B")) {
                    if (fldMask.equals("BTIME")) {
                        bTime = new Btime(addVal);
                        fvVec.set(fvIndex, bTime);
                    } else if (fldMask.equals("UBYTE")) {
                        intLen = Integer.parseInt(fldLen);
                        tok = new StringTokenizer(addVal, " ");
                        while (intLen > 0 && tok.hasMoreTokens()) {
                            tokVal = tok.nextToken();
                            byteVal = Integer.parseInt(tokVal);
                            if (byteVal < 0 || byteVal > 255) {
                                throw new SeedInputException("input value " + tokVal + " exceeds UBYTE value boundary");
                            }
                            --intLen;
                        }
                        if (intLen > 0) {
                            throw new SeedInputException("not enough UBYTEs in String entry (need " + fldLen + ")");
                        }
                        fvVec.set(fvIndex, addVal);
                    } else if (fldMask.equals("BYTE")) {
                        intLen = Integer.parseInt(fldLen);
                        tok = new StringTokenizer(addVal, " ");
                        while (intLen > 0 && tok.hasMoreTokens()) {
                            tokVal = tok.nextToken();
                            byteVal = Integer.parseInt(tokVal);
                            if (byteVal < -128 || byteVal > 127) {
                                throw new SeedInputException("input value " + tokVal + " exceeds BYTE value boundary");
                            }
                            --intLen;
                        }
                        if (intLen > 0) {
                            throw new SeedInputException("not enough BYTEs in String entry (need " + fldLen + ")");
                        }
                        fvVec.set(fvIndex, addVal);
                    } else if (fldMask.equals("UWORD")) {
                        wordVal = Integer.parseInt(addVal);
                        if (wordVal < 0 || wordVal > 65535) {
                            throw new SeedInputException("input value " + addVal + " exceeds UWORD value boundary");
                        }
                        fvVec.set(fvIndex, new Integer(wordVal));
                    } else if (fldMask.equals("WORD")) {
                        wordVal = Integer.parseInt(addVal);
                        if (wordVal < -32768 || wordVal > 32767) {
                            throw new SeedInputException("input value " + addVal + " exceeds WORD value boundary");
                        }
                        fvVec.set(fvIndex, new Integer(wordVal));
                    } else if (fldMask.equals("ULONG") || fldMask.equals("LONG")) {
                        fvVec.set(fvIndex, new Long(addVal));
                    } else if (fldMask.equals("FLOAT")) {
                        fvVec.set(fvIndex, new Float(addVal));
                    }
                    break block77;
                }
                throw new SeedInputException("unknown blockette " + blkType + " field type: " + fldType);
            }
            catch (Exception e) {
                throw new SeedException("Exception encountered for blockette type " + blkType + " and field number " + fieldNum + "and field index " + fieldIndex + ": " + e);
            }
        }
    }

    private void setFieldString(int blkType, int fieldNum, int fieldIndex, String addVal) throws SeedException {
        this.setFieldString(blkType, fieldNum, fieldIndex, addVal, true);
    }

    private void setTokenString(String inputString, String delimiter, String blank) throws SeedException {
        StringTokenizer tn = new StringTokenizer(inputString, delimiter);
        int curField = 0;
        int fldCount = 0;
        int indexCount = 0;
        int indexCountStart = 0;
        int rptGrpStart = 0;
        int blkType = 0;
        while (tn.hasMoreTokens()) {
            int fldRpt;
            String addVal = tn.nextToken();
            if (++curField == 1) {
                blkType = Integer.parseInt(addVal);
                float blkVer = BlocketteFactory.getVersion(blkType);
                if (blkVer > this.version) {
                    throw new SeedInputException("blockette type " + blkType + " is a version " + blkVer + " blockette");
                }
                fldCount = BlocketteFactory.getNumFields(blkType, this.version);
                this.fieldValue.setSize(fldCount + 1);
            } else if (curField > fldCount) {
                if (indexCount < 2) {
                    throw new SeedInputException("input string has too many fields for blockette " + blkType);
                }
                --indexCount;
                curField = rptGrpStart;
            }
            if (addVal.equals(blank)) {
                addVal = new String("");
            }
            if ((fldRpt = BlocketteFactory.getFieldRepeat(blkType, curField)) > 0) {
                if (this.fieldValue.get(curField) == null) {
                    this.fieldValue.set(curField, new Vector(1, 1));
                }
                if (indexCount == 0) {
                    indexCountStart = indexCount = Integer.parseInt(this.fieldValue.get(fldRpt).toString());
                    rptGrpStart = curField;
                }
            } else if (indexCount > 0) {
                if (--indexCount > 0) {
                    curField = rptGrpStart;
                } else {
                    indexCountStart = 0;
                }
            }
            this.setFieldString(blkType, curField, indexCountStart - indexCount, addVal);
        }
        if (curField < fldCount || indexCount > 1) {
            this.incompleteFlag = true;
        }
        this.update();
    }

    private boolean isPunctuation(char c) {
        return c > ' ' && c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z' && c < '\u007f';
    }

    private void update() throws SeedException {
        this.blocketteType = Integer.parseInt(this.fieldValue.get(1).toString());
        this.resetMTime();
    }

    private void resetMTime() throws SeedException {
        Btime mTime = new Btime();
        this.fieldValue.set(0, mTime);
    }

    private void instanceInit() {
        this.fieldValue = new Vector(8, 8);
        this.childBlockette = new BlocketteVector(1, 1);
        this.parentBlockette = null;
        this.waveformData = null;
        this.lookupMap = new Vector(1, 1);
        this.lookupId = 0;
        this.blocketteType = 0;
        this.version = BlocketteFactory.getDefaultVersion();
        this.numBytes = 0;
        this.incompleteFlag = false;
    }
}

