CFLAGS = -O ${GLOBALFLAGS}

B = $(EW_HOME)/$(EW_VERSION)/bin
L = $(EW_HOME)/$(EW_VERSION)/lib

LIBS = -lm -lposix4 -lthread -lnsl -lsocket

EW_LIBS = $L/logit_mt.o \
		$L/kom.o \
		$L/threads_ew.o \
		$L/time_ew.o \
		$L/transport.o \
		$L/sleep_ew.o \
		$L/getutil.o \
		$L/sema_ew.o \
		$L/ws_clientII.o \
       $L/mem_circ_queue.o \
		$L/socket_ew_common.o \
		$L/socket_ew.o \
		$L/swap.o \
		$L/ew_spectra_io.o

OBJS = ewspectra.o \
       iir.o

OBJSc = activate_module.o

OBJSs = sniffspectra.o

all: ewspectra activate_module sniffspectra

ewspectra: $(OBJS) $(EW_LIBS)
	$(CC) $(CFLAGS) -o $B/ewspectra  $L/ws2ts.o $(OBJS) $(EW_LIBS) $(LIBS)

activate_module: $(OBJSc) $(EW_LIBS)
	$(CC) $(CFLAGS) -o $B/activate_module $(OBJSc) $(EW_LIBS) $(LIBS)

sniffspectra: $(OBJSs) $(EW_LIBS)
	$(CC) $(CFLAGS) -o $B/sniffspectra $(OBJSs) $(EW_LIBS) $(LIBS)

lint:
	lint ewspectra.c iir.c activate_module.c sniffspectra.c \
			$(GLOBALFLAGS)

# Clean-up rules
clean:
	rm -f a.out core *.o *.obj *% *~

clean_bin:
	rm -f $B/ewspectra $B/activate_module $B/sniffspectra


.c.o:
	$(CC) -c ${CFLAGS} $<

