/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.model;

import edu.iris.Fissures.Unit;
import edu.iris.Fissures.UnitRange;
import edu.iris.Fissures.model.UnitImpl;
import java.io.Serializable;

public class UnitRangeImpl
extends UnitRange {
    protected UnitRangeImpl() {
    }

    public static Serializable createEmpty() {
        return new UnitRangeImpl();
    }

    public UnitRangeImpl(double min, double max, Unit the_units) {
        if (the_units == null) {
            throw new IllegalArgumentException("Unit must not be null.");
        }
        if (min > max) {
            throw new IllegalArgumentException("min > max");
        }
        this.min_value = min;
        this.max_value = max;
        this.the_units = the_units;
    }

    public double getMinValue() {
        return this.min_value;
    }

    public double getMaxValue() {
        return this.max_value;
    }

    public UnitImpl getUnit() {
        return (UnitImpl)this.the_units;
    }

    public UnitRangeImpl convertTo(UnitImpl newUnit) {
        UnitImpl currUnit = this.getUnit();
        if (newUnit.equals((Object)currUnit)) {
            return this;
        }
        if (!currUnit.isConvertableTo(newUnit)) {
            throw new IllegalArgumentException("Cannot convert, units are not compatible");
        }
        double mulfac = currUnit.getTotalMultiFactor() / newUnit.getTotalMultiFactor();
        int powerDiff = currUnit.getTotalPower() - newUnit.getTotalPower();
        double newMinValue = this.getMinValue() * mulfac * Math.pow(10.0, powerDiff);
        double newMaxValue = this.getMaxValue() * mulfac * Math.pow(10.0, powerDiff);
        return new UnitRangeImpl(newMinValue, newMaxValue, newUnit);
    }

    public String toString() {
        return "(" + this.getMinValue() + "," + this.getMaxValue() + ") " + (Object)((Object)this.getUnit());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UnitRangeImpl) {
            UnitRange oRange = (UnitRange)o;
            return oRange.min_value == this.min_value && oRange.max_value == this.max_value && this.the_units.equals(oRange.the_units);
        }
        return false;
    }

    public int hashCode() {
        int result = 123;
        long minBits = Double.doubleToLongBits(this.min_value);
        result = (int)(minBits ^ minBits >>> 32) + 37 * result;
        long maxBits = Double.doubleToLongBits(this.max_value);
        result = (int)(maxBits ^ maxBits >>> 32) + 37 * result;
        return this.getUnit().hashCode() + result * 37;
    }
}

