/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data;

import gov.usgs.swarm.Images;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.data.DHIDataSource;
import gov.usgs.swarm.data.DirectWWSSource;
import gov.usgs.swarm.data.FullSeedDataSource;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.swarm.data.SACDataSource;
import gov.usgs.swarm.data.SeismicDataSourceListener;
import gov.usgs.swarm.data.WWSSource;
import gov.usgs.swarm.data.WaveServerSource;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.vdx.data.wave.Wave;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;

public abstract class SeismicDataSource {
    protected String name = "Unnamed Data Source";
    protected boolean storeInUserConfig = true;
    protected boolean useCache = true;
    protected EventListenerList listeners = new EventListenerList();

    public abstract List<String> getChannels();

    public abstract Wave getWave(String var1, double var2, double var4);

    public abstract HelicorderData getHelicorder(String var1, double var2, double var4, GulperListener var6);

    public void addListener(SeismicDataSourceListener l) {
        this.listeners.add(SeismicDataSourceListener.class, l);
    }

    public void removeListener(SeismicDataSourceListener l) {
        this.listeners.remove(SeismicDataSourceListener.class, l);
    }

    public void fireChannelsUpdated() {
        Object[] ls = this.listeners.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == SeismicDataSourceListener.class) {
                ((SeismicDataSourceListener)ls[i + 1]).channelsUpdated();
            }
            i -= 2;
        }
    }

    public void fireChannelsProgress(String id, double p) {
        Object[] ls = this.listeners.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == SeismicDataSourceListener.class) {
                ((SeismicDataSourceListener)ls[i + 1]).channelsProgress(id, p);
            }
            i -= 2;
        }
    }

    public void fireHelicorderProgress(String id, double p) {
        Object[] ls = this.listeners.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == SeismicDataSourceListener.class) {
                ((SeismicDataSourceListener)ls[i + 1]).helicorderProgress(id, p);
            }
            i -= 2;
        }
    }

    public void notifyDataNotNeeded(String station, double t1, double t2, GulperListener gl) {
    }

    public void setStoreInUserConfig(boolean b) {
        this.storeInUserConfig = b;
    }

    public boolean isStoreInUserConfig() {
        return this.storeInUserConfig;
    }

    public void setUseCache(boolean b) {
        this.useCache = b;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public boolean isActiveSource() {
        return false;
    }

    public void close() {
    }

    public void remove() {
    }

    public SeismicDataSource getCopy() {
        return this;
    }

    public String toString() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        return Images.getIcon("wave_server");
    }

    public void establish() {
    }

    public abstract String toConfigString();

    public static SeismicDataSource getDataSource(String source) {
        String name = source.substring(0, source.indexOf(";"));
        source = source.substring(source.indexOf(";") + 1);
        String type = source.substring(0, source.indexOf(":"));
        String params = source.substring(source.indexOf(":") + 1);
        SeismicDataSource sds = null;
        if (type.equals("ws")) {
            sds = new WaveServerSource(params);
        } else if (type.equals("wws")) {
            sds = new WWSSource(params);
        } else if (type.equals("wwsd")) {
            if (params != null) {
                String[] ss = params.split("|");
                String driver = ss[0];
                String url = ss[1];
                String db = ss[2];
                sds = new DirectWWSSource(driver, url, db);
            }
        } else if (type.equals("cache")) {
            sds = Swarm.getCache();
        } else if (type.equals("seed")) {
            sds = new FullSeedDataSource(params);
        } else if (type.equals("sac")) {
            sds = new SACDataSource(params);
        } else if (type.equals("dhi")) {
            sds = new DHIDataSource(params);
        } else if (type.equals("file")) {
            sds = Swarm.getApplication().fileSource;
        }
        sds.setName(name);
        return sds;
    }
}

