/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import gov.usgs.swarm.Config;
import gov.usgs.swarm.Images;
import gov.usgs.swarm.Kioskable;
import gov.usgs.swarm.SwarmLayout;
import gov.usgs.swarm.SwarmMenu;
import gov.usgs.swarm.SwarmUtil;
import gov.usgs.swarm.SwingWorker;
import gov.usgs.swarm.TimeListener;
import gov.usgs.swarm.chooser.DataChooser;
import gov.usgs.swarm.data.CachedDataSource;
import gov.usgs.swarm.data.FileDataSource;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.swarm.heli.HelicorderViewerFrame;
import gov.usgs.swarm.map.MapFrame;
import gov.usgs.swarm.wave.MultiMonitor;
import gov.usgs.swarm.wave.WaveClipboardFrame;
import gov.usgs.swarm.wave.WaveViewPanel;
import gov.usgs.swarm.wave.WaveViewerFrame;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import gov.usgs.util.ui.GlobalKeyManager;
import gov.usgs.vdx.data.wave.Wave;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public class Swarm
extends JFrame {
    private static final long serialVersionUID = -1L;
    private static Swarm application;
    private JDesktopPane desktop;
    private JSplitPane split;
    private DataChooser chooser;
    private SwarmMenu swarmMenu;
    private CachedDataSource cache;
    private int frameCount = 0;
    private WaveClipboardFrame waveClipboard;
    private MapFrame mapFrame;
    private static final String TITLE = "Swarm";
    private static final String VERSION = "2.0-rc3";
    private List<JInternalFrame> frames;
    private boolean fullScreen = false;
    private int oldState = 0;
    private Dimension oldSize;
    private Point oldLocation;
    private JFileChooser fileChooser;
    private Map<String, MultiMonitor> monitors;
    private AbstractAction toggleFullScreenAction;
    private long lastUITime;
    private EventListenerList timeListeners = new EventListenerList();
    public static Config config;
    public static Logger logger;
    public FileDataSource fileSource;
    private String lastLayout = "";

    public Swarm(String[] args) {
        super("Swarm [2.0-rc3]");
        logger = Log.getLogger("gov.usgs.swarm");
        logger.info("Launching Swarm (2.0-rc3)");
        logger.fine("JNLP: " + this.isJNLP());
        String[] ss = Util.getVersion("gov.usgs.swarm");
        if (ss == null) {
            logger.fine("no build version information available");
        } else {
            logger.info("build version/date: " + ss[0] + "/" + ss[1]);
        }
        this.setIconImage(Images.getIcon("swarm").getImage());
        this.monitors = new HashMap<String, MultiMonitor>();
        this.cache = new CachedDataSource();
        this.frames = new ArrayList<JInternalFrame>();
        application = this;
        this.checkJavaVersion();
        this.loadFileChooser();
        this.setupGlobalKeys();
        config = Config.createConfig(args);
        this.createUI();
    }

    private void checkJavaVersion() {
        String version = System.getProperty("java.version");
        logger.fine("java.version: " + version);
        if (version.startsWith("1.1") || version.startsWith("1.2") || version.startsWith("1.3") || version.startsWith("1.4")) {
            JOptionPane.showMessageDialog(this, "Swarm 2.0-rc3 requires at least Java version 1.5 or above.", "Error", 0);
            System.exit(-1);
        }
        Runtime rt = Runtime.getRuntime();
        logger.fine("maximum heap size: " + Util.numBytesToString(rt.maxMemory()));
    }

    private void setupGlobalKeys() {
        GlobalKeyManager m = GlobalKeyManager.getInstance();
        m.getInputMap().put(KeyStroke.getKeyStroke("F12"), "focus");
        m.getActionMap().put("focus", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                logger.fine("Focus check: \nCurrent window: " + kfm.getFocusedWindow() + "\n\n" + "Current component: " + kfm.getFocusOwner() + "\n");
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke("alt F12"), "outputcache");
        m.getActionMap().put("outputcache", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Swarm.this.cache != null) {
                    Swarm.this.cache.output();
                }
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke("ctrl L"), "savelayout");
        m.getActionMap().put("savelayout", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.this.saveLayout(null);
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift L"), "savelastlayout");
        m.getActionMap().put("savelastlayout", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String ll = Swarm.this.swarmMenu.getLastLayoutName();
                if (ll != null) {
                    Swarm.this.saveLayout(ll);
                }
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke(122, 0), "fullScreenToggle");
        m.getInputMap().put(KeyStroke.getKeyStroke(122, 128), "fullScreenToggle");
        m.getInputMap().put(KeyStroke.getKeyStroke(92, 128), "fullScreenToggle");
        this.toggleFullScreenAction = new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.this.toggleFullScreenMode();
            }
        };
        m.getActionMap().put("fullScreenToggle", this.toggleFullScreenAction);
    }

    public boolean isJNLP() {
        try {
            BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            return bs != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void touchUITime() {
        this.lastUITime = System.currentTimeMillis();
    }

    public long getLastUITime() {
        return this.lastUITime;
    }

    private void loadFileChooser() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Swarm.this.fileChooser = new JFileChooser();
            }
        });
        t.setPriority(1);
        t.start();
    }

    public JFileChooser getFileChooser() {
        int timeout = 10000;
        while (this.fileChooser == null && timeout > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            timeout -= 100;
        }
        this.fileChooser.resetChoosableFileFilters();
        return this.fileChooser;
    }

    public static String getVersion() {
        return VERSION;
    }

    public static CachedDataSource getCache() {
        return Swarm.application.cache;
    }

    public static FileDataSource getFileSource() {
        return Swarm.application.fileSource;
    }

    public WaveClipboardFrame getWaveClipboard() {
        return this.waveClipboard;
    }

    public MapFrame getMapFrame() {
        return this.mapFrame;
    }

    public DataChooser getDataChooser() {
        return this.chooser;
    }

    public static Swarm getApplication() {
        return application;
    }

    public void createUI() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Swarm.this.closeApp();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (Swarm.this.frames != null && Swarm.this.frames.size() > 0) {
                    JComponent jf = null;
                    int i = 0;
                    while (i < Swarm.this.frames.size()) {
                        JInternalFrame f = (JInternalFrame)Swarm.this.frames.get(i);
                        if (f instanceof HelicorderViewerFrame) {
                            jf = f;
                            break;
                        }
                        ++i;
                    }
                    if (jf == null) {
                        jf = (JInternalFrame)Swarm.this.frames.get(0);
                    }
                    jf.requestFocus();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.desktop = new JDesktopPane();
        this.desktop.setBorder(BorderFactory.createLineBorder(DataChooser.LINE_COLOR));
        this.desktop.setDragMode(1);
        this.setSize(Swarm.config.windowWidth, Swarm.config.windowHeight);
        this.setLocation(Swarm.config.windowX, Swarm.config.windowY);
        if (Swarm.config.windowMaximized) {
            this.setExtendedState(6);
        }
        this.setDefaultCloseOperation(3);
        this.fileSource = new FileDataSource();
        this.chooser = new DataChooser();
        this.split = SwarmUtil.createStrippedSplitPane(1, this.chooser, this.desktop);
        this.split.setDividerLocation(Swarm.config.chooserDividerLocation);
        this.split.setDividerSize(4);
        this.setChooserVisible(Swarm.config.chooserVisible);
        this.chooser.setDividerLocation(Swarm.config.nearestDividerLocation);
        this.waveClipboard = new WaveClipboardFrame();
        this.desktop.add(this.waveClipboard);
        this.waveClipboard.setVisible(Swarm.config.clipboardVisible);
        if (Swarm.config.clipboardMaximized) {
            try {
                this.waveClipboard.setMaximum(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mapFrame = new MapFrame();
        this.desktop.add(this.mapFrame);
        this.frames.add(this.mapFrame);
        this.mapFrame.setVisible(Swarm.config.mapVisible);
        if (Swarm.config.mapMaximized) {
            try {
                this.mapFrame.setMaximum(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mapFrame.toFront();
        this.swarmMenu = new SwarmMenu();
        this.setJMenuBar(this.swarmMenu);
        for (SwarmLayout sl : Swarm.config.layouts.values()) {
            this.swarmMenu.addLayout(sl);
        }
        this.setVisible(true);
        long offset = CurrentTime.getInstance().getOffset();
        if (Math.abs(offset) > 600000L) {
            JOptionPane.showMessageDialog(this, "You're system clock is off by more than 10 minutes.\nThis is just for your information, Swarm will not be affected by this.", "System Clock", 1);
        }
    }

    public void addTimeListener(TimeListener tl) {
        this.timeListeners.add(TimeListener.class, tl);
    }

    public void removeTimeListener(TimeListener tl) {
        this.timeListeners.remove(TimeListener.class, tl);
    }

    public void fireTimeChanged(double j2k) {
        Object[] ls = this.timeListeners.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == TimeListener.class) {
                ((TimeListener)ls[i + 1]).timeChanged(j2k);
            }
            i -= 2;
        }
    }

    public void setChooserVisible(boolean vis) {
        if (vis) {
            this.split.setRightComponent(this.desktop);
            this.split.setDividerLocation(Swarm.config.chooserDividerLocation);
            this.setContentPane(this.split);
        } else {
            if (this.isChooserVisible()) {
                Swarm.config.chooserDividerLocation = this.split.getDividerLocation();
            }
            this.setContentPane(this.desktop);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.validate();
        }
    }

    public boolean isChooserVisible() {
        return this.getContentPane() == this.split;
    }

    public boolean isMapVisible() {
        return this.mapFrame.isVisible();
    }

    public void setMapVisible(boolean vis) {
        this.mapFrame.setVisible(vis);
        if (vis) {
            this.mapFrame.toFront();
        }
    }

    public boolean isClipboardVisible() {
        return this.waveClipboard.isVisible();
    }

    public void setClipboardVisible(boolean vis) {
        this.waveClipboard.setVisible(vis);
        if (vis) {
            this.waveClipboard.toFront();
        }
    }

    public boolean isFullScreenMode() {
        return this.fullScreen;
    }

    public void toggleFullScreenMode() {
        this.setFullScreenMode(!this.fullScreen);
    }

    public void setFullScreenMode(boolean full) {
        if (this.fullScreen == full) {
            return;
        }
        this.requestFocus();
        this.fullScreen = full;
        this.dispose();
        this.setUndecorated(full);
        this.setResizable(!full);
        this.waveClipboard.setVisible(!full);
        this.waveClipboard.toBack();
        if (full) {
            this.setJMenuBar(null);
            Swarm.config.chooserDividerLocation = this.split.getDividerLocation();
            this.oldState = this.getExtendedState();
            this.oldSize = this.getSize();
            this.oldLocation = this.getLocation();
            this.setContentPane(this.desktop);
            this.setVisible(true);
            this.setExtendedState(6);
            this.desktop.setSize(this.getSize());
            this.desktop.setPreferredSize(this.getSize());
        } else {
            this.setJMenuBar(this.swarmMenu);
            this.setExtendedState(this.oldState);
            this.setSize(this.oldSize);
            this.setLocation(this.oldLocation);
            this.split.setRightComponent(this.desktop);
            this.split.setDividerLocation(Swarm.config.chooserDividerLocation);
            this.setContentPane(this.split);
        }
        this.validate();
        this.setVisible(true);
        for (JInternalFrame frame : this.frames) {
            if (!frame.isVisible() || !(frame instanceof Kioskable)) continue;
            Kioskable f = (Kioskable)((Object)frame);
            f.setKioskMode(full);
        }
        this.tileKioskFrames();
    }

    public void closeApp() {
        Point p = this.getLocation();
        if (this.getExtendedState() == 6) {
            Swarm.config.windowMaximized = true;
        } else {
            Dimension d = this.getSize();
            Swarm.config.windowX = p.x;
            Swarm.config.windowY = p.y;
            Swarm.config.windowWidth = d.width;
            Swarm.config.windowHeight = d.height;
            Swarm.config.windowMaximized = false;
        }
        if (this.waveClipboard.isMaximum()) {
            Swarm.config.clipboardMaximized = true;
        } else {
            Swarm.config.clipboardX = this.waveClipboard.getX();
            Swarm.config.clipboardY = this.waveClipboard.getY();
            Swarm.config.clipboardWidth = this.waveClipboard.getWidth();
            Swarm.config.clipboardHeight = this.waveClipboard.getHeight();
            Swarm.config.clipboardMaximized = false;
        }
        Swarm.config.clipboardVisible = this.isClipboardVisible();
        if (this.mapFrame.isMaximum()) {
            Swarm.config.mapMaximized = true;
        } else {
            Swarm.config.mapX = this.mapFrame.getX();
            Swarm.config.mapY = this.mapFrame.getY();
            Swarm.config.mapWidth = this.mapFrame.getWidth();
            Swarm.config.mapHeight = this.mapFrame.getHeight();
            Swarm.config.mapMaximized = false;
        }
        Swarm.config.mapVisible = this.mapFrame.isVisible();
        Swarm.config.chooserDividerLocation = this.split.getDividerLocation();
        Swarm.config.chooserVisible = this.isChooserVisible();
        Swarm.config.nearestDividerLocation = this.chooser.getDividerLocation();
        Swarm.config.kiosk = Boolean.toString(this.fullScreen);
        Swarm.config.userTimes = this.chooser.getUserTimes();
        if (Swarm.config.saveConfig) {
            ConfigFile configFile = config.toConfigFile();
            configFile.remove("configFile");
            configFile.writeToFile(Swarm.config.configFilename);
        }
        this.waveClipboard.removeWaves();
        try {
            for (JInternalFrame frame : this.frames) {
                frame.setClosed(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public void loadClipboardWave(final SeismicDataSource source, final String channel) {
        final WaveViewPanel wvp = new WaveViewPanel();
        wvp.setChannel(channel);
        wvp.setDataSource(source);
        WaveViewPanel cwvp = this.waveClipboard.getSelected();
        double st = 0.0;
        double et = 0.0;
        if (cwvp == null) {
            double now = CurrentTime.getInstance().nowJ2K();
            st = now - 180.0;
            et = now;
        } else {
            st = cwvp.getStartTime();
            et = cwvp.getEndTime();
        }
        final double fst = st;
        final double fet = et;
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                Swarm.this.waveClipboard.getThrobber().increment();
                Wave sw = source.getWave(channel, fst, fet);
                wvp.setWave(sw, fst, fet);
                return null;
            }

            @Override
            public void finished() {
                Swarm.this.waveClipboard.getThrobber().decrement();
                Swarm.this.waveClipboard.setVisible(true);
                Swarm.this.waveClipboard.toFront();
                try {
                    Swarm.this.waveClipboard.setSelected(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Swarm.this.waveClipboard.addWave(wvp);
            }
        };
        worker.start();
    }

    public void removeMonitor(MultiMonitor mm) {
        this.monitors.remove(mm.getDataSource().getName());
        this.removeInternalFrame(mm);
        mm = null;
    }

    public MultiMonitor getMonitor(SeismicDataSource source) {
        MultiMonitor monitor = this.monitors.get(source.getName());
        if (monitor == null) {
            monitor = new MultiMonitor(source);
            this.monitors.put(source.getName(), monitor);
            this.addInternalFrame(monitor);
        }
        return monitor;
    }

    public void monitorChannelSelected(SeismicDataSource source, String channel) {
        MultiMonitor monitor = this.getMonitor(source);
        monitor.setVisible(true);
        monitor.addChannel(channel);
    }

    public WaveViewerFrame openRealtimeWave(SeismicDataSource source, String channel) {
        WaveViewerFrame frame = new WaveViewerFrame(source, channel);
        this.addInternalFrame(frame);
        return frame;
    }

    public HelicorderViewerFrame openHelicorder(SeismicDataSource source, String channel, double time) {
        source.establish();
        HelicorderViewerFrame frame = new HelicorderViewerFrame(source, channel, time);
        frame.addLinkListeners();
        this.addInternalFrame(frame);
        return frame;
    }

    public void saveLayout(String name) {
        boolean fixedName = name != null;
        SwarmLayout sl = this.getCurrentLayout();
        boolean done = false;
        while (!done) {
            if (name == null) {
                name = (String)JOptionPane.showInputDialog(Swarm.getApplication(), "Enter a name for this layout:", "Save Layout", 1, null, null, this.lastLayout);
            }
            if (name != null) {
                if (Swarm.config.layouts.containsKey(name)) {
                    int opt;
                    boolean overwrite = false;
                    overwrite = !fixedName ? (opt = JOptionPane.showConfirmDialog(Swarm.getApplication(), "A layout by that name already exists.  Overwrite?", "Warning", 0)) == 0 : true;
                    if (overwrite) {
                        if (fixedName) {
                            JOptionPane.showMessageDialog(Swarm.getApplication(), "Layout overwritten.");
                        }
                        this.swarmMenu.removeLayout((SwarmLayout)Swarm.config.layouts.get(name));
                        config.removeLayout((SwarmLayout)Swarm.config.layouts.get(name));
                    }
                }
                if (Swarm.config.layouts.containsKey(name)) continue;
                this.swarmMenu.setLastLayoutName(name);
                sl.setName(name);
                sl.save();
                this.swarmMenu.addLayout(sl);
                config.addLayout(sl);
                done = true;
                this.lastLayout = name;
                continue;
            }
            done = true;
        }
    }

    public SwarmLayout getCurrentLayout() {
        ConfigFile cf = new ConfigFile();
        cf.put("name", "Current Layout");
        cf.put("kiosk", Boolean.toString(this.isFullScreenMode()));
        cf.put("kioskX", Integer.toString(this.getX()));
        cf.put("kioskY", Integer.toString(this.getY()));
        this.chooser.saveLayout(cf, "chooser");
        SwarmLayout sl = new SwarmLayout(cf);
        int i = 0;
        for (JInternalFrame frame : this.frames) {
            if (frame instanceof HelicorderViewerFrame) {
                HelicorderViewerFrame hvf = (HelicorderViewerFrame)frame;
                hvf.saveLayout(cf, "helicorder-" + i++);
                continue;
            }
            if (!(frame instanceof MultiMonitor)) continue;
            MultiMonitor mm = (MultiMonitor)frame;
            mm.saveLayout(cf, "monitor-" + i++);
        }
        if (this.mapFrame.isVisible()) {
            this.mapFrame.saveLayout(cf, "map");
        }
        return sl;
    }

    public void removeAllFrames() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (JInternalFrame frame : Swarm.this.frames) {
                    if (!(frame instanceof HelicorderViewerFrame) && !(frame instanceof WaveViewerFrame) && !(frame instanceof MultiMonitor)) continue;
                    try {
                        frame.setClosed(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removeInternalFrame(final JInternalFrame f) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Swarm.this.swarmMenu.removeInternalFrame(f);
                Swarm.this.frames.remove(f);
                if (Swarm.this.frameCount > 0) {
                    Swarm swarm = Swarm.this;
                    swarm.frameCount = swarm.frameCount - 1;
                }
            }
        });
    }

    public void addInternalFrame(JInternalFrame f) {
        this.addInternalFrame(f, true);
    }

    public void addInternalFrame(final JInternalFrame f, boolean setLoc) {
        this.frames.add(f);
        ++this.frameCount;
        this.frameCount %= 10;
        if (setLoc) {
            f.setLocation(this.frameCount * 24, this.frameCount * 24);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Swarm.this.swarmMenu.addInternalFrame(f);
                Swarm.this.desktop.add(f);
                f.toFront();
                try {
                    f.setSelected(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void tileKioskFrames() {
        Dimension ds = this.desktop.getSize();
        ArrayList<JInternalFrame> ks = new ArrayList<JInternalFrame>();
        for (JInternalFrame frame : this.frames) {
            if (!frame.isVisible() || !(frame instanceof Kioskable)) continue;
            ks.add(frame);
        }
        if (ks.size() == 0) {
            return;
        }
        int mapCount = 0;
        int heliCount = 0;
        int monitorCount = 0;
        for (JInternalFrame frame : ks) {
            if (frame instanceof MapFrame) {
                ++mapCount;
                continue;
            }
            if (frame instanceof HelicorderViewerFrame) {
                ++heliCount;
                continue;
            }
            if (!(frame instanceof MultiMonitor)) continue;
            ++monitorCount;
        }
        if (ks.size() == 3 && mapCount == 1 && heliCount == 1 && monitorCount == 1) {
            int w = ds.width / 2;
            int h = ds.height / 2;
            for (JInternalFrame frame : ks) {
                if (frame instanceof MapFrame) {
                    frame.setLocation(w, h);
                    frame.setSize(w, h);
                    continue;
                }
                if (frame instanceof HelicorderViewerFrame) {
                    frame.setLocation(0, 0);
                    frame.setSize(w, h * 2);
                    continue;
                }
                if (!(frame instanceof MultiMonitor)) continue;
                frame.setLocation(w, 0);
                frame.setSize(w, h);
            }
        } else {
            int cols;
            int w;
            int h;
            int rows = 0;
            while ((h = ds.height / ++rows) / (w = ds.width / (cols = (int)Math.ceil((double)ks.size() / (double)rows))) > 1) {
            }
            int i = 0;
            while (i < ks.size()) {
                JInternalFrame hvf = (JInternalFrame)ks.get(i);
                try {
                    hvf.setIcon(false);
                    hvf.setMaximum(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                hvf.setSize(w, h);
                hvf.setLocation(w * (i % cols), h * (i / cols));
                ++i;
            }
        }
    }

    public void tileHelicorders() {
        Dimension ds = this.desktop.getSize();
        ArrayList<HelicorderViewerFrame> hcs = new ArrayList<HelicorderViewerFrame>(10);
        for (JInternalFrame frame : this.frames) {
            if (!(frame instanceof HelicorderViewerFrame)) continue;
            hcs.add((HelicorderViewerFrame)frame);
        }
        if (hcs.size() == 0) {
            return;
        }
        if (hcs.size() == 4) {
            int w = ds.width / 2;
            int h = ds.height / 2;
            HelicorderViewerFrame hvf0 = (HelicorderViewerFrame)hcs.get(0);
            HelicorderViewerFrame hvf1 = (HelicorderViewerFrame)hcs.get(1);
            HelicorderViewerFrame hvf2 = (HelicorderViewerFrame)hcs.get(2);
            HelicorderViewerFrame hvf3 = (HelicorderViewerFrame)hcs.get(3);
            hvf0.setSize(w, h);
            hvf0.setLocation(0, 0);
            hvf1.setSize(w, h);
            hvf1.setLocation(w, 0);
            hvf2.setSize(w, h);
            hvf2.setLocation(0, h);
            hvf3.setSize(w, h);
            hvf3.setLocation(w, h);
        } else {
            int w = ds.width / hcs.size();
            int cx = 0;
            int i = 0;
            while (i < hcs.size()) {
                HelicorderViewerFrame hvf = (HelicorderViewerFrame)hcs.get(i);
                try {
                    hvf.setIcon(false);
                    hvf.setMaximum(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                hvf.setSize(w, ds.height);
                hvf.setLocation(cx, 0);
                cx += w;
                ++i;
            }
        }
    }

    public void tileWaves() {
        Dimension ds = this.desktop.getSize();
        int wc = 0;
        for (JInternalFrame frame : this.frames) {
            if (!(frame instanceof WaveViewerFrame)) continue;
            ++wc;
        }
        if (wc == 0) {
            return;
        }
        int h = ds.height / wc;
        int cy = 0;
        for (JInternalFrame frame : this.frames) {
            if (!(frame instanceof WaveViewerFrame)) continue;
            WaveViewerFrame wvf = (WaveViewerFrame)frame;
            try {
                wvf.setIcon(false);
                wvf.setMaximum(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            wvf.setSize(ds.width, h);
            wvf.setLocation(0, cy);
            cy += h;
        }
    }

    public void setFrameLayer(JInternalFrame c, int layer) {
        this.desktop.setLayer(c, layer, 0);
    }

    private void parseKiosk() {
        String[] kiosks = Swarm.config.kiosk.split(",");
        if (Swarm.config.kiosk.startsWith("layout:")) {
            String layout = Swarm.config.kiosk.substring(7);
            SwarmLayout sl = (SwarmLayout)Swarm.config.layouts.get(layout);
            if (sl != null) {
                this.lastLayout = layout;
                sl.process();
            } else {
                logger.warning("could not start with layout: " + layout);
            }
        }
        boolean set = false;
        int i = 0;
        while (i < kiosks.length) {
            String[] ch = kiosks[i].split(";");
            SeismicDataSource sds = config.getSource(ch[0]);
            if (sds != null) {
                this.openHelicorder(sds, ch[1], Double.NaN);
                set = true;
            }
            ++i;
        }
        if (Swarm.config.kiosk.equals("true")) {
            set = true;
        }
        if (set) {
            this.toggleFullScreenMode();
        } else {
            logger.warning("no helicorders, skipping kiosk mode.");
        }
    }

    public void optionsChanged() {
        for (JInternalFrame frame : this.frames) {
            if (frame instanceof HelicorderViewerFrame) {
                HelicorderViewerFrame hvf = (HelicorderViewerFrame)frame;
                hvf.getHelicorderViewPanel().cursorChanged();
                hvf.getHelicorderViewPanel().invalidateImage();
                if (Swarm.config.durationEnabled) continue;
                hvf.getHelicorderViewPanel().clearMarks();
                continue;
            }
            if (!(frame instanceof MapFrame)) continue;
            MapFrame mf = (MapFrame)frame;
            mf.reloadImages();
        }
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-v")) {
            Logger.getLogger("").setLevel(Level.ALL);
            Log.getLogger("gov.usgs.swarm.Swarm").info("Verbose logging enabled.");
        } else {
            Logger.getLogger("").setLevel(Level.INFO);
        }
        try {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
            UIManager.put("InternalFrame.border", SwarmUtil.getInternalFrameBorder());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Swarm swarm = new Swarm(args);
        if (config.isKiosk()) {
            swarm.parseKiosk();
        }
    }
}

