/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm;

import gov.usgs.swarm.Metadata;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.ResourceReader;
import java.util.ArrayList;
import java.util.Collections;

public class DefaultMetadata {
    private static ArrayList<Entry> entries;

    public static Metadata getMetadata(String ch) {
        Entry e;
        if (entries == null) {
            entries = new ArrayList();
            ResourceReader rr = ResourceReader.getResourceReader("DefaultLatLon.config");
            if (rr == null) {
                return null;
            }
            String s = null;
            while ((s = rr.nextLine()) != null) {
                String[] ss = s.split("\t");
                e = new Entry();
                e.station = ss[0];
                e.longitude = Double.parseDouble(ss[1]);
                e.latitude = Double.parseDouble(ss[2]);
                entries.add(e);
            }
        }
        String station = ch.split(" ")[0];
        int i = Collections.binarySearch(entries, station);
        Metadata md = null;
        if (i >= 0) {
            e = entries.get(i);
            md = new Metadata(ch);
            md.updateLongitude(e.longitude);
            md.updateLatitude(e.latitude);
        }
        return md;
    }

    public static void main(String[] args) {
        CodeTimer ct = new CodeTimer();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            Metadata md = DefaultMetadata.getMetadata(a);
            System.out.println(md);
            ++n2;
        }
        ct.stop();
    }

    private static class Entry
    implements Comparable<String> {
        public String station;
        public double longitude;
        public double latitude;

        private Entry() {
        }

        @Override
        public int compareTo(String oe) {
            return this.station.compareTo(oe);
        }
    }
}

