/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.proj;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import gov.usgs.proj.Ellipsoid;
import gov.usgs.proj.FastProjector;
import gov.usgs.proj.GeoRange;
import gov.usgs.proj.Projection;
import gov.usgs.util.CodeTimer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JFrame;

public class Mercator
extends Projection {
    private Point2D.Double origin;
    private static Mercator mercator = new Mercator();

    public Mercator() {
        this.name = "Mercator";
        this.origin = new Point2D.Double(0.0, 0.0);
        this.ellipsoid = Ellipsoid.ELLIPSOIDS[0];
    }

    public int hashCode() {
        return this.origin.hashCode() + "Mercator".hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Mercator)) {
            return false;
        }
        Mercator m = (Mercator)obj;
        return m.origin.equals(this.origin);
    }

    public static double getMaxWidth() {
        Point2D.Double pt = new Point2D.Double(-180.0, 0.0);
        Point2D.Double left = mercator.forward(pt);
        pt.x = 180.0;
        Point2D.Double right = mercator.forward(pt);
        return right.x - left.x;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setOrigin(Point2D.Double pt) {
        this.origin.x = pt.x;
    }

    @Override
    public double getScale(Point2D.Double lonLat) {
        return 1.0 / Math.cos(Math.toRadians(lonLat.y));
    }

    @Override
    public Point2D.Double forward(Point2D.Double lonLat) {
        double r = this.ellipsoid.equatorialRadius;
        double lambdaO = this.origin.getX() * (Math.PI / 180);
        double phi = lonLat.getY() * (Math.PI / 180);
        double lambda = lonLat.getX() * (Math.PI / 180);
        double l = lambda - lambdaO;
        while (l > Math.PI) {
            l -= Math.PI * 2;
        }
        while (l < -Math.PI) {
            l += Math.PI * 2;
        }
        double x = r * l;
        double y = r * Math.log(Math.tan(0.7853981633974483 + phi / 2.0));
        return new Point2D.Double(x, y);
    }

    @Override
    public Point2D.Double inverse(Point2D.Double xy) {
        double r = this.ellipsoid.equatorialRadius;
        double lambdaO = this.origin.getX() * (Math.PI / 180);
        double phi = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-xy.y / r));
        double lambda = lambdaO + xy.x / r;
        return new Point2D.Double(lambda * 57.29577951308232, phi * 57.29577951308232);
    }

    @Override
    public FastProjector getFastProjector() {
        return new FastProjector(){
            double r;
            double lambdaO;
            {
                this.r = Mercator.this.ellipsoid.equatorialRadius;
                this.lambdaO = Mercator.this.origin.getX() * (Math.PI / 180);
            }

            @Override
            public void forward(Point2D.Double pt) {
                pt = Mercator.this.forward(pt);
            }

            @Override
            public void inverse(Point2D.Double xy) {
                xy.y = (1.5707963267948966 - 2.0 * Math.atan(Math.exp(-xy.y / this.r))) * 57.29577951308232;
                xy.x = (this.lambdaO + xy.x / this.r) * 57.29577951308232;
            }
        };
    }

    public static void main(String[] args) throws Exception {
        Mercator merc = new Mercator();
        GeoRange gr = new GeoRange(-180.0, 180.0, -90.0, 90.0);
        boolean m = true;
        final Image[] imgs = new Image[1];
        CodeTimer ctl = new CodeTimer("load");
        JPEGImageDecoder codec = JPEGCodec.createJPEGDecoder((InputStream)new FileInputStream("c:\\mapdata\\nasa\\world.jpg"));
        BufferedImage bi = codec.decodeAsBufferedImage();
        ctl.mark("decode");
        Raster r = bi.getData();
        DataBufferInt dbi = (DataBufferInt)r.getDataBuffer();
        System.out.println(String.valueOf(dbi.getNumBanks()) + " " + dbi.getSize());
        int[] pix = dbi.getData();
        int i = 0;
        while (i < pix.length) {
            pix[i] = 0xFF000000 | pix[i];
            ++i;
        }
        ctl.mark("toint");
        ctl.stop();
        System.out.println("pix.length: " + pix.length);
        merc.setOrigin(new Point2D.Double(-63.033241220845554, 0.0));
        double[] extents = new double[]{-1577434.476903, 1577434.476903, -7277893.83926, -4288413.663448};
        imgs[0] = merc.getProjectedImage(5, 1020, 970, pix, 2700, 1350, gr, extents[0], extents[1], extents[2], extents[3]);
        JFrame f = new JFrame("GeoImageSet Test, Projected"){
            public static final long serialVersionUID = -1L;
            int cycle;
            {
                super($anonymous0);
                this.cycle = 0;
            }

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                if (this.cycle == 0) {
                    g2.setColor(Color.RED);
                    g2.fillRect(0, 0, 1200, 1100);
                }
                g2.drawImage(imgs[++this.cycle % 1], 50, 40, null);
            }
        };
        f.setSize(1200, 1100);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        while (true) {
            f.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

