/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.map;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class WMSImageGrabber {
    protected String server = "http://wms.jpl.nasa.gov/wms.cgi";
    protected BufferedReader in;
    protected InputStream inputStream;

    private void getReader(String resource) throws MalformedURLException, IOException {
        if (resource.indexOf("://") != -1) {
            URL url = new URL(resource);
            this.inputStream = url.openStream();
            this.in = new BufferedReader(new InputStreamReader(this.inputStream));
        } else {
            this.in = new BufferedReader(new FileReader(resource));
        }
    }

    public void getCapabilities() {
        String request = String.valueOf(this.server) + "?REQUEST=GetCapabilities";
        try {
            String s;
            this.getReader(request);
            while ((s = this.in.readLine()) != null) {
                System.out.println(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BufferedImage getImage() {
        BufferedImage image = null;
        String request = String.valueOf(this.server) + "?REQUEST=GetMap&LAYERS=BMNG&STYLES=Sep&WIDTH=1000&HEIGHT=800" + "&EXCEPTIONS=application/vnd.ogc.se_inimage&SRS=EPSG%3A4326&BBOX=-180,-90,180,90&FORMAT=image/jpeg";
        try {
            this.getReader(request);
            JPEGImageDecoder codec = JPEGCodec.createJPEGDecoder((InputStream)this.inputStream);
            image = codec.decodeAsBufferedImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    public static void main(String[] args) {
        WMSImageGrabber w = new WMSImageGrabber();
        BufferedImage bi = w.getImage();
        JFrame f = new JFrame("Test");
        f.setSize(1200, 1000);
        f.setDefaultCloseOperation(3);
        f.setLocationRelativeTo(null);
        f.setContentPane(new JButton(new ImageIcon(bi)));
        f.setVisible(true);
    }
}

