/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.image.IndexColorModel;

public class Spectrum {
    public Color[] colors;
    public IndexColorModel palette;
    public byte[] paletteBytes;

    protected Spectrum() {
    }

    public int getNumColors() {
        return this.colors.length;
    }

    public Color getColorByRatio(double d) {
        return this.colors[(int)(d * (double)this.colors.length)];
    }

    public int getColorIndexByRatio(double d) {
        return (int)(d * (double)this.colors.length);
    }

    public void renderScale(Graphics2D g, double x, double y, double width, double height, boolean vertical, boolean box) {
        Paint p = g.getPaint();
        Rectangle2D.Double rect = new Rectangle2D.Double();
        double step = vertical ? height / (double)this.colors.length : width / (double)this.colors.length;
        int i = 0;
        while (i < this.colors.length) {
            if (!vertical) {
                rect.setRect(x + (double)i * step, y, step, height);
            } else {
                rect.setRect(x, y + (double)i * step, width, step);
            }
            g.setPaint(this.colors[i]);
            g.fill(rect);
            ++i;
        }
        if (box) {
            g.setPaint(Color.BLACK);
            rect.setRect(x - 1.0, y - 1.0, width + 1.0, height + 1.0);
            g.draw(rect);
        }
        g.setPaint(p);
    }
}

