/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.plot.AxisRenderer;
import gov.usgs.plot.ColorCycler;
import gov.usgs.plot.ColorParser;
import gov.usgs.plot.DataPointRenderer;
import gov.usgs.plot.MatrixRenderer;
import gov.usgs.plot.Plot;
import gov.usgs.plot.SmartTick;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.util.png.PngEncoderB;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class Plotter {
    protected List<DoubleMatrix2D> data;
    protected double minData = 1.0E300;
    protected double maxData = -1.0E300;
    protected double minTime = 1.0E300;
    protected double maxTime = -1.0E300;
    protected ConfigFile config;
    protected BufferedImage image;
    protected JFrame frame;

    public Plotter(String[] args) {
        this.readOptions(args);
        this.readData();
        this.plot();
    }

    public void fatalError(String s) {
        System.err.println("fatal: " + s);
        System.exit(-1);
    }

    protected void readOptions(String[] args) {
        HashMap<String, String> options = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("--")) {
                String key = args[i].substring(2, args[i].indexOf(61));
                String val = args[i].substring(args[i].indexOf(61) + 1);
                options.put(key, val);
            } else {
                System.err.println("ignored command line option: " + args[i]);
            }
            ++i;
        }
        String cfn = (String)options.get("configFile");
        if (cfn != null) {
            this.config = new ConfigFile(cfn);
            if (!this.config.wasSuccessfullyRead()) {
                this.fatalError("configFile not found.");
            }
        } else {
            this.config = new ConfigFile();
        }
        for (String key : options.keySet()) {
            this.config.put(key, (String)options.get(key), false);
        }
        if (this.isOutputConfig()) {
            System.out.println(this.config);
        }
    }

    protected void readData() {
        this.data = new ArrayList<DoubleMatrix2D>();
        try {
            List<double[]> ld;
            BufferedReader in = new BufferedReader(new InputStreamReader(this.getInput()));
            while ((ld = this.readDataSet(in)).size() > 0) {
                DoubleMatrix2D dm = DoubleFactory2D.dense.make(ld.size(), 2);
                int i = 0;
                while (i < ld.size()) {
                    double f = ld.get(i)[0];
                    this.minTime = Math.min(this.minTime, f);
                    this.maxTime = Math.max(this.maxTime, f);
                    dm.setQuick(i, 0, f);
                    f = ld.get(i)[1];
                    this.minData = Math.min(this.minData, f);
                    this.maxData = Math.max(this.maxData, f);
                    dm.setQuick(i, 1, f);
                    ++i;
                }
                this.data.add(dm);
            }
        }
        catch (FileNotFoundException e) {
            this.fatalError("Input file not found: " + this.config.getString("input"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.data.size() <= 0) {
            this.fatalError("No data read.");
        }
    }

    protected List<double[]> readDataSet(BufferedReader in) throws IOException {
        boolean done = false;
        SimpleDateFormat df = new SimpleDateFormat(this.getDateFormatString());
        ArrayList<double[]> ld = new ArrayList<double[]>(1000);
        while (!done) {
            String s = in.readLine();
            if (s == null || s.startsWith(">")) {
                done = true;
                continue;
            }
            try {
                String[] tokens = s.split("[ ,\t]");
                double[] d = new double[]{Util.dateToJ2K(df.parse(tokens[0])), Double.parseDouble(tokens[1])};
                ld.add(d);
            }
            catch (Exception e) {
                System.err.println("failed to parse: " + s);
            }
        }
        return ld;
    }

    protected String getDateFormatString() {
        String dfs = this.config.getString("inputDateFormat");
        if (dfs == null) {
            dfs = "yyyyMMdd";
        }
        return dfs;
    }

    protected InputStream getInput() throws Exception {
        String inp = this.config.getString("input");
        if (inp == null || inp.equals("stdin")) {
            return System.in;
        }
        return new FileInputStream(inp);
    }

    protected int getInt(String s, int def) {
        try {
            return Integer.parseInt(this.config.getString(s));
        }
        catch (Exception e) {
            return def;
        }
    }

    protected String getYFormatString() {
        return this.config.getString("yFormatString");
    }

    protected int getWidth() {
        return this.getInt("width", 1000);
    }

    protected int getHeight() {
        return this.getInt("height", 300);
    }

    protected int getBoxX() {
        return this.getInt("boxX", 55);
    }

    protected int getBoxY() {
        return this.getInt("boxY", 25);
    }

    protected int getBoxWidth() {
        return this.getInt("boxWidth", 890);
    }

    protected int getBoxHeight() {
        return this.getInt("boxHeight", 2);
    }

    protected String getLeftLabel() {
        return this.config.getString("leftLabel");
    }

    protected String getTitle() {
        return this.config.getString("title");
    }

    protected String getBottomLabel() {
        return this.config.getString("bottomLabel");
    }

    protected boolean isToScreen() {
        return Util.stringToBoolean(this.config.getString("toScreen"));
    }

    protected boolean isOutputConfig() {
        return Util.stringToBoolean(this.config.getString("outputConfig"));
    }

    protected String getOutputFilename() {
        return this.config.getString("outputFilename");
    }

    protected String getMonthTickFormat() {
        return this.config.getString("monthTickFormat");
    }

    protected LineSpec getLineSpec(int col) {
        String s = this.config.getString("line." + col);
        if (s == null) {
            return null;
        }
        return new LineSpec(s);
    }

    protected PointSpec getPointSpec(int col) {
        String s = this.config.getString("point." + col);
        if (s == null) {
            return null;
        }
        return new PointSpec(s);
    }

    protected LineSpec getHorizontalGrid() {
        String s = this.config.getString("horizontalGrid");
        if (s == null) {
            s = "1,black";
        }
        if (s.equals("off")) {
            return null;
        }
        return new LineSpec(s);
    }

    protected LineSpec getVerticalGrid() {
        String s = this.config.getString("verticalGrid");
        if (s == null) {
            s = "1,black";
        }
        if (s.equals("off")) {
            return null;
        }
        return new LineSpec(s);
    }

    protected Color getBackgroundColor() {
        String s = this.config.getString("background");
        if (s == null) {
            return new Color(248, 248, 248);
        }
        return ColorParser.getColor(s);
    }

    protected Color getAxisBackgroundColor() {
        String s = this.config.getString("axisBackground");
        if (s == null) {
            return Color.WHITE;
        }
        return ColorParser.getColor(s);
    }

    protected String getBottomLeftLabel() {
        return this.config.getString("bottomLeftLabel").replace("&copy;", "\u00a9");
    }

    protected String getBottomRightLabel() {
        return this.config.getString("bottomRightLabel");
    }

    protected TickSpec getTickSpec() {
        String s = this.config.getString("ticks");
        if (s == null) {
            s = "8,black";
        }
        if (s.equals("off")) {
            return null;
        }
        return new TickSpec(s);
    }

    protected double[] getXLimits() {
        String s = this.config.getString("xLimits");
        if (s == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        String[] ss = s.split(",");
        double[] d = new double[2];
        try {
            d[0] = Util.dateToJ2K(df.parse(ss[0]));
            d[1] = Util.dateToJ2K(df.parse(ss[1]));
        }
        catch (Exception e) {
            System.err.println("Illegal date format in xLimits.");
            d = null;
        }
        return d;
    }

    protected double[] getYLimits() {
        String s = this.config.getString("yLimits");
        if (s == null) {
            return null;
        }
        String[] ss = s.split(",");
        double[] d = new double[]{Double.parseDouble(ss[0]), Double.parseDouble(ss[1])};
        return d;
    }

    protected List<MatrixRenderer> createMatrixRenderers() {
        ArrayList<MatrixRenderer> mrs = new ArrayList<MatrixRenderer>(this.data.size());
        for (DoubleMatrix2D dm : this.data) {
            MatrixRenderer mr = new MatrixRenderer(dm);
            mr.setLocation(this.getBoxX(), this.getBoxY(), this.getBoxWidth(), this.getBoxHeight());
            mr.setExtents(this.minTime, this.maxTime, this.minData, this.maxData);
            mrs.add(mr);
        }
        return mrs;
    }

    protected void plot() {
        int numVTicks;
        double[] vTicks;
        double[] d;
        if (this.getMonthTickFormat() != null) {
            SmartTick.setMonthTickerLabelFormatString(this.getMonthTickFormat());
        }
        if ((d = this.getYLimits()) != null) {
            this.minData = d[0];
            this.maxData = d[1];
        }
        if ((d = this.getXLimits()) != null) {
            this.minTime = d[0];
            this.maxTime = d[1];
        }
        Plot plot = new Plot();
        plot.setSize(this.getWidth(), this.getHeight());
        plot.setBackgroundColor(this.getBackgroundColor());
        List<MatrixRenderer> mrs = this.createMatrixRenderers();
        MatrixRenderer mr = mrs.get(0);
        mr.createDefaultAxis();
        AxisRenderer axis = new AxisRenderer(mr);
        axis.createDefault();
        int numHTicks = this.getBoxWidth() / 70;
        Object[] hTicks = SmartTick.autoTimeTick(this.minTime, this.maxTime, numHTicks);
        if (hTicks != null) {
            LineSpec vert;
            TickSpec ticks = this.getTickSpec();
            if (ticks != null) {
                axis.createBottomTicks((double[])hTicks[0], ticks.width, ticks.color);
                axis.createTopTicks((double[])hTicks[0], ticks.width, ticks.color);
            }
            if ((vert = this.getVerticalGrid()) != null) {
                axis.createVerticalGridLines((double[])hTicks[0], vert.color, vert.stroke);
            }
            axis.createBottomTickLabels((double[])hTicks[0], (String[])hTicks[1]);
        }
        if ((vTicks = SmartTick.autoTick(this.minData, this.maxData, numVTicks = this.getBoxHeight() / 40, false)) != null) {
            LineSpec horiz;
            TickSpec ticks = this.getTickSpec();
            if (ticks != null) {
                axis.createLeftTicks(vTicks, ticks.width, ticks.color);
                axis.createRightTicks(vTicks, ticks.width, ticks.color);
            }
            if ((horiz = this.getHorizontalGrid()) != null) {
                axis.createHorizontalGridLines(vTicks, horiz.color, horiz.stroke);
                String format = this.getYFormatString();
                if (format == null) {
                    axis.createLeftTickLabels(vTicks, null);
                } else {
                    axis.createFormattedLeftTickLabels(vTicks, format);
                }
            }
        }
        mr.setAxis(axis);
        mr.getAxis().setBackgroundColor(this.getAxisBackgroundColor());
        mr.getAxis().setLeftLabelAsText(this.getLeftLabel());
        mr.getAxis().setTopLabelAsText(this.getTitle());
        mr.getAxis().setBottomLabelAsText(this.getBottomLabel());
        mr.getAxis().setBottomLeftLabelAsText(this.getBottomLeftLabel());
        mr.getAxis().setBottomRightLabelAsText(this.getBottomRightLabel());
        int i = 0;
        while (i < mrs.size()) {
            PointSpec ps;
            LineSpec ls = this.getLineSpec(i);
            if (ls != null) {
                mrs.get(i).createLineRenderer(0, ls.stroke, ls.color);
            }
            if ((ps = this.getPointSpec(i)) != null) {
                mrs.get(i).createPointRenderer(0, ps.createDataPointRenderer());
            }
            plot.addRenderer(mrs.get(i));
            ++i;
        }
        String of = this.getOutputFilename();
        this.image = plot.getAsBufferedImage(false);
        if (this.isToScreen()) {
            this.showOnScreen();
        }
        if (of != null) {
            this.writePNG(of);
        }
    }

    protected void writePNG(String fn) {
        try {
            PngEncoderB png = new PngEncoderB(this.image, false, 0, 7);
            FileOutputStream out = new FileOutputStream(fn);
            byte[] bytes = png.pngEncode();
            out.write(bytes);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void resize(int w, int h) {
        int lm = this.getBoxX();
        int rm = this.getWidth() - (this.getBoxX() + this.getBoxWidth());
        int tm = this.getBoxY();
        int bm = this.getHeight() - (this.getBoxY() + this.getBoxHeight());
        this.config.put("width", Integer.toString(w), false);
        this.config.put("height", Integer.toString(h), false);
        this.config.put("boxWidth", Integer.toString(w - lm - rm), false);
        this.config.put("boxHeight", Integer.toString(h - tm - bm), false);
        this.plot();
    }

    protected void showOnScreen() {
        if (this.frame != null) {
            return;
        }
        this.frame = new JFrame("Plot");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setSize(this.image.getWidth() + 30, this.image.getHeight() + 50);
        this.frame.setLocation(0, 0);
        this.frame.add(new JComponent(){
            private static final long serialVersionUID = -1L;

            @Override
            public void paint(Graphics g) {
                g.drawRect(9, 9, Plotter.this.image.getWidth() + 1, Plotter.this.image.getHeight() + 1);
                g.drawImage(Plotter.this.image, 10, 10, null);
            }
        });
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Plotter.this.resize(Plotter.this.frame.getWidth() - 30, Plotter.this.frame.getHeight() - 50);
                Plotter.this.frame.repaint();
            }
        });
        this.frame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                char ch = e.getKeyChar();
                if (ch == 'q' || ch == 'Q' || ch == '\u0003') {
                    System.exit(0);
                }
            }
        });
        this.frame.setVisible(true);
    }

    public static void main(String[] args) {
        new Plotter(args);
    }

    private static class LineSpec {
        public Stroke stroke;
        public Color color;
        private static ColorCycler colorCycler = new ColorCycler();

        public LineSpec(String s) {
            if (s == null) {
                this.stroke = new BasicStroke(1.0f);
                this.color = colorCycler.getNextColor();
            } else {
                String[] ss = s.split(",");
                float width = Float.parseFloat(ss[0].trim());
                this.color = ColorParser.getColor(ss[1].trim());
                ss[2] = ss[2].trim();
                if (ss[2].equals("dotted")) {
                    this.stroke = new BasicStroke(width, 0, 0, 10.0f, new float[]{1.0f, 2.0f}, 0.0f);
                } else if (ss[2].equals("solid")) {
                    this.stroke = new BasicStroke(width);
                } else if (ss[2].equals("dashed")) {
                    this.stroke = new BasicStroke(width, 0, 0, 10.0f, new float[]{5.0f, 3.0f}, 0.0f);
                }
            }
        }
    }

    private static class PointSpec {
        public Color color;
        public float size;
        public char shape;
        public boolean filled;

        public PointSpec(String s) {
            String[] ss = s.split(",");
            this.size = Float.parseFloat(ss[0].trim());
            this.color = ColorParser.getColor(ss[1].trim());
            this.shape = ss[2].charAt(0);
            this.filled = Util.stringToBoolean(ss[3]);
        }

        public DataPointRenderer createDataPointRenderer() {
            DataPointRenderer dr = new DataPointRenderer(this.shape, this.size);
            dr.antiAlias = true;
            dr.color = this.color;
            dr.filled = this.filled;
            return dr;
        }
    }

    private static class TickSpec {
        public Color color;
        public double width;

        public TickSpec(String s) {
            String[] ss = s.split(",");
            this.width = Float.parseFloat(ss[0].trim());
            this.color = ColorParser.getColor(ss[1].trim());
        }
    }
}

