/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.plot.SmartTick;
import gov.usgs.plot.Transformer;
import gov.usgs.proj.GeoRange;
import gov.usgs.proj.Projection;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class LineData {
    private List<Point2D.Double> points = new ArrayList<Point2D.Double>();

    public LineData() {
    }

    public LineData(String fn) {
        this();
        this.readLineDataFile(fn);
    }

    public LineData(double[] x, double[] y) {
        this(x, y, true);
    }

    public LineData(double[] x, double[] y, boolean edge) {
        this();
        int j;
        int i = edge ? 0 : 1;
        while (i < x.length - (edge ? 0 : 1)) {
            j = 0;
            while (j < y.length) {
                this.points.add(new Point2D.Double(x[i], y[j]));
                ++j;
            }
            this.points.add(new Point2D.Double(Double.NaN, Double.NaN));
            ++i;
        }
        i = edge ? 0 : 1;
        while (i < y.length - (edge ? 0 : 1)) {
            j = 0;
            while (j < x.length) {
                this.points.add(new Point2D.Double(x[j], y[i]));
                ++j;
            }
            this.points.add(new Point2D.Double(Double.NaN, Double.NaN));
            ++i;
        }
    }

    public LineData(double x, double y, double width, double height, int pts) {
        this();
        this.points.add(new Point2D.Double(x, y));
        int i = 0;
        while (i <= pts) {
            this.points.add(new Point2D.Double(x + (double)i * width / (double)pts, y));
            ++i;
        }
        i = 0;
        while (i <= pts) {
            this.points.add(new Point2D.Double(x + width, y + (double)i * height / (double)pts));
            ++i;
        }
        i = pts;
        while (i >= 0) {
            this.points.add(new Point2D.Double(x + (double)i * width / (double)pts, y + height));
            --i;
        }
        i = pts;
        while (i >= 0) {
            this.points.add(new Point2D.Double(x, y + (double)i * height / (double)pts));
            --i;
        }
    }

    public static LineData createLonLatGrid(GeoRange range, int pts) {
        double[] x = SmartTick.autoTick(range.getWest(), range.getEast(), pts, false);
        double[] y = SmartTick.autoTick(range.getSouth(), range.getNorth(), pts, false);
        return new LineData(x, y);
    }

    public void toMathematica(PrintWriter out, double minX, double maxX, double minY, double maxY, double zVal) {
        int i = 0;
        while (i < this.points.size() - 1) {
            Point2D.Double pt1 = this.points.get(i);
            if (!Double.isNaN(pt1.x) && !Double.isNaN(pt1.y)) {
                Point2D.Double pt2 = this.points.get(i + 1);
                if (!Double.isNaN(pt2.x) && !Double.isNaN(pt2.y) && pt1.x > minX && pt1.x < maxX && pt2.x > minX && pt2.x < maxX && pt1.y > minY && pt1.y < maxY && pt2.y > minY && pt2.y < maxY) {
                    out.println("Line[{{" + pt1.x + "," + pt1.y + "," + zVal + "},{" + pt2.x + "," + pt2.y + "," + zVal + "}}],");
                }
            }
            ++i;
        }
    }

    public void readLineDataFile(String fn) {
        try {
            String s;
            this.points.clear();
            BufferedReader in = new BufferedReader(new FileReader(fn));
            while ((s = in.readLine()) != null) {
                if (s.trim().length() == 0 || s.startsWith("#")) continue;
                Point2D.Double pt = new Point2D.Double();
                if (s.startsWith(">") || s.indexOf("NaN") != -1) {
                    pt.x = Double.NaN;
                    pt.y = Double.NaN;
                } else {
                    StringTokenizer st = new StringTokenizer(s, " ,\t");
                    pt.x = Double.parseDouble(st.nextToken());
                    pt.y = Double.parseDouble(st.nextToken());
                    if (pt.x > 180.0) {
                        pt.x = -(360.0 - pt.x);
                    }
                }
                this.points.add(pt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GeneralPath getPolygon(Transformer xform) {
        GeneralPath gp = new GeneralPath();
        boolean first = true;
        for (Point2D.Double pt : this.points) {
            if (Double.isNaN(pt.x) || Double.isNaN(pt.y)) {
                first = true;
                gp.closePath();
                continue;
            }
            if (first) {
                first = false;
                gp.moveTo((float)xform.getXPixel(pt.x) + 1.0f, (float)xform.getYPixel(pt.y) + 1.0f);
                continue;
            }
            gp.lineTo((float)xform.getXPixel(pt.x) + 1.0f, (float)xform.getYPixel(pt.y) + 1.0f);
        }
        return gp;
    }

    public void applyProjection(Projection proj) {
        ArrayList<Point2D.Double> newPoints = new ArrayList<Point2D.Double>(this.points.size());
        for (Point2D.Double pt : this.points) {
            newPoints.add(proj.forward(pt));
        }
        this.points = newPoints;
    }

    public List<Point2D.Double> getPoints() {
        return this.points;
    }
}

