/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.plot.FrameRenderer;
import gov.usgs.plot.Renderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class EllipseVectorRenderer2
implements Renderer {
    public double x;
    public double y;
    public double u;
    public double v;
    public boolean drawEllipse = true;
    public double ellipseWidth;
    public double ellipseHeight;
    public double ellipseOrientation;
    private double scale = 1.0;
    public boolean displayHoriz = true;
    public FrameRenderer frameRenderer;
    private static final double[] SCALES = new double[]{100000.0, 50000.0, 20000.0, 10000.0, 5000.0, 2000.0, 1000.0, 500.0, 200.0, 100.0, 50.0, 20.0, 10.0, 5.0, 2.0, 1.0, 0.5, 0.2, 0.1, 0.05, 0.02};
    private static GeneralPath arrowhead = new GeneralPath();

    static {
        arrowhead.moveTo(0.0f, 0.0f);
        arrowhead.lineTo(0.5f, -1.5f);
        arrowhead.lineTo(0.0f, -1.3f);
        arrowhead.lineTo(-0.5f, -1.5f);
        arrowhead.closePath();
    }

    public static double getBestScale(double maxMag) {
        double dm = 1.0E300;
        int mi = -1;
        int i = 0;
        while (i < SCALES.length) {
            if (Math.abs(maxMag - SCALES[i]) < dm) {
                dm = Math.abs(maxMag - SCALES[i]);
                mi = i;
            }
            ++i;
        }
        return SCALES[mi];
    }

    public void setUVByAngleMag(double az, double mag) {
        this.u = this.x + Math.cos(Math.toRadians(az)) * mag;
        this.v = this.y + Math.sin(Math.toRadians(az)) * mag;
    }

    public double getAngle() {
        return Math.toDegrees(Math.atan2(-this.u, -this.v));
    }

    public double getMag() {
        return Math.sqrt(this.u * this.u + this.v * this.v);
    }

    public void setScale(double s) {
        this.scale = s;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public void render(Graphics2D g) {
        AffineTransform origAT = g.getTransform();
        Color origColor = g.getColor();
        Paint origPaint = g.getPaint();
        Stroke origStroke = g.getStroke();
        Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Line2D.Double line = new Line2D.Double();
        if (this.displayHoriz) {
            g.setTransform(origAT);
            g.setStroke(origStroke);
            line.setLine(this.frameRenderer.getXPixel(this.x), this.frameRenderer.getYPixel(this.y), this.frameRenderer.getXPixel(this.x + this.u * this.scale), this.frameRenderer.getYPixel(this.y + this.v * this.scale));
            g.setColor(Color.red);
            g.draw(line);
            g.translate(this.frameRenderer.getXPixel(this.x + this.u * this.scale), this.frameRenderer.getYPixel(this.y + this.v * this.scale));
            g.rotate(Math.toRadians(this.getAngle()));
            g.setStroke(new BasicStroke(0.1f));
            double headScale = this.getMag() * this.scale * this.frameRenderer.getXScale() * 0.2;
            headScale = Math.min(12.0, headScale);
            headScale = Math.max(5.0, headScale);
            g.scale(headScale, headScale);
            g.fill(arrowhead);
            g.setTransform(origAT);
            g.setStroke(origStroke);
            g.setColor(Color.red);
            if (this.drawEllipse) {
                Ellipse2D.Double e = new Ellipse2D.Double(0.0, 0.0, this.ellipseWidth * this.scale, this.ellipseHeight * this.scale);
                e.x = -e.width / 2.0;
                e.y = -e.height / 2.0;
                g.translate(this.frameRenderer.getXPixel(this.x + this.u * this.scale), this.frameRenderer.getYPixel(this.y + this.v * this.scale));
                g.rotate(this.ellipseOrientation);
                g.scale(this.frameRenderer.getXScale(), this.frameRenderer.getYScale());
                g.setStroke(new BasicStroke((float)(1.0 / (double)((float)this.frameRenderer.getXScale()))));
                g.draw(e);
                g.setTransform(origAT);
            }
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
        g.setStroke(origStroke);
        g.setPaint(origPaint);
        g.setColor(origColor);
        g.setTransform(origAT);
    }
}

