/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm;

import gov.usgs.util.Util;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class MessageLogo {
    public byte type;
    public byte module;
    public byte installationID;
    public static final int TYPE_WILDCARD = 0;
    public static final int TYPE_ADBUF = 1;
    public static final int TYPE_ERROR = 2;
    public static final int TYPE_HEARTBEAT = 3;
    public static final int TYPE_NANOBUF = 5;
    public static final int TYPE_PICK2K = 10;
    public static final int TYPE_CODA2K = 11;
    public static final int TYPE_HYP2000ARC = 14;
    public static final int TYPE_H71SUM2K = 15;
    public static final int TYPE_TRACEBUF2 = 19;
    public static final int TYPE_TRACEBUF = 20;
    public static final int TYPE_LPTRIG = 21;
    public static final int TYPE_CUBIC = 22;
    public static final int TYPE_CARLSTATRIG = 23;
    public static final int TYPE_TRIGLIST2K = 25;
    public static final int TYPE_TRACE_COMP_UA = 26;
    public static final int TYPE_STRONGMOTION = 27;
    public static final int TYPE_MAGNITUDE = 28;
    public static final int TYPE_STRONGMOTIONII = 29;
    private NumberFormat numberFormat;

    public MessageLogo() {
    }

    public int getType() {
        return this.type;
    }

    public MessageLogo(byte[] b) {
        String s = new String(b, 0, 9);
        this.installationID = Util.intToByte(Integer.parseInt(s.substring(0, 3).trim()));
        this.module = Util.intToByte(Integer.parseInt(s.substring(3, 6).trim()));
        this.type = Util.intToByte(Integer.parseInt(s.substring(6, 9).trim()));
    }

    public byte[] toDataStreamBytes() {
        if (this.numberFormat == null) {
            this.numberFormat = new DecimalFormat("000");
        }
        String message = String.valueOf(this.numberFormat.format(Util.byteToInt(this.installationID))) + this.numberFormat.format(Util.byteToInt(this.module)) + this.numberFormat.format(Util.byteToInt(this.type));
        byte[] b = new byte[9];
        int i = 0;
        while (i < b.length) {
            b[i] = Util.intToByte(message.charAt(i));
            ++i;
        }
        return b;
    }

    public String toString() {
        return "Message: type=" + this.type + " module=" + this.module + " inst=" + this.installationID;
    }
}

