/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm;

import gov.usgs.util.Util;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class MenuItem
implements Comparable<MenuItem> {
    private int pin;
    private String station;
    private String channel;
    private String network;
    private String location;
    private double startTime;
    private double endTime;
    private String dataType;

    public MenuItem(String item) {
        String[] ss = item.split(" ");
        this.pin = Integer.parseInt(ss[0]);
        this.station = ss[1];
        this.channel = ss[2];
        this.network = ss[3];
        if (ss.length == 7) {
            this.location = null;
            this.startTime = Double.parseDouble(ss[4]);
            this.endTime = Double.parseDouble(ss[5]);
            this.dataType = ss[6];
        } else if (ss.length == 8) {
            this.location = ss[4];
            this.startTime = Double.parseDouble(ss[5]);
            this.endTime = Double.parseDouble(ss[6]);
            this.dataType = ss[7];
        }
    }

    public int getPIN() {
        return this.pin;
    }

    public boolean isSCN(String s, String c, String n) {
        return this.station.equals(s) && this.channel.equals(c) && this.network.equals(n);
    }

    public String getSCNCode() {
        return String.valueOf(this.station) + "," + this.channel + "," + this.network;
    }

    public String getSCN() {
        return String.valueOf(this.station) + "_" + this.channel + "_" + this.network;
    }

    public String getSCNL() {
        return String.valueOf(this.station) + "_" + this.channel + "_" + this.network + "_" + (this.location == null ? "--" : this.location);
    }

    public String getWinstonChannel() {
        return String.valueOf(this.station) + "$" + this.channel + "$" + this.network + (this.location == null || this.location.equals("--") ? "" : "$" + this.location);
    }

    public String toFullString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        String t1 = df.format(Util.j2KToDate(Util.ewToJ2K(this.startTime)));
        String t2 = df.format(Util.j2KToDate(Util.ewToJ2K(this.endTime)));
        return String.format("%4d %16s %3s %14.2f (%s) %14.2f (%s)", this.pin, this.getSCNL(), this.dataType, this.startTime, t1, this.endTime, t2);
    }

    public String toString() {
        return this.getSCN();
    }

    @Override
    public int compareTo(MenuItem omi) {
        return this.getSCN().compareTo(omi.getSCN());
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public int getPin() {
        return this.pin;
    }

    public void setPin(int pin) {
        this.pin = pin;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public String getStation() {
        return this.station;
    }

    public void setStation(String station) {
        this.station = station;
    }

    public boolean match(String s, String c, String n, String l) {
        if (s != null && !s.equals("*") && !Pattern.matches(s, this.station)) {
            return false;
        }
        if (c != null && !c.equals("*") && !Pattern.matches(c, this.channel)) {
            return false;
        }
        if (n != null && !n.equals("*") && !Pattern.matches(n, this.network)) {
            return false;
        }
        if (l == null) {
            return this.location == null || this.location.equals("--");
        }
        if (l.equals("*")) {
            return true;
        }
        if (this.location == null) {
            return false;
        }
        return Pattern.matches(l, this.location);
    }
}

