/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.DataBlockette;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class Blockette2000
extends DataBlockette {
    private static final int BLOCKETTE_LENGTH = 4;
    private static final int OPAQUE_OFFSET = 6;
    private static final int NUM_HEADER_FIELD = 14;
    private static final int HEADER_FIELD = 15;
    private static final int FIXED_HEADER_LENGTH = 15;

    public Blockette2000(String[] headerFields, byte[] opaqueData) {
        super(opaqueData.length + 15 + Blockette2000.calcHeaderFieldLength(headerFields));
        System.arraycopy(Utility.intToByteArray(this.info.length), 2, this.info, 4, 2);
        this.info[14] = (byte)headerFields.length;
        int pos = 15;
        for (int i = 0; i < headerFields.length; ++i) {
            byte[] headerBytes;
            try {
                headerBytes = (headerFields[i] + '~').getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Java was unable to find the US-ASCII character encoding.");
            }
            System.arraycopy(headerBytes, 0, this.info, pos, headerBytes.length);
            pos += headerBytes.length;
        }
        this.info[6] = (byte)pos;
        System.arraycopy(opaqueData, 0, this.info, pos, opaqueData.length);
    }

    private static int calcHeaderFieldLength(String[] headerFields) {
        int len = headerFields.length;
        for (int i = 0; i < headerFields.length; ++i) {
            len += headerFields[i].length();
        }
        return len;
    }

    public Blockette2000(byte[] info, boolean swapBytes) {
        super(info, swapBytes);
    }

    public String getName() {
        return "Variable Length Opaque Data Blockette";
    }

    public int getSize() {
        return this.info.length;
    }

    public int getType() {
        return 2000;
    }

    public String getHeaderField(int i) {
        int start;
        int curHeader = 0;
        for (start = 15; start < this.info.length && curHeader != i; ++start) {
            if (this.info[start] != 126) continue;
            ++curHeader;
        }
        int end = start;
        while (this.info[end] != 126) {
            ++end;
        }
        return new String(this.info, start, end - start);
    }

    public int getNumHeaders() {
        return this.info[14];
    }

    public byte[] getOpaqueData() {
        byte[] opaque = new byte[this.info.length - this.info[6]];
        System.arraycopy(this.info, this.info[6], opaque, 0, opaque.length);
        return opaque;
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.println("Blockette2000");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Blockette2000) {
            byte[] oinfo = ((Blockette2000)o).info;
            if (this.info.length != oinfo.length) {
                return false;
            }
            for (int i = 0; i < oinfo.length; ++i) {
                if (this.info[i] == oinfo[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

