/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Blockette10;
import edu.sc.seis.seisFile.mseed.Blockette100;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Blockette1001;
import edu.sc.seis.seisFile.mseed.Blockette200;
import edu.sc.seis.seisFile.mseed.Blockette2000;
import edu.sc.seis.seisFile.mseed.Blockette5;
import edu.sc.seis.seisFile.mseed.Blockette8;
import edu.sc.seis.seisFile.mseed.BlocketteUnknown;
import edu.sc.seis.seisFile.mseed.DataBlocketteUnknown;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class Blockette {
    public abstract void writeASCII(PrintWriter var1) throws IOException;

    public void writeASCII(PrintWriter out, String indent) throws IOException {
        out.write(indent);
        this.writeASCII(out);
    }

    public static Blockette parseBlockette(int type, byte[] bytes, boolean swapBytes) throws IOException, SeedFormatException {
        switch (type) {
            case 5: {
                return new Blockette5(bytes);
            }
            case 8: {
                return new Blockette8(bytes);
            }
            case 10: {
                return new Blockette10(bytes);
            }
            case 100: {
                return new Blockette100(bytes, swapBytes);
            }
            case 200: {
                return new Blockette200(bytes, swapBytes);
            }
            case 1000: {
                return new Blockette1000(bytes, swapBytes);
            }
            case 1001: {
                return new Blockette1001(bytes, swapBytes);
            }
            case 2000: {
                return new Blockette2000(bytes, swapBytes);
            }
        }
        if (type < 100) {
            return new BlocketteUnknown(bytes, type, swapBytes);
        }
        return new DataBlocketteUnknown(bytes, type, swapBytes);
    }

    public abstract int getType();

    public abstract String getName();

    public abstract int getSize();

    public abstract byte[] toBytes();

    public String toString() {
        String s = this.getType() + ": " + this.getName();
        return s;
    }
}

