/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.liss;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Date;

public class Client {
    public static final int DEFAULT_PORT = 4000;

    public static void main(String[] args) throws IOException, SeedFormatException {
        String network = "IU";
        String station = "ANMO";
        String location = null;
        String channel = null;
        String host = network + "." + station + ".liss.org";
        String outFile = null;
        int port = 4000;
        int maxRecords = 10;
        boolean verbose = false;
        FilterOutputStream dos = null;
        PrintWriter out = new PrintWriter(System.out, true);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-n")) {
                network = args[i + 1];
                host = station + "." + network + ".liss.org";
                continue;
            }
            if (args[i].equals("-s")) {
                station = args[i + 1];
                host = station + "." + network + ".liss.org";
                continue;
            }
            if (args[i].equals("-l")) {
                location = args[i + 1];
                continue;
            }
            if (args[i].equals("-c")) {
                channel = args[i + 1];
                continue;
            }
            if (args[i].equals("-h")) {
                host = args[i + 1];
                String[] s = host.split("\\.");
                if (s.length != 4 || !s[2].equalsIgnoreCase("liss") || !s[3].equalsIgnoreCase("org")) continue;
                station = s[0];
                network = s[1];
                continue;
            }
            if (args[i].equals("-p")) {
                port = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].equals("-o")) {
                outFile = args[i + 1];
                dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
                continue;
            }
            if (args[i].equals("-m")) {
                maxRecords = Integer.parseInt(args[i + 1]);
                if (maxRecords >= -1) continue;
                maxRecords = -1;
                continue;
            }
            if (args[i].equals("--verbose")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("--version")) {
                out.println(BuildVersion.getDetailedVersion());
                System.exit(0);
                continue;
            }
            if (!args[i].equals("--help")) continue;
            out.println("java " + Client.class.getName() + " [[-n net][-s sta]|[-h host]][-l loc][-c chan][-p port][-o outfile][-m maxpackets][--verbose][--version][--help]");
            out.println(" host is formed from sta.net.liss.org if not given directly.");
            out.println(" See www.liss.org for more information.");
            System.exit(0);
        }
        if (verbose) {
            out.println("Connect to " + host + ":" + port);
        }
        Socket lissConnect = new Socket(host, port);
        DataInputStream ls = new DataInputStream(new BufferedInputStream(lissConnect.getInputStream(), 1024));
        int i = 0;
        try {
            while ((maxRecords == -1 || i < maxRecords) && lissConnect.isConnected()) {
                SeedRecord sr = SeedRecord.read(ls, 512);
                if (!(sr instanceof DataRecord)) {
                    System.err.println("None data record found, skipping...");
                    continue;
                }
                DataRecord dr = (DataRecord)sr;
                if (location != null && !location.equals(dr.getHeader().getLocationIdentifier()) || channel != null && !channel.equals(dr.getHeader().getChannelIdentifier())) continue;
                if (dos != null) {
                    dr.write((DataOutputStream)dos);
                }
                if (dos == null || verbose) {
                    dr.writeASCII(out, "    ");
                    out.flush();
                }
                ++i;
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        if (dos != null) {
            dos.close();
        }
        lissConnect.close();
        out.println("Finished: " + new Date());
    }
}

